/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel.upgrade;

import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.ItemDarkSteelArmor;
import crazypants.enderio.item.darksteel.upgrade.AbstractUpgrade;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ApiaristArmorUpgrade
extends AbstractUpgrade {
    private static String UPGRADE_NAME = "apiaristArmor";
    private static final String[] forestryItemNames = new String[]{"apiaristHelmet", "apiaristChest", "apiaristLegs", "apiaristBoots"};
    public static final ApiaristArmorUpgrade HELMET = new ApiaristArmorUpgrade(0);
    public static final ApiaristArmorUpgrade CHEST = new ApiaristArmorUpgrade(1);
    public static final ApiaristArmorUpgrade LEGS = new ApiaristArmorUpgrade(2);
    public static final ApiaristArmorUpgrade BOOTS = new ApiaristArmorUpgrade(3);
    private final int slot;

    public static ItemStack getApiaristArmor(int slot) {
        Item i = GameRegistry.findItem((String)"Forestry", (String)forestryItemNames[slot]);
        if (i != null) {
            return new ItemStack(i);
        }
        return null;
    }

    public static ApiaristArmorUpgrade loadFromItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.field_77990_d == null) {
            return null;
        }
        if (!stack.field_77990_d.func_74764_b("enderio.darksteel.upgrade." + UPGRADE_NAME)) {
            return null;
        }
        return new ApiaristArmorUpgrade((NBTTagCompound)stack.field_77990_d.func_74781_a("enderio.darksteel.upgrade." + UPGRADE_NAME));
    }

    public ApiaristArmorUpgrade(NBTTagCompound tag) {
        super(UPGRADE_NAME, tag);
        this.slot = tag.func_74762_e("slot");
    }

    public ApiaristArmorUpgrade(int slot) {
        super(UPGRADE_NAME, "enderio.darksteel.upgrade.apiaristArmor.".concat(ItemDarkSteelArmor.NAMES[slot]), ApiaristArmorUpgrade.getApiaristArmor(slot), Config.darkSteelApiaristArmorCost);
        this.slot = slot;
    }

    @Override
    public boolean canAddToItem(ItemStack stack) {
        if (stack == null || stack.func_77973_b() != ItemDarkSteelArmor.forArmorType(this.slot) || this.getUpgradeItem() == null) {
            return false;
        }
        ApiaristArmorUpgrade up = ApiaristArmorUpgrade.loadFromItem(stack);
        return up == null;
    }

    @Override
    public boolean hasUpgrade(ItemStack stack) {
        return super.hasUpgrade(stack) && stack.func_77973_b() == ItemDarkSteelArmor.forArmorType(this.slot);
    }

    @Override
    public void writeUpgradeToNBT(NBTTagCompound upgradeRoot) {
        upgradeRoot.func_74774_a("slot", (byte)this.slot);
    }

    @Override
    public ItemStack getUpgradeItem() {
        if (this.upgradeItem != null) {
            return this.upgradeItem;
        }
        this.upgradeItem = ApiaristArmorUpgrade.getApiaristArmor(this.slot);
        return this.upgradeItem;
    }

    @Override
    public String getUpgradeItemName() {
        if (this.getUpgradeItem() == null) {
            return "Apiarist Armor";
        }
        return super.getUpgradeItemName();
    }
}

