/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.ewysworkshop.page.unit;

import com.ewyboy.ewysworkshop.gui.GuiBase;
import com.ewyboy.ewysworkshop.gui.container.slot.SlotBase;
import com.ewyboy.ewysworkshop.item.Upgrade;
import com.ewyboy.ewysworkshop.network.data.DataType;
import com.ewyboy.ewysworkshop.network.data.DataUnit;
import com.ewyboy.ewysworkshop.page.Page;
import com.ewyboy.ewysworkshop.tileentity.TileEntityTable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public abstract class Unit {
    protected TileEntityTable table;
    protected Page page;
    protected int id;
    protected int x;
    protected int y;
    private static final int ARROW_SRC_X = 0;
    private static final int ARROW_SRC_Y = 34;
    private static final int ARROW_WIDTH = 22;
    private static final int ARROW_HEIGHT = 15;
    private static final int PROGRESS_OFFSET = -1;
    public static final int PRODUCTION_TIME = 400;
    private int productionProgress;
    private int chargeCount;
    public static final int CHARGES_PER_LEVEL = 4;
    private List<SlotBase> slots = new ArrayList<SlotBase>();
    private static final String NBT_CHARGED = "Charged";
    private static final String NBT_PROGRESS = "Progress";
    private static final int WORKING_COOLDOWN = 20;
    private int workingTicks;

    public Unit(TileEntityTable table, Page page, int id, int x, int y) {
        this.table = table;
        this.page = page;
        this.id = id;
        this.x = x;
        this.y = y;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiBase gui, int mX, int mY) {
        gui.prepare();
        int x = this.getArrowX();
        int y = this.getArrowY();
        gui.drawRect(this.x + x, this.y + y, 0, 34, 22, 15);
        int max = this.getMaxCharges();
        boolean charging = false;
        if (max > 0 && this.chargeCount > 0) {
            charging = true;
            GL11.glColor4f((float)0.11f, (float)0.35f, (float)0.17f, (float)1.0f);
            int count = Math.min(this.chargeCount, max);
            gui.drawRect(this.x + x, this.y + y, 0, 49, count * 22 / max, 15);
        }
        if (this.isCharging()) {
            charging = true;
            GL11.glColor4f((float)0.25f, (float)0.8f, (float)0.38f, (float)0.5f);
            GL11.glEnable((int)3042);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        int progress = Math.min(this.productionProgress, 400);
        gui.drawRect(this.x + x, this.y + y + -1, 0, 49, progress * 22 / 400, 15);
        GL11.glDisable((int)3042);
    }

    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiBase gui, int mX, int mY) {
    }

    protected abstract int getArrowX();

    protected abstract int getArrowY();

    protected void addSlot(SlotBase slot) {
        this.table.addSlot(slot);
        this.slots.add(slot);
    }

    public int getId() {
        return this.id;
    }

    public abstract int createSlots(int var1);

    protected boolean canCharge() {
        return this.chargeCount < this.getMaxCharges();
    }

    private int getMaxCharges() {
        return this.table.getUpgradePage().getUpgradeCount(this.id, Upgrade.CHARGED) * 4;
    }

    private boolean isCharging() {
        if (this.canCharge()) {
            ItemStack result = this.getProductionResult();
            if (result == null) {
                return true;
            }
            ItemStack output = this.table.func_70301_a(this.getOutputId());
            return !this.canMove(result, output);
        }
        return false;
    }

    private int getProductionSpeed(boolean charging) {
        int base = 1 + this.table.getUpgradePage().getUpgradeCount(this.id, Upgrade.SPEED);
        return charging ? base : base * 4;
    }

    private int getPowerConsumption(boolean charging) {
        int base = 1 + this.table.getUpgradePage().getUpgradeCount(this.id, Upgrade.SPEED) * 2;
        return charging ? base * 2 : base;
    }

    private void produce(ItemStack result, ItemStack output) {
        if (output == null) {
            this.table.func_70299_a(this.getOutputId(), result.func_77946_l());
        } else {
            this.table.func_70301_a((int)this.getOutputId()).field_77994_a += result.field_77994_a;
        }
        this.onProduction(result);
    }

    public void onUpdate() {
        if (!this.table.func_145831_w().field_72995_K) {
            boolean canCharge = false;
            boolean updatedProgress = false;
            boolean canReset = false;
            ItemStack result = this.getProductionResult();
            if (result != null) {
                boolean done;
                boolean updatedCharge = false;
                do {
                    done = true;
                    ItemStack output = this.table.func_70301_a(this.getOutputId());
                    if (this.canMove(result, output)) {
                        if (this.chargeCount > 0 && this.getMaxCharges() > 0) {
                            --this.chargeCount;
                            done = false;
                            updatedCharge = true;
                            this.produce(result, output);
                            result = this.getProductionResult();
                            continue;
                        }
                        int powerConsumption = this.getPowerConsumption(false);
                        if (this.table.getPower() < powerConsumption) continue;
                        this.table.setPower(this.table.getPower() - powerConsumption);
                        this.productionProgress += this.getProductionSpeed(false);
                        while (this.productionProgress >= 400) {
                            this.productionProgress -= 400;
                            this.produce(result, output);
                            result = this.getProductionResult();
                            if (this.canMove(result, output = this.table.func_70301_a(this.getOutputId()))) continue;
                        }
                        updatedProgress = true;
                        continue;
                    }
                    canCharge = true;
                } while (!done);
                if (updatedCharge) {
                    this.table.sendDataToAllPlayer(DataType.CHARGED, DataUnit.getId(this));
                }
            } else {
                canCharge = true;
                canReset = true;
            }
            if (canCharge && this.canCharge()) {
                boolean done = false;
                while (this.canCharge() && !done) {
                    done = true;
                    int powerConsumption = this.getPowerConsumption(true);
                    if (this.table.getPower() < powerConsumption) continue;
                    this.table.setPower(this.table.getPower() - powerConsumption);
                    this.productionProgress += this.getProductionSpeed(true);
                    if (this.productionProgress >= 400) {
                        this.productionProgress -= 400;
                        ++this.chargeCount;
                        this.table.sendDataToAllPlayer(DataType.CHARGED, DataUnit.getId(this));
                        done = false;
                    }
                    updatedProgress = true;
                }
            } else if (canReset && this.productionProgress != 0) {
                this.productionProgress = 0;
                updatedProgress = true;
            }
            if (updatedProgress) {
                this.workingTicks = 20;
                this.table.sendDataToAllPlayer(DataType.PROGRESS, DataUnit.getId(this));
            } else if (this.workingTicks > 0) {
                --this.workingTicks;
            }
        } else if (this.workingTicks > 0) {
            --this.workingTicks;
        }
    }

    public int getChargeCount() {
        return this.chargeCount;
    }

    public void setChargeCount(int chargeCount) {
        this.chargeCount = chargeCount;
    }

    protected abstract ItemStack getProductionResult();

    protected abstract int getOutputId();

    protected abstract void onProduction(ItemStack var1);

    protected boolean canMove(ItemStack source, ItemStack target) {
        if (source != null) {
            int resultSize;
            if (target == null) {
                return true;
            }
            if (target.func_77969_a(source) && ItemStack.func_77970_a((ItemStack)target, (ItemStack)source) && (resultSize = target.field_77994_a + source.field_77994_a) <= this.table.func_70297_j_() && resultSize <= target.func_77976_d()) {
                return true;
            }
        }
        return false;
    }

    public int getProductionProgress() {
        return this.productionProgress;
    }

    public void setProductionProgress(int productionProgress) {
        this.productionProgress = productionProgress;
        this.workingTicks = 20;
    }

    public abstract boolean isEnabled();

    public List<SlotBase> getSlots() {
        return this.slots;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74774_a(NBT_CHARGED, (byte)this.chargeCount);
        compound.func_74777_a(NBT_PROGRESS, (short)this.productionProgress);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.chargeCount = compound.func_74771_c(NBT_CHARGED);
        this.productionProgress = compound.func_74765_d(NBT_PROGRESS);
    }

    public boolean isWorking() {
        return this.workingTicks > 0;
    }
}

