/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.ewysworkshop.page.setting;

import com.ewyboy.ewysworkshop.item.Upgrade;
import com.ewyboy.ewysworkshop.page.setting.Direction;
import com.ewyboy.ewysworkshop.page.setting.Setting;
import com.ewyboy.ewysworkshop.page.setting.Transfer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;

public class Side {
    private int x;
    private int y;
    private Direction direction;
    private Setting setting;
    private Transfer input;
    private Transfer output;

    public Side(Setting setting, Direction direction, int x, int y) {
        this.x = x;
        this.y = y;
        this.direction = direction;
        this.setting = setting;
        this.input = new Transfer(true);
        this.output = new Transfer(false);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isOutputEnabled() {
        return this.output.isEnabled();
    }

    public boolean isInputEnabled() {
        return this.input.isEnabled();
    }

    public void setOutputEnabled(boolean value) {
        this.output.setEnabled(value);
    }

    public void setInputEnabled(boolean value) {
        this.input.setEnabled(value);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Setting getSetting() {
        return this.setting;
    }

    public Transfer getOutput() {
        return this.output;
    }

    public Transfer getInput() {
        return this.input;
    }

    public List<String> getDescription(boolean selected) {
        ArrayList<String> str = new ArrayList<String>();
        str.add(this.direction.getName());
        String description = this.direction.getDescription();
        if (description != null) {
            str.add(EnumChatFormatting.GRAY + description);
        }
        if (selected) {
            str.add(EnumChatFormatting.YELLOW + "Selected");
        }
        str.add("");
        this.addTransferInfo(str, this.input, EnumChatFormatting.BLUE);
        this.addTransferInfo(str, this.output, EnumChatFormatting.RED);
        return str;
    }

    private void addTransferInfo(List<String> lst, Transfer transfer, EnumChatFormatting color) {
        String name;
        String string = name = transfer.isInput() ? "Input" : "Output";
        if (transfer.isEnabled()) {
            lst.add(color + name + ": Enabled");
            if (transfer.isAuto() && this.setting.table.getUpgradePage().hasGlobalUpgrade(Upgrade.AUTO_TRANSFER)) {
                lst.add(EnumChatFormatting.GRAY + name + " Transfer: " + EnumChatFormatting.GREEN + "Auto");
            }
            if (transfer.hasFilter(this.setting.table)) {
                if (transfer.hasWhiteList()) {
                    lst.add(EnumChatFormatting.GRAY + name + " Filter: " + EnumChatFormatting.WHITE + "White list");
                } else {
                    lst.add(EnumChatFormatting.GRAY + name + " Filter: " + EnumChatFormatting.DARK_GRAY + "Black list");
                }
            }
        } else {
            lst.add(EnumChatFormatting.GRAY + name + ": Disabled");
        }
    }
}

