/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.ewysworkshop.network;

import com.ewyboy.ewysworkshop.gui.container.ContainerTable;
import com.ewyboy.ewysworkshop.network.DataReader;
import com.ewyboy.ewysworkshop.network.DataWriter;
import com.ewyboy.ewysworkshop.network.PacketId;
import com.ewyboy.ewysworkshop.tileentity.TileEntityTable;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.onPacket((FMLNetworkEvent.CustomPacketEvent)event, (EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, false);
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        this.onPacket((FMLNetworkEvent.CustomPacketEvent)event, (EntityPlayer)((NetHandlerPlayServer)event.handler).field_147369_b, true);
    }

    private void onPacket(FMLNetworkEvent.CustomPacketEvent event, EntityPlayer player, boolean onServer) {
        DataReader dr = new DataReader(event.packet.payload());
        PacketId id = dr.readEnum(PacketId.class);
        TileEntityTable table = null;
        if (id.isInInterface()) {
            if (player.field_71070_bA instanceof ContainerTable) {
                table = ((ContainerTable)player.field_71070_bA).getTable();
            }
        } else {
            int z;
            int y;
            World world = player.field_70170_p;
            int x = dr.readSignedInteger();
            TileEntity te = world.func_147438_o(x, y = dr.readSignedInteger(), z = dr.readSignedInteger());
            if (te instanceof TileEntityTable) {
                table = (TileEntityTable)te;
            }
        }
        if (table != null) {
            if (onServer) {
                table.receiveServerPacket(dr, id, player);
            } else {
                table.receiveClientPacket(dr, id);
            }
        }
    }

    public static DataWriter getWriter(TileEntityTable table, PacketId id) {
        DataWriter dw = new DataWriter();
        dw.writeEnum(id);
        if (!id.isInInterface()) {
            dw.writeInteger(table.field_145851_c);
            dw.writeInteger(table.field_145848_d);
            dw.writeInteger(table.field_145849_e);
        }
        return dw;
    }

    public static void sendToPlayer(DataWriter dw, EntityPlayer player) {
        dw.sendToPlayer((EntityPlayerMP)player);
    }

    public static void sendToServer(DataWriter dw) {
        dw.sendToServer();
    }
}

