/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.ewysworkshop.main;

import com.ewyboy.ewysworkshop.dependencies.nei.INEICallback;
import com.ewyboy.ewysworkshop.gui.GuiHandler;
import com.ewyboy.ewysworkshop.loaders.BlockLoader;
import com.ewyboy.ewysworkshop.loaders.ConfigLoader;
import com.ewyboy.ewysworkshop.loaders.CreativeTabLoader;
import com.ewyboy.ewysworkshop.loaders.ItemLoader;
import com.ewyboy.ewysworkshop.loaders.RecipeLoader;
import com.ewyboy.ewysworkshop.loaders.TileEntityLoader;
import com.ewyboy.ewysworkshop.network.PacketHandler;
import com.ewyboy.ewysworkshop.network.proxies.CommonProxy;
import com.ewyboy.ewysworkshop.util.Logger;
import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.concurrent.TimeUnit;

@Mod(modid="ewysworkshop", name="Ewy's Workshop", version="Ewy's Workshop-1.7.10-1.1.2", acceptedMinecraftVersions="[1.7.10]")
public class EwysWorkshop {
    public static INEICallback nei;
    public static FMLEventChannel packetHandler;
    @Mod.Instance(value="ewysworkshop")
    public static EwysWorkshop instance;
    @SidedProxy(modId="ewysworkshop", clientSide="com.ewyboy.ewysworkshop.network.proxies.ClientProxy", serverSide="com.ewyboy.ewysworkshop.network.proxies.CommonProxy")
    public static CommonProxy proxy;
    private double launchTime;

    public boolean isCoFHCoreLoaded() {
        if (Loader.isModLoaded((String)"CoFHCore")) {
            Logger.info("CoFH-Core found");
            if (ConfigLoader.RFSupport) {
                Logger.info("RF support activated");
                return true;
            }
        }
        return false;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Stopwatch watch = Stopwatch.createStarted();
        Logger.info("Pre-Initialization started");
        packetHandler = NetworkRegistry.INSTANCE.newEventDrivenChannel("EWorkshop");
        ConfigLoader.init(event.getSuggestedConfigurationFile());
        this.isCoFHCoreLoaded();
        new CreativeTabLoader();
        BlockLoader.loadBlocks();
        ItemLoader.loadItems();
        TileEntityLoader.loadTileEntities();
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"com.ewyboy.ewysworkshop.dependencies.waila.Waila.onWailaCall");
        this.launchTime += (double)watch.elapsed(TimeUnit.MILLISECONDS);
        Logger.info("Pre-Initialization finished after " + watch.elapsed(TimeUnit.MILLISECONDS) + "ms");
        Logger.info("Pre-Initialization process successfully done");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Stopwatch watch = Stopwatch.createStarted();
        Logger.info("Initialization started");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        packetHandler.register((Object)new PacketHandler());
        this.launchTime += (double)watch.elapsed(TimeUnit.MILLISECONDS);
        Logger.info("Initialization finished after " + watch.elapsed(TimeUnit.MILLISECONDS) + "ms");
        Logger.info("Initialization process successfully done");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Stopwatch watch = Stopwatch.createStarted();
        Logger.info("Post-Initialization started");
        RecipeLoader.loadRecipes();
        this.launchTime += (double)watch.elapsed(TimeUnit.MILLISECONDS);
        Logger.info("Post-Initialization finished after " + watch.elapsed(TimeUnit.MILLISECONDS) + "ms");
        Logger.info("Post-Initialization process successfully done");
        Logger.info("Total launch time for Ewy's Workshop : " + this.launchTime + " ms");
    }
}

