/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.ewysworkshop.loaders;

import com.ewyboy.ewysworkshop.item.Upgrade;
import com.ewyboy.ewysworkshop.util.Logger;
import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.common.config.Configuration;

@GameRegistry.ObjectHolder(value="ewysworkshop")
public final class ConfigLoader {
    private static final String MAX_COUNT_SUFFIX = " maximum amount";
    public static boolean doRenderSpinningEntity;
    public static boolean debugMode;
    public static boolean RFSupport;
    public static int MAX_POWER;
    public static int MAX_LAVA;
    public static int MAX_LAVA_DRAIN;
    public static int LAVA_EFFICIENCY;
    public static int SOLAR_GENERATION;
    public static int FUEL_DELAY;
    public static int RF_BUFFER;
    public static int RF_CONVERSION_RATE;
    public static int RF_CONVERSION_RATIO;

    public static void init(File file) {
        String spacing = "  ";
        Stopwatch watch = Stopwatch.createStarted();
        Logger.info("Loading configs started");
        Configuration config = new Configuration(file);
        Logger.info(spacing + "Reading " + config);
        config.load();
        MAX_POWER = config.getInt("Max Energy", "Tweaks", 30000, 0, Integer.MAX_VALUE, "Sets the max number of energy storage in the workshop table");
        Logger.info(spacing + "Max Power = " + MAX_POWER);
        MAX_LAVA = config.getInt("Max Lava", "Tweaks", 1000, 0, Integer.MAX_VALUE, "Sets the max number of lava energy storage in the workshop table");
        Logger.info(spacing + "Max Lava = " + MAX_LAVA);
        MAX_LAVA_DRAIN = config.getInt("Max Lava Drain", "Tweaks", 30, 0, Integer.MAX_VALUE, "Sets the max number of lava drained from the workshop table");
        Logger.info(spacing + "Max Lava Drain = " + MAX_LAVA_DRAIN);
        LAVA_EFFICIENCY = config.getInt("Max Efficiency", "Tweaks", 12, 0, Integer.MAX_VALUE, "Sets the lava efficacy in the workshop table");
        Logger.info(spacing + "Max Efficiency = " + LAVA_EFFICIENCY);
        SOLAR_GENERATION = config.getInt("Solar Generation", "Tweaks", 4, 0, Integer.MAX_VALUE, "Sets the amount of energy generated per tick with solar panel upgrade in the workshop table");
        Logger.info(spacing + "Solar Generation = " + SOLAR_GENERATION);
        FUEL_DELAY = config.getInt("Fuel Delay", "Tweaks", 15, 0, Integer.MAX_VALUE, "Sets the amount of ticks between each time the worktable consumes a fuel resource");
        Logger.info(spacing + "Fuel Delay = " + FUEL_DELAY);
        RF_BUFFER = config.getInt("RF Buffer Capacity", "Tweaks", 5000, 100, Integer.MAX_VALUE, "Sets the internal RF buffer capacity if CoFH Core is added");
        Logger.info(spacing + "RF Buffer Capacity = " + RF_BUFFER);
        RF_CONVERSION_RATE = config.getInt("RF Conversion Rate", "Tweaks", 50, 1, Integer.MAX_VALUE, "Sets the amount of RF converted to power on each fuel reload session (RF -> Power for each (Fuel Delay) tick)");
        Logger.info(spacing + "RF Conversion Rate = " + RF_CONVERSION_RATE);
        RF_CONVERSION_RATIO = config.getInt("RF Conversion Ratio", "Tweaks", 1, 1, Integer.MAX_VALUE, "Sets the ratio RF gets converted to power (RF Conversion Ratio for each Power (Default 10:1 ratio)) THIS CAN NOT BE LOWER OR EQUAL TO THE CONVERSION RATE!");
        Logger.info(spacing + "RF Conversion Ratio = " + RF_CONVERSION_RATIO + ":1 ratio");
        debugMode = config.getBoolean("Debug Mode", "Togglables", false, "Set true to turn on developer debug mode for debugging info in console");
        Logger.info(spacing + "Debug Mode = " + debugMode);
        RFSupport = config.getBoolean("RF Support", "Togglables", true, "Set to false to disable RF support if CoFH Core is added");
        Logger.info(spacing + "RF Support = " + RFSupport);
        for (Upgrade upgrade : Upgrade.values()) {
            Upgrade.MaxCount max = upgrade.getMaxCountObject();
            if (max.getConfigurableMax() <= 0) continue;
            upgrade.getMaxCountObject().setMax(config.getInt(upgrade.getName() + MAX_COUNT_SUFFIX, "Upgrades", max.getMax(), 0, max.getConfigurableMax(), "Max amount of the " + upgrade.getName() + " upgrade"));
            Logger.info(spacing + upgrade.getName() + " = " + max.getMax());
        }
        config.save();
        Logger.info(spacing + "Saving " + config);
        Logger.info("Loading configs finished after " + watch.elapsed(TimeUnit.MILLISECONDS) + "ms");
    }

    private ConfigLoader() {
    }
}

