/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.ewysworkshop.gui.menu;

import com.ewyboy.ewysworkshop.gui.GuiBase;
import com.ewyboy.ewysworkshop.gui.component.ArrowScroll;
import com.ewyboy.ewysworkshop.gui.component.Button;
import com.ewyboy.ewysworkshop.gui.component.TextBox;
import com.ewyboy.ewysworkshop.gui.menu.GuiMenu;
import com.ewyboy.ewysworkshop.network.data.DataType;
import com.ewyboy.ewysworkshop.page.setting.ItemSetting;
import com.ewyboy.ewysworkshop.page.setting.TransferMode;
import com.ewyboy.ewysworkshop.tileentity.TileEntityTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class GuiMenuItem
extends GuiMenu {
    private ItemSetting setting;
    private TransferMode mode;
    private ItemStack item;
    private List<ItemStack> playerItems;
    private List<ItemStack> searchItems;
    private boolean showPlayerItems;
    private List<ArrowScroll> arrows;
    private int page;
    private TextBox textBox;
    private static final int ITEMS_PER_ROW = 12;
    private static final int ITEM_ROWS = 7;
    private static final int VISIBLE_ITEMS = 84;
    private static final int ITEMS_X = 10;
    private static final int ITEMS_Y = 80;
    private static final int ITEMS_OFFSET = 20;
    private static final int ITEM_SIZE = 18;
    private static final int ITEM_X = 10;
    private static final int ITEM_Y = 10;

    public GuiMenuItem(TileEntityTable table, ItemSetting setting) {
        super(table);
        this.setting = setting;
        this.item = setting.getItem();
        this.mode = setting.getMode();
        this.textBox = new TextBox(10, 65){

            @Override
            public boolean isVisible() {
                return !GuiMenuItem.this.showPlayerItems;
            }

            @Override
            protected void textChanged() {
                GuiMenuItem.this.loadSearchItems();
            }
        };
        this.loadSearchItems();
        this.loadPlayerItems();
        this.arrows = new ArrayList<ArrowScroll>();
        this.arrows.add(new ArrowScroll(10, 50, 120){

            @Override
            public String getText() {
                return GuiMenuItem.this.showPlayerItems ? "List player items" : "Search for items";
            }

            @Override
            public void setId(int id) {
                GuiMenuItem.this.showPlayerItems = id == 0;
            }

            @Override
            public int getId() {
                return GuiMenuItem.this.showPlayerItems ? 0 : 1;
            }

            @Override
            public void onUpdate() {
                GuiMenuItem.this.page = 0;
            }

            @Override
            protected int getLength() {
                return 2;
            }
        });
        this.arrows.add(new ArrowScroll(30, 234, 70){

            @Override
            public String getText() {
                return "Page " + (GuiMenuItem.this.page + 1);
            }

            @Override
            public void setId(int id) {
                GuiMenuItem.this.page = id;
            }

            @Override
            public int getId() {
                return GuiMenuItem.this.page;
            }

            @Override
            public boolean isVisible() {
                return GuiMenuItem.this.getItemList().size() > 84;
            }

            @Override
            protected int getLength() {
                return (int)Math.ceil((float)GuiMenuItem.this.getItemList().size() / 84.0f);
            }
        });
        this.arrows.add(new ArrowScroll(10, 30, 120){

            @Override
            public String getText() {
                return GuiMenuItem.this.mode.toString();
            }

            @Override
            public void setId(int id) {
                GuiMenuItem.this.mode = TransferMode.values()[id];
            }

            @Override
            public int getId() {
                return GuiMenuItem.this.mode.ordinal();
            }

            @Override
            protected int getLength() {
                return TransferMode.values().length;
            }
        });
        this.buttons.add(new Button("Delete", 30, 11){

            @Override
            public void clicked() {
                GuiMenuItem.this.item = null;
            }

            @Override
            public boolean isVisible() {
                return GuiMenuItem.this.item != null;
            }
        });
    }

    private void loadSearchItems() {
        this.searchItems = new ArrayList<ItemStack>();
        String search = this.textBox.getText();
        if (search != null && !search.isEmpty()) {
            search = search.toLowerCase();
            ArrayList itemStacks = new ArrayList();
            for (Object obj : Item.field_150901_e) {
                Item item = (Item)obj;
                if (item == null || item.func_77640_w() == null) continue;
                item.func_150895_a(item, null, itemStacks);
            }
            for (ItemStack itemStack : itemStacks) {
                if (itemStack == null) continue;
                this.searchItems.add(itemStack);
            }
            Iterator<ItemStack> itemIterator = this.searchItems.iterator();
            while (itemIterator.hasNext()) {
                List description;
                ItemStack element = itemIterator.next();
                try {
                    description = element.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
                }
                catch (Throwable ex) {
                    itemIterator.remove();
                    continue;
                }
                Iterator descriptionIterator = description.iterator();
                boolean foundSequence = false;
                while (descriptionIterator.hasNext()) {
                    String line = ((String)descriptionIterator.next()).toLowerCase();
                    if (!line.contains(search)) continue;
                    foundSequence = true;
                    break;
                }
                if (foundSequence) continue;
                itemIterator.remove();
            }
        }
        this.fixPage();
    }

    private void loadPlayerItems() {
        this.playerItems = new ArrayList<ItemStack>();
        InventoryPlayer inventory = Minecraft.func_71410_x().field_71439_g.field_71071_by;
        int itemLength = inventory.func_70302_i_();
        for (int i = 0; i < itemLength; ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null) continue;
            item = item.func_77946_l();
            item.field_77994_a = 1;
            boolean exists = false;
            for (ItemStack other : this.playerItems) {
                if (!ItemStack.func_77989_b((ItemStack)item, (ItemStack)other)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.playerItems.add(item);
        }
        this.fixPage();
    }

    private void fixPage() {
        int maxPages = (int)Math.ceil((float)this.getItemList().size() / 84.0f);
        if (this.page >= maxPages) {
            this.page = maxPages - 1;
        }
        if (this.page < 0) {
            this.page = 0;
        }
    }

    private List<ItemStack> getItemList() {
        return this.showPlayerItems ? this.playerItems : this.searchItems;
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        gui.drawItemWithBackground(this.item, 10, 10, mX, mY);
        for (ArrowScroll arrow : this.arrows) {
            arrow.draw(gui, mX, mY);
        }
        int start = this.page * 84;
        int end = Math.min(start + 84, this.getItemList().size());
        for (int i = start; i < end; ++i) {
            int position = i - start;
            int x = position % 12;
            int y = position / 12;
            gui.drawItemWithBackground(this.getItemList().get(i), 10 + 20 * x, 80 + 20 * y, mX, mY);
        }
        this.textBox.draw(gui, mX, mY);
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY) {
        super.onClick(gui, mX, mY);
        for (ArrowScroll arrow : this.arrows) {
            arrow.onClick(gui, mX, mY);
        }
        int start = this.page * 84;
        int end = Math.min(start + 84, this.getItemList().size());
        for (int i = start; i < end; ++i) {
            int position = i - start;
            int x = position % 12;
            int y = position / 12;
            if (!gui.inBounds(10 + 20 * x, 80 + 20 * y, 18, 18, mX, mY)) continue;
            this.item = this.getItemList().get(i).func_77946_l();
            this.item.field_77994_a = 1;
            break;
        }
    }

    @Override
    public void onRelease(GuiBase gui, int mX, int mY) {
        super.onRelease(gui, mX, mY);
        for (ArrowScroll arrow : this.arrows) {
            arrow.onRelease();
        }
    }

    @Override
    public void onKeyStroke(GuiBase gui, char c, int k) {
        super.onKeyStroke(gui, c, k);
        this.textBox.onKeyStroke(gui, c, k);
    }

    @Override
    protected void save() {
        if (!ItemStack.func_77989_b((ItemStack)this.item, (ItemStack)this.setting.getItem())) {
            this.setting.setItem(this.item);
            this.table.updateServer(DataType.SIDE_FILTER, this.table.getTransferPage().getSyncId(this.setting));
        }
        if (this.mode != this.setting.getMode()) {
            this.setting.setMode(this.mode);
            this.table.updateServer(DataType.SIDE_FILTER_MODE, this.table.getTransferPage().getSyncId(this.setting));
        }
    }
}

