/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.ewysworkshop.gui.container.slot;

import com.ewyboy.ewysworkshop.gui.GuiBase;
import com.ewyboy.ewysworkshop.gui.container.slot.SlotTable;
import com.ewyboy.ewysworkshop.item.Upgrade;
import com.ewyboy.ewysworkshop.loaders.ItemLoader;
import com.ewyboy.ewysworkshop.page.Page;
import com.ewyboy.ewysworkshop.tileentity.TileEntityTable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SlotUpgrade
extends SlotTable {
    private SlotUpgrade main;
    private boolean isMain;
    private int upgradeSection;

    public SlotUpgrade(TileEntityTable table, Page page, int id, int x, int y, SlotUpgrade main, int upgradeSection) {
        super(table, page, id, x, y);
        this.main = main;
        this.isMain = main == null && upgradeSection < 4;
        this.upgradeSection = upgradeSection;
    }

    @Override
    public int getSlotStackLimit(ItemStack item) {
        if (this.isMain) {
            return 1;
        }
        Upgrade upgrade = ItemLoader.upgrade.getUpgrade(item);
        if (upgrade != null) {
            int count = this.table.getUpgradePage().getUpgradeCount(this.upgradeSection, upgrade);
            return Math.min(64, upgrade.getMaxCount() - count + (this.func_75211_c() != null ? this.func_75211_c().field_77994_a : 0));
        }
        return super.getSlotStackLimit(item);
    }

    @Override
    public boolean func_75214_a(ItemStack itemstack) {
        return super.func_75214_a(itemstack) && (itemstack == null || (this.isMain ? this.isMainItem(itemstack) : this.isUpgradeItem(itemstack)));
    }

    private boolean isUpgradeItem(ItemStack itemstack) {
        Upgrade upgrade = ItemLoader.upgrade.getUpgrade(itemstack);
        return upgrade != null && upgrade.isValid(this.main != null ? this.main.func_75211_c() : null);
    }

    private boolean isMainItem(ItemStack itemstack) {
        return itemstack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150462_ai)) || itemstack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150460_al));
    }

    @Override
    public boolean isEnabled() {
        return this.main == null || this.main.func_75216_d();
    }

    @Override
    public int getTextureIndex(GuiBase gui) {
        if (this.isMain) {
            if (this.func_75216_d()) {
                return 2;
            }
        } else {
            Upgrade upgrade = ItemLoader.upgrade.getUpgrade(this.func_75211_c());
            if (!(upgrade == null || this.table.getUpgradePage().getUpgradeCountRaw(this.upgradeSection, upgrade) <= upgrade.getMaxCount() && this.isUpgradeItem(this.func_75211_c()))) {
                return 4;
            }
        }
        return super.getTextureIndex(gui);
    }

    public void func_75218_e() {
        super.func_75218_e();
        this.table.onUpgradeChangeDistribute();
    }

    @Override
    public boolean canDragIntoSlot() {
        return this.isMain;
    }

    @Override
    public boolean canPickUpOnDoubleClick() {
        return false;
    }
}

