/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.ewysworkshop.gui.container;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public abstract class ContainerBase
extends Container {
    @SideOnly(value=Side.CLIENT)
    private short transactionID;
    private int dragMouseButton = -1;
    private int dragMode;
    private final Set<Slot> draggedSlots = new HashSet<Slot>();
    private Set<EntityPlayer> invalidPlayers = new HashSet<EntityPlayer>();
    private static final int MOUSE_LEFT_CLICK = 0;
    private static final int MOUSE_RIGHT_CLICK = 1;
    private static final int FAKE_SLOT_ID = -999;
    private static final int CLICK_MODE_NORMAL = 0;
    private static final int CLICK_MODE_SHIFT = 1;
    private static final int CLICK_MODE_KEY = 2;
    private static final int CLICK_MODE_PICK_ITEM = 3;
    private static final int CLICK_MODE_OUTSIDE = 4;
    private static final int CLICK_DRAG_RELEASE = 5;
    private static final int CLICK_MODE_DOUBLE_CLICK = 6;
    private static final int CLICK_DRAG_MODE_PRE = 0;
    private static final int CLICK_DRAG_MODE_SLOT = 1;
    private static final int CLICK_DRAG_MODE_POST = 2;

    private List<ItemStack> getItems() {
        return this.field_75153_a;
    }

    private List<Slot> getSlots() {
        return this.field_75151_b;
    }

    private List<ICrafting> getPlayers() {
        return this.field_75149_d;
    }

    protected Slot func_75146_a(Slot slot) {
        slot.field_75222_d = this.field_75151_b.size();
        this.getSlots().add(slot);
        this.getItems().add(null);
        return slot;
    }

    public void func_75132_a(ICrafting player) {
        if (this.getPlayers().contains(player)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.getPlayers().add(player);
        player.func_71110_a((Container)this, this.func_75138_a());
        this.func_75142_b();
    }

    public List func_75138_a() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Slot slot : this.getSlots()) {
            result.add(slot.func_75211_c());
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_82847_b(ICrafting player) {
        this.field_75149_d.remove(player);
    }

    public void func_75142_b() {
        for (int i = 0; i < this.getSlots().size(); ++i) {
            ItemStack slotItem = this.getSlots().get(i).func_75211_c();
            ItemStack cachedItem = this.getItems().get(i);
            if (ItemStack.func_77989_b((ItemStack)cachedItem, (ItemStack)slotItem)) continue;
            ItemStack newItem = slotItem == null ? null : slotItem.func_77946_l();
            this.getItems().set(i, newItem);
            for (ICrafting player : this.getPlayers()) {
                player.func_71111_a((Container)this, i, newItem);
            }
        }
    }

    public boolean func_75140_a(EntityPlayer player, int slotId) {
        return false;
    }

    public Slot func_75147_a(IInventory inventory, int slotId) {
        for (Slot slot : this.getSlots()) {
            if (!slot.func_75217_a(inventory, slotId)) continue;
            return slot;
        }
        return null;
    }

    public Slot func_75139_a(int slotId) {
        return this.getSlots().get(slotId);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotId) {
        return null;
    }

    public ItemStack func_75144_a(int slotId, int mouseButton, int clickMode, EntityPlayer player) {
        if (slotId < 0 && slotId != -999) {
            return null;
        }
        ItemStack result = null;
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        if (clickMode == 5) {
            int oldDragMode = this.dragMode;
            this.dragMode = mouseButton & 3;
            if ((oldDragMode != 1 || this.dragMode != 2) && oldDragMode != this.dragMode) {
                this.resetDragging();
            } else if (inventoryPlayer.func_70445_o() == null) {
                this.resetDragging();
            } else if (this.dragMode == 0) {
                this.dragMouseButton = mouseButton >> 2 & 3;
                if (this.dragMouseButton == 0 || this.dragMouseButton == 1) {
                    this.dragMode = 1;
                    this.draggedSlots.clear();
                } else {
                    this.resetDragging();
                }
            } else if (this.dragMode == 1) {
                Slot slot = this.func_75139_a(slotId);
                if (slot != null && ContainerBase.canItemBePickedUp(slot, inventoryPlayer.func_70445_o(), true) && slot.func_75214_a(inventoryPlayer.func_70445_o()) && inventoryPlayer.func_70445_o().field_77994_a > this.draggedSlots.size() && this.func_94531_b(slot)) {
                    this.draggedSlots.add(slot);
                }
            } else if (this.dragMode == 2) {
                if (!this.draggedSlots.isEmpty()) {
                    ItemStack playerItem = inventoryPlayer.func_70445_o().func_77946_l();
                    int remainingItems = inventoryPlayer.func_70445_o().field_77994_a;
                    for (Slot slot : this.draggedSlots) {
                        int currentCount;
                        if (slot == null || !ContainerBase.canItemBePickedUp(slot, inventoryPlayer.func_70445_o(), true) || !slot.func_75214_a(inventoryPlayer.func_70445_o()) || inventoryPlayer.func_70445_o().field_77994_a < this.draggedSlots.size() || !this.func_94531_b(slot)) continue;
                        int totalSize = currentCount = slot.func_75216_d() ? slot.func_75211_c().field_77994_a : 0;
                        totalSize = this.dragMouseButton == 0 ? (totalSize += MathHelper.func_76141_d((float)((float)playerItem.field_77994_a / (float)this.draggedSlots.size()))) : ++totalSize;
                        int maxSize = Math.min(playerItem.func_77976_d(), this.getSlotStackLimit(slot, playerItem));
                        if (totalSize > maxSize) {
                            totalSize = maxSize;
                        }
                        if (totalSize <= 0) continue;
                        remainingItems -= totalSize - currentCount;
                        ItemStack newItem = playerItem.func_77946_l();
                        newItem.field_77994_a = totalSize;
                        slot.func_75215_d(newItem);
                    }
                    playerItem.field_77994_a = remainingItems;
                    if (playerItem.field_77994_a <= 0) {
                        playerItem = null;
                    }
                    inventoryPlayer.func_70437_b(playerItem);
                }
                this.resetDragging();
            } else {
                this.resetDragging();
            }
        } else if (this.dragMode != 0) {
            this.resetDragging();
        } else if (!(clickMode != 0 && clickMode != 1 || mouseButton != 0 && mouseButton != 1)) {
            if (slotId == -999) {
                ItemStack dropItem = inventoryPlayer.func_70445_o();
                if (dropItem != null) {
                    if (mouseButton == 0) {
                        player.func_71019_a(dropItem, true);
                        inventoryPlayer.func_70437_b(null);
                    } else {
                        player.func_71019_a(dropItem.func_77979_a(1), true);
                        if (dropItem.field_77994_a == 0) {
                            inventoryPlayer.func_70437_b(null);
                        }
                    }
                }
            } else if (clickMode == 1) {
                ItemStack transferResult;
                Slot slot = this.func_75139_a(slotId);
                if (slot != null && slot.func_82869_a(player) && (transferResult = this.func_82846_b(player, slotId)) != null) {
                    Item item = transferResult.func_77973_b();
                    result = transferResult.func_77946_l();
                    if (slot.func_75211_c() != null && slot.func_75211_c().func_77973_b() == item) {
                        this.func_75133_b(slotId, mouseButton, true, player);
                    }
                }
            } else {
                Slot slot = this.func_75139_a(slotId);
                if (slot != null) {
                    ItemStack slotItem = slot.func_75211_c();
                    ItemStack playerItem = inventoryPlayer.func_70445_o();
                    if (slotItem != null) {
                        result = slotItem.func_77946_l();
                    }
                    if (playerItem == null || playerItem.field_77994_a > 0) {
                        if (slotItem == null) {
                            if (playerItem != null && slot.func_75214_a(playerItem)) {
                                int maxSize;
                                int moveSize = mouseButton == 0 ? playerItem.field_77994_a : 1;
                                if (moveSize > (maxSize = this.getSlotStackLimit(slot, playerItem))) {
                                    moveSize = maxSize;
                                }
                                if (moveSize > 0) {
                                    slot.func_75215_d(playerItem.func_77979_a(moveSize));
                                }
                            }
                        } else if (slot.func_82869_a(player)) {
                            int moveSize;
                            if (playerItem == null) {
                                int moveSize2 = mouseButton == 0 ? slotItem.field_77994_a : (slotItem.field_77994_a + 1) / 2;
                                playerItem = slot.func_75209_a(moveSize2);
                                inventoryPlayer.func_70437_b(playerItem);
                                if (slotItem.field_77994_a == 0) {
                                    slot.func_75215_d(null);
                                }
                                slot.func_82870_a(player, playerItem);
                            } else if (slot.func_75214_a(playerItem) && this.getSlotStackLimit(slot, playerItem) > slotItem.field_77994_a) {
                                if (slotItem.func_77973_b() == playerItem.func_77973_b() && slotItem.func_77960_j() == playerItem.func_77960_j() && ItemStack.func_77970_a((ItemStack)slotItem, (ItemStack)playerItem)) {
                                    int maxMoveSize;
                                    int moveSize3 = mouseButton == 0 ? playerItem.field_77994_a : 1;
                                    if (moveSize3 > (maxMoveSize = Math.min(this.getSlotStackLimit(slot, playerItem), playerItem.func_77976_d()) - slotItem.field_77994_a)) {
                                        moveSize3 = maxMoveSize;
                                    }
                                    if (moveSize3 > 0) {
                                        playerItem.func_77979_a(moveSize3);
                                        slotItem.field_77994_a += moveSize3;
                                    }
                                } else if (playerItem.field_77994_a <= this.getSlotStackLimit(slot, playerItem)) {
                                    slot.func_75215_d(playerItem);
                                    inventoryPlayer.func_70437_b(slotItem);
                                }
                            } else if (slotItem.func_77973_b() == playerItem.func_77973_b() && playerItem.func_77976_d() > 1 && (!slotItem.func_77981_g() || slotItem.func_77960_j() == playerItem.func_77960_j()) && ItemStack.func_77970_a((ItemStack)slotItem, (ItemStack)playerItem) && (moveSize = slotItem.field_77994_a) > 0 && moveSize + playerItem.field_77994_a <= playerItem.func_77976_d()) {
                                playerItem.field_77994_a += moveSize;
                                slotItem = slot.func_75209_a(moveSize);
                                if (slotItem.field_77994_a == 0) {
                                    slot.func_75215_d(null);
                                }
                                slot.func_82870_a(player, playerItem);
                            }
                        }
                    }
                    if (playerItem != null && playerItem.field_77994_a == 0) {
                        inventoryPlayer.func_70437_b(null);
                    }
                    slot.func_75218_e();
                }
            }
        } else if (slotId != -999) {
            if (clickMode == 2 && mouseButton >= 0 && mouseButton < 9) {
                Slot slot = this.func_75139_a(slotId);
                if (slot.func_82869_a(player)) {
                    ItemStack hotbarItem = inventoryPlayer.func_70301_a(mouseButton);
                    boolean hasHotbarItem = hotbarItem != null;
                    boolean hasPlayerSlot = slot.field_75224_c == inventoryPlayer;
                    boolean canMoveToSlot = slot.func_75214_a(hotbarItem);
                    if (slot.func_75216_d()) {
                        boolean flag;
                        boolean bl = flag = !hasHotbarItem || hasPlayerSlot && canMoveToSlot;
                        if (flag || inventoryPlayer.func_70447_i() >= 0) {
                            ItemStack slotItem = slot.func_75211_c();
                            inventoryPlayer.func_70299_a(mouseButton, slotItem.func_77946_l());
                            if (flag) {
                                slot.func_75209_a(slotItem.field_77994_a);
                                slot.func_75215_d(hotbarItem);
                                slot.func_82870_a(player, slotItem);
                            } else {
                                inventoryPlayer.func_70441_a(hotbarItem);
                                slot.func_75209_a(slotItem.field_77994_a);
                                slot.func_75215_d(null);
                                slot.func_82870_a(player, slotItem);
                            }
                        }
                    } else if (hasHotbarItem && canMoveToSlot) {
                        inventoryPlayer.func_70299_a(mouseButton, null);
                        slot.func_75215_d(hotbarItem);
                    }
                }
            } else if (clickMode == 3 && player.field_71075_bZ.field_75098_d && inventoryPlayer.func_70445_o() == null) {
                Slot slot = this.func_75139_a(slotId);
                if (slot != null && slot.func_75216_d()) {
                    ItemStack cloneItem = slot.func_75211_c().func_77946_l();
                    cloneItem.field_77994_a = cloneItem.func_77976_d();
                    inventoryPlayer.func_70437_b(cloneItem);
                }
            } else if (clickMode == 4 && inventoryPlayer.func_70445_o() == null) {
                Slot slot = this.func_75139_a(slotId);
                if (slot != null && slot.func_75216_d() && slot.func_82869_a(player)) {
                    ItemStack dropItem = slot.func_75209_a(mouseButton == 0 ? 1 : slot.func_75211_c().field_77994_a);
                    slot.func_82870_a(player, dropItem);
                    player.func_71019_a(dropItem, true);
                }
            } else if (clickMode == 6) {
                Slot slot = this.func_75139_a(slotId);
                ItemStack playerItem = inventoryPlayer.func_70445_o();
                if (!(playerItem == null || slot != null && slot.func_75216_d() && slot.func_82869_a(player))) {
                    int start = mouseButton == 0 ? 0 : this.getSlots().size() - 1;
                    int direction = mouseButton == 0 ? 1 : -1;
                    for (int iteration = 0; iteration < 2; ++iteration) {
                        for (int i = start; i >= 0 && i < this.field_75151_b.size() && playerItem.field_77994_a < playerItem.func_77976_d(); i += direction) {
                            boolean canTakeItem;
                            Slot loopSlot = this.func_75139_a(i);
                            boolean bl = canTakeItem = loopSlot.func_75216_d() && ContainerBase.canItemBePickedUp(loopSlot, playerItem, true) && loopSlot.func_82869_a(player) && this.canItemBePickedUpByDoubleClick(playerItem, loopSlot);
                            if (iteration == 0 && canTakeItem) {
                                boolean bl2 = canTakeItem = loopSlot.func_75211_c().field_77994_a != loopSlot.func_75211_c().func_77976_d();
                            }
                            if (!canTakeItem) continue;
                            int moveSize = Math.min(playerItem.func_77976_d() - playerItem.field_77994_a, loopSlot.func_75211_c().field_77994_a);
                            ItemStack moveItem = loopSlot.func_75209_a(moveSize);
                            playerItem.field_77994_a += moveSize;
                            if (moveItem.field_77994_a <= 0) {
                                loopSlot.func_75215_d(null);
                            }
                            loopSlot.func_82870_a(player, moveItem);
                        }
                    }
                }
                this.func_75142_b();
            }
        }
        return result;
    }

    public static boolean canItemBePickedUp(Slot slot, ItemStack playerItem, boolean partiallyMove) {
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotItem = slot.func_75211_c();
            if (playerItem != null && playerItem.func_77969_a(slotItem) && ItemStack.func_77970_a((ItemStack)slotItem, (ItemStack)playerItem)) {
                int moveSize = partiallyMove ? 0 : playerItem.field_77994_a;
                return slot.func_75211_c().field_77994_a + moveSize <= playerItem.func_77976_d();
            }
            return false;
        }
        return true;
    }

    protected boolean canItemBePickedUpByDoubleClick(ItemStack itemStack, Slot slot) {
        return true;
    }

    protected void func_75133_b(int slotId, int mouseButton, boolean flag, EntityPlayer player) {
        this.func_75144_a(slotId, mouseButton, 1, player);
    }

    public void func_75134_a(EntityPlayer player) {
        InventoryPlayer inventoryplayer = player.field_71071_by;
        if (inventoryplayer.func_70445_o() != null) {
            player.func_71019_a(inventoryplayer.func_70445_o(), false);
            inventoryplayer.func_70437_b(null);
        }
    }

    public void func_75130_a(IInventory inventory) {
        this.func_75142_b();
    }

    public void func_75141_a(int slotId, ItemStack item) {
        this.func_75139_a(slotId).func_75215_d(item);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75131_a(ItemStack[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.func_75141_a(i, items[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
    }

    @SideOnly(value=Side.CLIENT)
    public short func_75136_a(InventoryPlayer inventory) {
        this.transactionID = (short)(this.transactionID + 1);
        return this.transactionID;
    }

    protected boolean isPlayerValid(EntityPlayer player) {
        return !this.invalidPlayers.contains(player);
    }

    protected void setValidState(EntityPlayer player, boolean valid) {
        if (valid) {
            this.invalidPlayers.remove(player);
        } else {
            this.invalidPlayers.add(player);
        }
    }

    public abstract boolean func_75145_c(EntityPlayer var1);

    protected boolean func_75135_a(ItemStack item, int start, int end, boolean invert) {
        ItemStack slotItem;
        Slot slot;
        boolean moved = false;
        int index = start;
        if (invert) {
            index = end - 1;
        }
        if (item.func_77985_e()) {
            while (item.field_77994_a > 0 && (!invert && index < end || invert && index >= start)) {
                slot = this.func_75139_a(index);
                slotItem = slot.func_75211_c();
                if (slotItem != null && slotItem.func_77973_b() == item.func_77973_b() && (!item.func_77981_g() || item.func_77960_j() == slotItem.func_77960_j()) && ItemStack.func_77970_a((ItemStack)item, (ItemStack)slotItem)) {
                    int newSize = slotItem.field_77994_a + item.field_77994_a;
                    if (newSize <= item.func_77976_d()) {
                        item.field_77994_a = 0;
                        slotItem.field_77994_a = newSize;
                        slot.func_75218_e();
                        moved = true;
                    } else if (slotItem.field_77994_a < item.func_77976_d()) {
                        item.field_77994_a -= item.func_77976_d() - slotItem.field_77994_a;
                        slotItem.field_77994_a = item.func_77976_d();
                        slot.func_75218_e();
                        moved = true;
                    }
                }
                index += invert ? -1 : 1;
            }
        }
        if (item.field_77994_a > 0) {
            for (index = invert ? end - 1 : start; !invert && index < end || invert && index >= start; index += invert ? -1 : 1) {
                slot = this.func_75139_a(index);
                slotItem = slot.func_75211_c();
                if (slotItem != null) continue;
                slot.func_75215_d(item.func_77946_l());
                slot.func_75218_e();
                item.field_77994_a = 0;
                moved = true;
                break;
            }
        }
        return moved;
    }

    protected void resetDragging() {
        this.dragMode = 0;
        this.draggedSlots.clear();
    }

    public boolean func_94531_b(Slot slot) {
        return true;
    }

    protected int getSlotStackLimit(Slot slot, ItemStack itemStack) {
        return slot.func_75219_a();
    }

    public final boolean func_94530_a(ItemStack item, Slot slot) {
        return this.canItemBePickedUpByDoubleClick(item, slot);
    }

    public final boolean func_75129_b(EntityPlayer player) {
        return this.isPlayerValid(player);
    }

    public final void func_75128_a(EntityPlayer player, boolean valid) {
        this.setValidState(player, valid);
    }

    protected final void func_94533_d() {
        this.resetDragging();
    }
}

