/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.ewysworkshop.gui;

import com.ewyboy.ewysworkshop.gui.GuiBase;
import com.ewyboy.ewysworkshop.gui.container.ContainerTable;
import com.ewyboy.ewysworkshop.gui.container.slot.SlotBase;
import com.ewyboy.ewysworkshop.item.Upgrade;
import com.ewyboy.ewysworkshop.network.PacketHandler;
import com.ewyboy.ewysworkshop.network.PacketId;
import com.ewyboy.ewysworkshop.network.data.DataType;
import com.ewyboy.ewysworkshop.page.Page;
import com.ewyboy.ewysworkshop.tileentity.TileEntityTable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class GuiTable
extends GuiBase {
    private TileEntityTable table;
    private List<SlotBase> slots;
    private static final int HEADER_SRC_X = 0;
    private static final int HEADER_SRC_Y = 0;
    private static final int HEADER_FULL_WIDTH = 42;
    private static final int HEADER_WIDTH = 38;
    private static final int HEADER_HEIGHT = 17;
    private static final int HEADER_X = 3;
    private static final int HEADER_Y = 173;
    private static final int HEADER_TEXT_Y = 7;
    private static final int SLOT_SRC_X = 42;
    private static final int SLOT_SRC_Y = 0;
    private static final int SLOT_SIZE = 18;
    private static final int SLOT_OFFSET = -1;
    private static final int SLOT_BIG_SIZE = 26;
    private static final int SLOT_BIG_OFFSET = -5;
    private static final int POWER_X = 225;
    private static final int POWER_Y = 173;
    private static final int POWER_WIDTH = 18;
    private static final int POWER_HEIGHT = 50;
    private static final int POWER_INNER_WIDTH = 16;
    private static final int POWER_INNER_HEIGHT = 48;
    private static final int POWER_INNER_SRC_X = 0;
    private static final int POWER_INNER_SRC_Y = 64;
    private static final int POWER_SRC_X = 32;
    private static final int POWER_SRC_Y = 62;
    private static final int POWER_INNER_OFFSET_X = 1;
    private static final int POWER_INNER_OFFSET_Y = 1;
    private boolean closed;

    public GuiTable(TileEntityTable table, EntityPlayer player) {
        super(new ContainerTable(table, player));
        this.field_146999_f = 256;
        this.field_147000_g = 256;
        this.slots = new ArrayList<SlotBase>();
        for (Object obj : this.field_147002_h.field_75151_b) {
            SlotBase slot = (SlotBase)((Object)obj);
            this.slots.add(slot);
            slot.updateClient(slot.isVisible());
        }
        this.table = table;
    }

    protected void func_146976_a(float f, int mX, int mY) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        mX -= this.field_147003_i;
        mY -= this.field_147009_r;
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        GL11.glColor3ub((byte)-1, (byte)-1, (byte)-1);
        this.func_73729_b(0, 0, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawSlots();
        if (this.table.getMenu() == null) {
            this.drawPageHeaders(mX, mY);
            this.drawPower(mX, mY);
            this.table.getSelectedPage().draw(this, mX, mY);
        } else {
            this.table.getMenu().draw(this, mX, mY);
        }
        GL11.glPopMatrix();
    }

    protected void func_73864_a(int mX, int mY, int button) {
        super.func_73864_a(mX, mY, button);
        mX -= this.field_147003_i;
        mY -= this.field_147009_r;
        if (this.table.getMenu() == null) {
            this.clickPageHeader(mX, mY);
            this.table.getSelectedPage().onClick(this, mX, mY, button);
        } else {
            this.table.getMenu().onClick(this, mX, mY);
        }
    }

    protected void func_146286_b(int mX, int mY, int button) {
        super.func_146286_b(mX, mY, button);
        mX -= this.field_147003_i;
        mY -= this.field_147009_r;
        if (this.table.getMenu() == null) {
            this.table.getSelectedPage().onRelease(this, mX, mY, button);
        } else {
            this.table.getMenu().onRelease(this, mX, mY);
        }
    }

    protected void func_73869_a(char c, int k) {
        if (this.table.getMenu() == null) {
            super.func_73869_a(c, k);
        } else if (k == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else {
            this.table.getMenu().onKeyStroke(this, c, k);
        }
    }

    private void drawPageHeaders(int mX, int mY) {
        for (int i = 0; i < this.table.getPages().size(); ++i) {
            Page page = this.table.getPages().get(i);
            boolean selected = page.equals(this.table.getSelectedPage());
            int srcY = selected ? 17 : 0;
            int y = 173 + 17 * i;
            boolean hover = this.inBounds(3, y, 42, 17, mX, mY);
            int width = hover ? 42 : 38;
            int offset = 42 - width;
            this.prepare();
            this.drawRect(3, y, 0 + offset, srcY, width, 17);
            int invertedOffset = 4 - offset;
            this.drawCenteredString(page.getName(), 3 + invertedOffset, y + 7, 38, 0.7f, 0x404040);
        }
    }

    private void clickPageHeader(int mX, int mY) {
        for (int i = 0; i < this.table.getPages().size(); ++i) {
            Page page = this.table.getPages().get(i);
            int y = 173 + 17 * i;
            if (!this.inBounds(3, y, 42, 17, mX, mY)) continue;
            this.table.setSelectedPage(page);
            this.table.updateServer(DataType.PAGE);
            break;
        }
    }

    private void drawSlots() {
        this.prepare();
        for (SlotBase slot : this.slots) {
            boolean visible = slot.isVisible();
            slot.updateClient(visible);
            if (!visible) continue;
            boolean isBig = slot.isBig();
            int srcY = isBig ? 18 : 0;
            int size = isBig ? 26 : 18;
            int offset = isBig ? -5 : -1;
            this.drawRect(slot.getX() + offset, slot.getY() + offset, 42 + slot.getTextureIndex(this) * size, srcY, size, size);
        }
    }

    private void drawPower(int mX, int mY) {
        this.prepare();
        this.drawRect(226, 174, 16, 64, 16, 48);
        int height = 48 * this.table.getPower() / TileEntityTable.MAX_POWER;
        int offset = 48 - height;
        this.drawRect(226, 174 + offset, 0, 64 + offset, 16, height);
        this.drawRect(225, 174 + offset - 1, 32, 61, 18, 1);
        int srcX = 32;
        boolean hover = this.inBounds(225, 173, 18, 50, mX, mY);
        if (hover) {
            srcX += 18;
        }
        this.drawRect(225, 173, srcX, 62, 18, 50);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("power", this.table.getPower());
        int power = tag.func_74762_e("power");
        EnumChatFormatting color = (double)power <= (double)TileEntityTable.MAX_POWER * 12.5 / 100.0 ? EnumChatFormatting.DARK_RED : (power <= TileEntityTable.MAX_POWER * 25 / 100 ? EnumChatFormatting.RED : ((double)power <= (double)TileEntityTable.MAX_POWER * 37.5 / 100.0 ? EnumChatFormatting.GOLD : (power <= TileEntityTable.MAX_POWER * 50 / 100 ? EnumChatFormatting.YELLOW : ((double)power <= (double)TileEntityTable.MAX_POWER * 62.5 / 100.0 ? EnumChatFormatting.DARK_GREEN : (power <= TileEntityTable.MAX_POWER * 75 / 100 ? EnumChatFormatting.GREEN : ((double)power <= (double)TileEntityTable.MAX_POWER * 87.5 / 100.0 ? EnumChatFormatting.DARK_AQUA : EnumChatFormatting.AQUA))))));
        if (hover) {
            String str = color + "Power: " + this.formatNumber(this.table.getPower()) + "/" + this.formatNumber(TileEntityTable.MAX_POWER);
            if (this.table.getLava() > 0 && this.table.getUpgradePage().hasGlobalUpgrade(Upgrade.LAVA)) {
                str = str + "\n" + EnumChatFormatting.GOLD + "Lava: " + this.formatNumber(this.table.getLava()) + "/" + this.formatNumber(TileEntityTable.MAX_LAVA);
            }
            if (this.table.getUpgradePage().hasGlobalUpgrade(Upgrade.SOLAR)) {
                str = str + "\n" + EnumChatFormatting.YELLOW + "Solar panel: " + (this.table.isLitAndCanSeeTheSky() ? "Lit" : EnumChatFormatting.GRAY + "Dark");
            }
            this.drawMouseOver(str);
        }
    }

    private String formatNumber(int number) {
        return String.format("%,d", number).replace('\u00a0', ' ');
    }

    public void func_146281_b() {
        super.func_146281_b();
        PacketHandler.sendToServer(PacketHandler.getWriter(this.table, PacketId.CLOSE));
        this.closed = true;
    }

    public void func_146280_a(Minecraft minecraft, int width, int height) {
        super.func_146280_a(minecraft, width, height);
        if (this.closed) {
            PacketHandler.sendToServer(PacketHandler.getWriter(this.table, PacketId.RE_OPEN));
            this.closed = false;
        }
    }

    public TileEntityTable getTable() {
        return this.table;
    }
}

