/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.ewysworkshop.block;

import com.ewyboy.ewysworkshop.loaders.ConfigLoader;
import com.ewyboy.ewysworkshop.loaders.CreativeTabLoader;
import com.ewyboy.ewysworkshop.tileentity.BaseTileEntity;
import com.ewyboy.ewysworkshop.util.Logger;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BaseBlock
extends BlockContainer {
    public static int blockFacing;

    public BaseBlock() {
        this(Material.field_151576_e);
    }

    public BaseBlock(Material material) {
        super(material);
        this.func_149647_a(CreativeTabLoader.EwysWorkshopTab);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        this.dropInventory(world, x, y, z);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLivingBase, itemStack);
        if (world.func_147438_o(x, y, z) instanceof BaseTileEntity || world.func_147439_a(x, y, z) instanceof Block) {
            ForgeDirection direction = null;
            int facing = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    direction = ForgeDirection.NORTH;
                    break;
                }
                case 1: {
                    direction = ForgeDirection.EAST;
                    break;
                }
                case 2: {
                    direction = ForgeDirection.SOUTH;
                    break;
                }
                case 3: {
                    direction = ForgeDirection.WEST;
                    break;
                }
                default: {
                    direction = null;
                }
            }
            ((BaseTileEntity)world.func_147438_o(x, y, z)).setOrientation(direction);
            blockFacing = direction.ordinal();
            if (ConfigLoader.debugMode) {
                Logger.info(direction.name());
            }
        }
    }

    protected void dropInventory(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemStack = inventory.func_70301_a(i);
                if (itemStack == null || itemStack.field_77994_a <= 0) continue;
                Random random = new Random();
                float dX = random.nextFloat() * 0.8f + 0.1f;
                float dY = random.nextFloat() * 0.8f + 0.1f;
                float dZ = random.nextFloat() * 0.8f + 0.1f;
                EntityItem entityItem = new EntityItem(world, (double)((float)x + dX), (double)((float)y + dY), (double)((float)z + dZ), itemStack.func_77946_l());
                if (itemStack.func_77942_o()) {
                    entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
                }
                float factor = 0.05f;
                entityItem.field_70159_w = random.nextGaussian() * (double)factor;
                entityItem.field_70159_w = random.nextGaussian() * (double)factor + (double)0.2f;
                entityItem.field_70159_w = random.nextGaussian() * (double)factor;
                world.func_72838_d((Entity)entityItem);
                itemStack.field_77994_a = 0;
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return null;
    }
}

