/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.idsu;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.StringUtils;
import reborncore.common.misc.Functions;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;
import techreborn.powerSystem.TilePowerAcceptor;
import techreborn.tiles.idsu.IDSUManager;

public class TileIDSU
extends TilePowerAcceptor {
    public String ownerUdid;
    public int tier;
    public int output;
    public double maxStorage;
    private double euLastTick = 0.0;
    private double euChange;
    private int ticks;

    @Override
    public double getEnergy() {
        if (this.ownerUdid == null && StringUtils.isBlank((CharSequence)this.ownerUdid) || StringUtils.isEmpty((CharSequence)this.ownerUdid)) {
            return 0.0;
        }
        return IDSUManager.INSTANCE.getSaveDataForWorld((World)this.field_145850_b, (String)this.ownerUdid).storedPower;
    }

    @Override
    public void setEnergy(double energy) {
        if (this.ownerUdid == null && StringUtils.isBlank((CharSequence)this.ownerUdid) || StringUtils.isEmpty((CharSequence)this.ownerUdid)) {
            return;
        }
        IDSUManager.INSTANCE.getSaveDataForWorld((World)this.field_145850_b, (String)this.ownerUdid).storedPower = energy;
    }

    @Override
    public void readFromNBTWithoutCoords(NBTTagCompound tag) {
    }

    @Override
    public void writeToNBTWithoutCoords(NBTTagCompound tag) {
    }

    @Override
    public double getMaxPower() {
        return 1.0E9;
    }

    @Override
    public boolean canAcceptEnergy(ForgeDirection direction) {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) != Functions.getIntDirFromDirection((ForgeDirection)direction);
    }

    @Override
    public boolean canProvideEnergy(ForgeDirection direction) {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == Functions.getIntDirFromDirection((ForgeDirection)direction);
    }

    @Override
    public double getMaxOutput() {
        return this.output;
    }

    @Override
    public double getMaxInput() {
        return this.maxStorage;
    }

    public TileIDSU(int tier1, int output1, int maxStorage1) {
        super(tier1);
        this.tier = tier1;
        this.output = output1;
        this.maxStorage = maxStorage1;
    }

    public TileIDSU() {
        this(5, 2048, 100000000);
    }

    public float getChargeLevel() {
        float ret = (float)this.getEnergy() / (float)this.maxStorage;
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.ownerUdid = nbttagcompound.func_74779_i("ownerUdid");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.ownerUdid == null && StringUtils.isBlank((CharSequence)this.ownerUdid) || StringUtils.isEmpty((CharSequence)this.ownerUdid)) {
            return;
        }
        nbttagcompound.func_74778_a("ownerUdid", this.ownerUdid);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.ticks == ConfigTechReborn.aveargeEuOutTickTime) {
            this.euChange = -1.0;
            this.ticks = 0;
        } else {
            ++this.ticks;
            this.euChange += this.getEnergy() - this.euLastTick;
            if (this.euLastTick == this.getEnergy()) {
                this.euChange = 0.0;
            }
        }
        this.euLastTick = this.getEnergy();
        boolean needsInvUpdate = false;
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        NBTTagCompound tileEntity = new NBTTagCompound();
        ItemStack dropStack = new ItemStack(ModBlocks.Idsu, 1);
        this.func_145841_b(tileEntity);
        dropStack.func_77982_d(new NBTTagCompound());
        dropStack.field_77990_d.func_74782_a("tileEntity", (NBTBase)tileEntity);
        return dropStack;
    }

    public double getEuChange() {
        if (this.euChange == -1.0) {
            return -1.0;
        }
        return this.euChange / (double)this.ticks;
    }

    public void handleGuiInputFromClient(int id) {
        if (id == 0) {
            this.output += 256;
        }
        if (id == 1) {
            this.output += 64;
        }
        if (id == 2) {
            this.output -= 64;
        }
        if (id == 3) {
            this.output -= 256;
        }
        if (this.output > 4096) {
            this.output = 4096;
        }
        if (this.output <= -1) {
            this.output = 0;
        }
    }
}

