/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IWrenchable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.RollingMachineRecipe;
import techreborn.init.ModBlocks;
import techreborn.powerSystem.TilePowerAcceptor;

public class TileRollingMachine
extends TilePowerAcceptor
implements IWrenchable,
IInventory {
    public Inventory inventory = new Inventory(3, "TileRollingMachine", 64);
    public final InventoryCrafting craftMatrix = new InventoryCrafting((Container)new RollingTileContainer(), 3, 3);
    public boolean isRunning;
    public int tickTime;
    public int runTime = 250;
    public ItemStack currentRecipe;
    public int euTick = 5;

    @Override
    public double getMaxPower() {
        return 100000.0;
    }

    public void charge(int slot) {
        if (this.func_70301_a(slot) != null && this.func_70301_a(slot).func_77973_b() instanceof IElectricItem && this.getEnergy() != this.getMaxPower()) {
            ItemStack stack = this.inventory.func_70301_a(slot);
            double MaxCharge = ((IElectricItem)stack.func_77973_b()).getMaxCharge(stack);
            double CurrentCharge = ElectricItem.manager.getCharge(stack);
            if (CurrentCharge != 0.0) {
                ElectricItem.manager.discharge(stack, 5.0, 4, false, false, false);
                this.addEnergy(5.0);
            }
        }
    }

    @Override
    public boolean canAcceptEnergy(ForgeDirection direction) {
        return true;
    }

    @Override
    public boolean canProvideEnergy(ForgeDirection direction) {
        return false;
    }

    @Override
    public double getMaxOutput() {
        return 0.0;
    }

    @Override
    public double getMaxInput() {
        return 64.0;
    }

    public TileRollingMachine() {
        super(1);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.charge(2);
        if (!this.field_145850_b.field_72995_K) {
            this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b);
            if (this.currentRecipe != null && this.canMake() && this.tickTime >= this.runTime) {
                this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b);
                if (this.currentRecipe != null) {
                    boolean hasCrafted = false;
                    if (this.inventory.func_70301_a(0) == null) {
                        this.inventory.func_70299_a(0, this.currentRecipe);
                        this.tickTime = -1;
                        hasCrafted = true;
                    } else if (this.inventory.func_70301_a((int)0).field_77994_a + this.currentRecipe.field_77994_a <= this.currentRecipe.func_77976_d()) {
                        ItemStack stack = this.inventory.func_70301_a(0);
                        stack.field_77994_a += this.currentRecipe.field_77994_a;
                        this.inventory.func_70299_a(0, stack);
                        this.tickTime = -1;
                        hasCrafted = true;
                    }
                    if (hasCrafted) {
                        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                            this.craftMatrix.func_70298_a(i, 1);
                        }
                        this.currentRecipe = null;
                    }
                }
            }
            if (this.currentRecipe != null && this.canUseEnergy(this.euTick) && this.tickTime < this.runTime) {
                this.useEnergy(this.euTick);
                ++this.tickTime;
            }
            if (this.currentRecipe == null) {
                this.tickTime = -1;
            }
        } else {
            this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b);
            if (this.currentRecipe != null) {
                this.inventory.func_70299_a(1, this.currentRecipe);
            } else {
                this.inventory.func_70299_a(1, null);
            }
        }
    }

    public boolean canMake() {
        return RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b) != null;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public short getFacing() {
        return 0;
    }

    @Override
    public void setFacing(short facing) {
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.RollingMachine, 1);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
        ItemUtils.readInvFromNBT((IInventory)this.craftMatrix, (String)"Crafting", (NBTTagCompound)tagCompound);
        this.isRunning = tagCompound.func_74767_n("isRunning");
        this.tickTime = tagCompound.func_74762_e("tickTime");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
        ItemUtils.writeInvToNBT((IInventory)this.craftMatrix, (String)"Crafting", (NBTTagCompound)tagCompound);
        this.writeUpdateToNBT(tagCompound);
    }

    public void writeUpdateToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74757_a("isRunning", this.isRunning);
        tagCompound.func_74768_a("tickTime", this.tickTime);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventory.func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    private static class RollingTileContainer
    extends Container {
        private RollingTileContainer() {
        }

        public boolean func_75145_c(EntityPlayer entityplayer) {
            return true;
        }
    }
}

