/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import ic2.api.tile.IWrenchable;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import reborncore.api.IListInfoProvider;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileMachineBase;

public class TileQuantumTank
extends TileMachineBase
implements IFluidHandler,
IInventory,
IWrenchable,
IListInfoProvider {
    public Tank tank = new Tank("TileQuantumTank", Integer.MAX_VALUE, (TileEntity)this);
    public Inventory inventory = new Inventory(3, "TileQuantumTank", 64);

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readFromNBTWithoutCoords(tagCompound);
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tagCompound) {
        this.tank.readFromNBT(tagCompound);
        this.inventory.readFromNBT(tagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.writeToNBTWithoutCoords(tagCompound);
    }

    public void writeToNBTWithoutCoords(NBTTagCompound tagCompound) {
        this.tank.writeToNBT(tagCompound);
        this.inventory.writeToNBT(tagCompound);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            FluidUtils.drainContainers((IFluidHandler)this, (IInventory)this.inventory, (int)0, (int)1);
            FluidUtils.fillContainers((IFluidHandler)this, (IInventory)this.inventory, (int)0, (int)1, (Fluid)this.tank.getFluidType());
            if (this.tank.getFluidType() != null && this.func_70301_a(2) == null) {
                this.inventory.func_70299_a(2, new ItemStack(this.tank.getFluidType().getBlock()));
            } else if (this.tank.getFluidType() == null && this.func_70301_a(2) != null) {
                this.func_70299_a(2, null);
            }
            this.tank.compareAndUpdate();
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int fill = this.tank.fill(resource, doFill);
        this.tank.compareAndUpdate();
        return fill;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        FluidStack drain = this.tank.drain(resource.amount, doDrain);
        this.tank.compareAndUpdate();
        return drain;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack drain = this.tank.drain(maxDrain, doDrain);
        this.tank.compareAndUpdate();
        return drain;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluid() == null || this.tank.getFluid().getFluid() == fluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluid() == null || this.tank.getFluid().getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slotId, int count) {
        ItemStack stack = this.inventory.func_70298_a(slotId, count);
        this.syncWithAll();
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
        this.syncWithAll();
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventory.func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public short getFacing() {
        return 0;
    }

    @Override
    public void setFacing(short facing) {
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return this.getDropWithNBT();
    }

    public ItemStack getDropWithNBT() {
        NBTTagCompound tileEntity = new NBTTagCompound();
        ItemStack dropStack = new ItemStack(ModBlocks.quantumTank, 1);
        this.writeToNBTWithoutCoords(tileEntity);
        dropStack.func_77982_d(new NBTTagCompound());
        dropStack.field_77990_d.func_74782_a("tileEntity", (NBTBase)tileEntity);
        return dropStack;
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        if (isRealTile) {
            if (this.tank.getFluid() != null) {
                info.add(this.tank.getFluidAmount() + " of " + this.tank.getFluidType().getName());
            } else {
                info.add("Empty");
            }
        }
        info.add("Capacity " + this.tank.getCapacity() + " mb");
    }
}

