/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import ic2.api.tile.IWrenchable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import reborncore.common.misc.Functions;
import reborncore.common.util.Inventory;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;
import techreborn.powerSystem.TilePowerAcceptor;

public class TileAesu
extends TilePowerAcceptor
implements IWrenchable {
    public static final int MAX_OUTPUT = ConfigTechReborn.aesuMaxOutput;
    public static final int MAX_STORAGE = ConfigTechReborn.aesuMaxStorage;
    public Inventory inventory = new Inventory(2, "TileAesu", 64);
    private int OUTPUT = 64;
    private double euLastTick = 0.0;
    private double euChange;
    private int ticks;

    public TileAesu() {
        super(5);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.ticks == ConfigTechReborn.aveargeEuOutTickTime) {
            this.euChange = -1.0;
            this.ticks = 0;
        } else {
            ++this.ticks;
            this.euChange += this.getEnergy() - this.euLastTick;
            if (this.euLastTick == this.getEnergy()) {
                this.euChange = 0.0;
            }
        }
        this.euLastTick = this.getEnergy();
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return !entityPlayer.func_70093_af();
    }

    @Override
    public short getFacing() {
        return (short)this.getRotation();
    }

    @Override
    public void setFacing(short facing) {
        this.setRotation(facing);
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return this.getDropWithNBT();
    }

    public boolean isComplete() {
        return false;
    }

    public void handleGuiInputFromClient(int id) {
        if (id == 0) {
            this.OUTPUT += 256;
        }
        if (id == 1) {
            this.OUTPUT += 64;
        }
        if (id == 2) {
            this.OUTPUT -= 64;
        }
        if (id == 3) {
            this.OUTPUT -= 256;
        }
        if (this.OUTPUT > MAX_OUTPUT) {
            this.OUTPUT = MAX_OUTPUT;
        }
        if (this.OUTPUT <= -1) {
            this.OUTPUT = 0;
        }
    }

    public double getEuChange() {
        if (this.euChange == -1.0) {
            return -1.0;
        }
        return this.euChange / (double)this.ticks;
    }

    public ItemStack getDropWithNBT() {
        NBTTagCompound tileEntity = new NBTTagCompound();
        ItemStack dropStack = new ItemStack(ModBlocks.Aesu, 1);
        this.writeToNBTWithoutCoords(tileEntity);
        dropStack.func_77982_d(new NBTTagCompound());
        dropStack.field_77990_d.func_74782_a("tileEntity", (NBTBase)tileEntity);
        return dropStack;
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74780_a("euChange", this.euChange);
        tagCompound.func_74780_a("euLastTick", this.euLastTick);
        tagCompound.func_74768_a("output", this.OUTPUT);
        this.inventory.writeToNBT(tagCompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.euChange = nbttagcompound.func_74769_h("euChange");
        this.euLastTick = nbttagcompound.func_74769_h("euLastTick");
        this.OUTPUT = nbttagcompound.func_74762_e("output");
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public double getMaxPower() {
        return MAX_STORAGE;
    }

    @Override
    public boolean canAcceptEnergy(ForgeDirection direction) {
        return this.getRotation() != Functions.getIntDirFromDirection((ForgeDirection)direction);
    }

    @Override
    public boolean canProvideEnergy(ForgeDirection direction) {
        return this.getRotation() == Functions.getIntDirFromDirection((ForgeDirection)direction);
    }

    @Override
    public double getMaxOutput() {
        return this.OUTPUT;
    }

    @Override
    public double getMaxInput() {
        return 8192.0;
    }
}

