/*
 * Decompiled with CFR 0.152.
 */
package techreborn.partSystem;

import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import reborncore.common.misc.Location;
import reborncore.common.misc.vecmath.Vecs3dCube;
import techreborn.partSystem.IModPart;
import techreborn.partSystem.IPartProvider;
import techreborn.partSystem.ModPartRegistry;

public class ModPartUtils {
    public static boolean checkOcclusion(World world, Location location, Vecs3dCube cube) {
        if (world == null) {
            return false;
        }
        IPartProvider partProvider = ModPartUtils.getPartProvider(world, location);
        if (partProvider != null) {
            return partProvider.checkOcclusion(world, location, cube);
        }
        return false;
    }

    public static boolean checkOcclusion(World world, int x, int y, int z, Vecs3dCube cube) {
        return !ModPartUtils.checkOcclusion(world, new Location(x, y, z), cube);
    }

    public static boolean checkOcclusionInvert(World world, Location location, Vecs3dCube cube) {
        if (world == null) {
            return false;
        }
        for (IPartProvider iPartProvider : ModPartRegistry.providers) {
            if (iPartProvider.checkOcclusion(world, location, cube)) continue;
            return false;
        }
        return false;
    }

    public static boolean checkOcclusionInvert(World world, int x, int y, int z, Vecs3dCube cube) {
        return ModPartUtils.checkOcclusionInvert(world, new Location(x, y, z), cube);
    }

    public static boolean hasPart(World world, Location location, String name) {
        for (IPartProvider iPartProvider : ModPartRegistry.providers) {
            if (!iPartProvider.hasPart(world, location, name)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPart(World world, int x, int y, int z, String name) {
        return ModPartUtils.hasPart(world, new Location(x, y, z), name);
    }

    public static Item getItemForPart(String string) {
        for (Map.Entry<String, Item> item : ModPartRegistry.itemParts.entrySet()) {
            if (!item.getValue().equals(string)) continue;
            return item.getValue();
        }
        return null;
    }

    public static IPartProvider getPartProvider(World world, Location location) {
        for (IPartProvider partProvider : ModPartRegistry.providers) {
            if (!partProvider.isTileFromProvider(world.func_147438_o(location.getX(), location.getY(), location.getZ()))) continue;
            return partProvider;
        }
        return null;
    }

    public static IModPart getPartFromWorld(World world, Location location, String name) {
        for (IPartProvider partProvider : ModPartRegistry.providers) {
            IModPart tempPart = null;
            tempPart = partProvider.getPartFromWorld(world, location, name);
            if (tempPart == null) continue;
            return tempPart;
        }
        return null;
    }
}

