/*
 * Decompiled with CFR 0.152.
 */
package techreborn.partSystem;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.item.IC2Items;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import techreborn.Core;
import techreborn.client.TechRebornCreativeTab;
import techreborn.init.ModParts;
import techreborn.partSystem.IPartProvider;
import techreborn.partSystem.ModPart;
import techreborn.partSystem.ModPartItem;
import techreborn.partSystem.parts.CablePart;

public class ModPartRegistry {
    public static ArrayList<ModPart> parts = new ArrayList();
    public static ArrayList<IPartProvider> providers = new ArrayList();
    public static IPartProvider masterProvider = null;
    public static Map<String, Item> itemParts = new HashMap<String, Item>();

    public static void registerPart(ModPart iModPart) {
        parts.add(iModPart);
    }

    public static void addAllPartsToSystems() {
        for (IPartProvider iPartProvider : providers) {
            iPartProvider.init();
        }
        Core.logHelper.info((Object)"Started to load all parts");
        for (ModPart modPart : parts) {
            if (!modPart.needsItem()) continue;
            Item part = new ModPartItem(modPart).func_77655_b(modPart.getName()).func_77637_a((CreativeTabs)TechRebornCreativeTab.instance).func_111206_d(modPart.getItemTextureName());
            GameRegistry.registerItem((Item)part, (String)modPart.getName());
            itemParts.put(modPart.getName(), part);
            if (!(modPart instanceof CablePart)) continue;
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(part), (Object[])new Object[]{IC2Items.getItem(CablePart.getTextureNameFromType(((CablePart)modPart).type))});
            ((CablePart)modPart).stack = new ItemStack(part);
            ModParts.stackCable.put(((CablePart)modPart).type, new ItemStack(part));
        }
        for (IPartProvider iPartProvider : providers) {
            iPartProvider.registerPart();
        }
    }

    public static Item getItem(String string) {
        for (Map.Entry<String, Item> entry : itemParts.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void addProvider(String className, String modid) {
        if (Loader.isModLoaded((String)modid) || modid.equals("Minecraft")) {
            try {
                IPartProvider iPartProvider = null;
                iPartProvider = (IPartProvider)Class.forName(className).newInstance();
                providers.add(iPartProvider);
                if (modid.equals("qmunitylib")) {
                    masterProvider = iPartProvider;
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                Core.logHelper.error((Object)("Failed to load " + className + " to the part system!"));
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                Core.logHelper.error((Object)("Failed to load " + className + " to the part system!"));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                Core.logHelper.error((Object)("Failed to load " + className + " to the part system!"));
            }
        }
    }

    public static void addProvider(IPartProvider iPartProvider) {
        if (Loader.isModLoaded((String)iPartProvider.modID()) || iPartProvider.modID().equals("Minecraft")) {
            providers.add(iPartProvider);
        }
    }
}

