/*
 * Decompiled with CFR 0.152.
 */
package techreborn.multiblocks;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import reborncore.common.multiblock.CoordTriplet;
import reborncore.common.multiblock.IMultiblockPart;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.MultiblockValidationException;
import reborncore.common.multiblock.rectangular.RectangularMultiblockControllerBase;
import reborncore.common.multiblock.rectangular.RectangularMultiblockTileEntityBase;

public class MultiBlockCasing
extends RectangularMultiblockControllerBase {
    public boolean hasLava;
    public boolean isStar = false;
    public int height = 0;

    public MultiBlockCasing(World world) {
        super(world);
    }

    public String getInfo() {
        String value = "Intact";
        try {
            this.isMachineWhole();
        }
        catch (MultiblockValidationException e) {
            e.printStackTrace();
            value = e.getLocalizedMessage();
        }
        return value;
    }

    protected void isMachineWhole() throws MultiblockValidationException {
        if (this.connectedParts.size() < this.getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException("Machine is too small.");
        }
        CoordTriplet maximumCoord = this.getMaximumCoord();
        CoordTriplet minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.x - minimumCoord.x + 1;
        int deltaY = maximumCoord.y - minimumCoord.y + 1;
        int deltaZ = maximumCoord.z - minimumCoord.z + 1;
        int maxX = this.getMaximumXSize();
        int maxY = this.getMaximumYSize();
        int maxZ = this.getMaximumZSize();
        int minX = this.getMinimumXSize();
        int minY = this.getMinimumYSize();
        int minZ = this.getMinimumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the X dimension", maxX));
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the Y dimension", maxY));
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the Z dimension", maxZ));
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the X dimension", minX));
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Y dimension", minY));
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Z dimension", minZ));
        }
        this.height = deltaY;
        if (deltaY < minY) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Y dimension", minY));
        }
        Class<?> myClass = ((Object)((Object)this)).getClass();
        for (int x = minimumCoord.x; x <= maximumCoord.x; ++x) {
            for (int y = minimumCoord.y; y <= maximumCoord.y; ++y) {
                for (int z = minimumCoord.z; z <= maximumCoord.z; ++z) {
                    RectangularMultiblockTileEntityBase part;
                    TileEntity te = this.worldObj.func_147438_o(x, y, z);
                    if (te instanceof RectangularMultiblockTileEntityBase) {
                        part = (RectangularMultiblockTileEntityBase)te;
                        if (!myClass.equals(part.getMultiblockControllerType())) {
                            throw new MultiblockValidationException(String.format("Part @ %d, %d, %d is incompatible with machines of type %s", x, y, z, myClass.getSimpleName()));
                        }
                    } else {
                        part = null;
                    }
                    int extremes = 0;
                    if (x == minimumCoord.x) {
                        ++extremes;
                    }
                    if (y == minimumCoord.y) {
                        ++extremes;
                    }
                    if (z == minimumCoord.z) {
                        ++extremes;
                    }
                    if (x == maximumCoord.x) {
                        ++extremes;
                    }
                    if (y == maximumCoord.y) {
                        ++extremes;
                    }
                    if (z == maximumCoord.z) {
                        ++extremes;
                    }
                    if (extremes >= 2) {
                        if (part != null) {
                            part.isGoodForFrame();
                            continue;
                        }
                        this.isBlockGoodForFrame(this.worldObj, x, y, z);
                        continue;
                    }
                    if (extremes == 1) {
                        if (y == maximumCoord.y) {
                            if (part != null) {
                                part.isGoodForTop();
                                continue;
                            }
                            this.isBlockGoodForTop(this.worldObj, x, y, z);
                            continue;
                        }
                        if (y == minimumCoord.y) {
                            if (part != null) {
                                part.isGoodForBottom();
                                continue;
                            }
                            this.isBlockGoodForBottom(this.worldObj, x, y, z);
                            continue;
                        }
                        if (part != null) {
                            part.isGoodForSides();
                            continue;
                        }
                        this.isBlockGoodForSides(this.worldObj, x, y, z);
                        continue;
                    }
                    if (part != null) {
                        part.isGoodForInterior();
                        continue;
                    }
                    this.isBlockGoodForInterior(this.worldObj, x, y, z);
                }
            }
        }
    }

    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
    }

    protected void onBlockAdded(IMultiblockPart newPart) {
    }

    protected void onBlockRemoved(IMultiblockPart oldPart) {
    }

    protected void onMachineAssembled() {
    }

    protected void onMachineRestored() {
    }

    protected void onMachinePaused() {
    }

    protected void onMachineDisassembled() {
    }

    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 1;
    }

    protected int getMaximumXSize() {
        return 3;
    }

    protected int getMaximumZSize() {
        return 3;
    }

    protected int getMaximumYSize() {
        return 4;
    }

    protected int getMinimumXSize() {
        return 3;
    }

    protected int getMinimumYSize() {
        return 3;
    }

    protected int getMinimumZSize() {
        return 3;
    }

    protected void onAssimilate(MultiblockControllerBase assimilated) {
    }

    protected void onAssimilated(MultiblockControllerBase assimilator) {
    }

    protected boolean updateServer() {
        return true;
    }

    protected void updateClient() {
    }

    public void writeToNBT(NBTTagCompound data) {
    }

    public void readFromNBT(NBTTagCompound data) {
    }

    public void formatDescriptionPacket(NBTTagCompound data) {
    }

    public void decodeDescriptionPacket(NBTTagCompound data) {
    }

    protected void isBlockGoodForInterior(World world, int x, int y, int z) throws MultiblockValidationException {
        Block block = world.func_147439_a(x, y, z);
        if (!block.isAir((IBlockAccess)world, x, y, z)) {
            if (block.func_149739_a().equals("tile.lava")) {
                this.hasLava = true;
            } else {
                super.isBlockGoodForInterior(world, x, y, z);
            }
        }
    }
}

