/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.minetweaker;

import java.util.ArrayList;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import reborncore.common.util.ItemUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techreborn.api.RollingMachineRecipe;
import techreborn.api.TechRebornAPI;
import techreborn.compat.minetweaker.MinetweakerCompat;

@ZenClass(value="mods.techreborn.rollingMachine")
public class MTRollingMachine {
    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] ingredients) {
        TechRebornAPI.addRollingOreMachinceRecipe(MTRollingMachine.toStack(output), MTRollingMachine.toShapedObjects(ingredients));
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] ingredients) {
        TechRebornAPI.addShapelessOreRollingMachinceRecipe(MTRollingMachine.toStack(output), MTRollingMachine.toObjects(ingredients));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        ArrayList<IRecipe> toRemove = new ArrayList<IRecipe>();
        for (IRecipe recipe : RollingMachineRecipe.instance.getRecipeList()) {
            if (!ItemUtils.isItemEqual((ItemStack)recipe.func_77571_b(), (ItemStack)MinetweakerCompat.toStack(output), (boolean)true, (boolean)false)) continue;
            toRemove.add(recipe);
        }
        RollingMachineRecipe.instance.getRecipeList().removeAll(toRemove);
    }

    public static ItemStack toStack(IItemStack iStack) {
        if (iStack == null) {
            return null;
        }
        Object internal = iStack.getInternal();
        if (internal == null || !(internal instanceof ItemStack)) {
            MineTweakerAPI.getLogger().logError("Not a valid item stack: " + iStack);
        }
        return (ItemStack)internal;
    }

    public static ItemStack[] toStacks(IItemStack[] iStack) {
        if (iStack == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[iStack.length];
        for (int i = 0; i < iStack.length; ++i) {
            output[i] = MTRollingMachine.toStack(iStack[i]);
        }
        return output;
    }

    public static Object toObject(IIngredient iStack) {
        if (iStack == null) {
            return null;
        }
        if (iStack instanceof IOreDictEntry) {
            return MTRollingMachine.toString((IOreDictEntry)iStack);
        }
        if (iStack instanceof IItemStack) {
            return MTRollingMachine.toStack((IItemStack)iStack);
        }
        return null;
    }

    public static Object[] toObjects(IIngredient[] ingredient) {
        if (ingredient == null) {
            return null;
        }
        Object[] output = new Object[ingredient.length];
        for (int i = 0; i < ingredient.length; ++i) {
            output[i] = ingredient[i] != null ? MTRollingMachine.toObject(ingredient[i]) : "";
        }
        return output;
    }

    public static Object[] toShapedObjects(IIngredient[][] ingredients) {
        if (ingredients == null) {
            return null;
        }
        ArrayList<Object> prep = new ArrayList<Object>();
        prep.add("abc");
        prep.add("def");
        prep.add("ghi");
        char[][] map = new char[][]{{'a', 'b', 'c'}, {'d', 'e', 'f'}, {'g', 'h', 'i'}};
        for (int x = 0; x < ingredients.length; ++x) {
            if (ingredients[x] == null) continue;
            for (int y = 0; y < ingredients[x].length; ++y) {
                if (ingredients[x][y] == null || x >= map.length || y >= map[x].length) continue;
                prep.add(Character.valueOf(map[x][y]));
                prep.add(MTRollingMachine.toObject(ingredients[x][y]));
            }
        }
        return prep.toArray();
    }

    public static String toString(IOreDictEntry entry) {
        return entry.getName();
    }
}

