/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.thaumcraft;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import openmods.reflection.FieldAccess;
import openmods.reflection.MethodAccess;
import openmods.reflection.ReflectionHelper;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.IPeripheralAdapter;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;

@Asynchronous
public class AdapterArcaneBore
implements IPeripheralAdapter {
    private final Class<?> CLASS = ReflectionHelper.getClass((String)"thaumcraft.common.tiles.TileArcaneBore");
    private final Class<?> ITEM_ELEMENTAL_PICK = ReflectionHelper.getClass((String)"thaumcraft.common.items.equipment.ItemElementalPickaxe");
    private final FieldAccess<Boolean> HAS_PICKAXE = FieldAccess.create(this.CLASS, (String[])new String[]{"hasPickaxe"});
    private final FieldAccess<Boolean> HAS_FOCUS = FieldAccess.create(this.CLASS, (String[])new String[]{"hasFocus"});
    private final FieldAccess<Integer> AREA = FieldAccess.create(this.CLASS, (String[])new String[]{"area"});
    private final FieldAccess<Integer> SPEED = FieldAccess.create(this.CLASS, (String[])new String[]{"speed"});
    private final FieldAccess<Integer> MAX_RADIUS = FieldAccess.create(this.CLASS, (String[])new String[]{"maxRadius"});
    private final MethodAccess.Function0<Boolean> GETTING_POWER = MethodAccess.create(Boolean.TYPE, this.CLASS, (String[])new String[]{"gettingPower"});

    public Class<?> getTargetClass() {
        return this.CLASS;
    }

    public String getSourceId() {
        return "thaumcraf_bore";
    }

    @ScriptCallable(returnTypes={ReturnType.BOOLEAN}, description="Does the arcane bore have a pickaxe.")
    public boolean hasPickaxe(Object target) {
        return (Boolean)this.HAS_PICKAXE.get(target);
    }

    @ScriptCallable(returnTypes={ReturnType.BOOLEAN}, description="Does the arcane bore have a focus.")
    public boolean hasFocus(Object target) {
        return (Boolean)this.HAS_FOCUS.get(target);
    }

    public ItemStack getPick(Object bore) {
        return bore instanceof IInventory ? ((IInventory)bore).func_70301_a(1) : null;
    }

    @ScriptCallable(returnTypes={ReturnType.BOOLEAN}, description="Is the pick broken?")
    public boolean isPickaxeBroken(Object target) {
        ItemStack pick = this.getPick(target);
        return pick != null && pick.func_77960_j() + 1 == pick.func_77958_k();
    }

    @Asynchronous(value=false)
    @ScriptCallable(returnTypes={ReturnType.BOOLEAN}, description="Is the Arcane bore active?")
    public boolean isWorking(Object target) {
        ItemStack pick = this.getPick(target);
        Boolean hasPower = (Boolean)this.GETTING_POWER.call(target);
        return hasPower != false && this.hasFocus(target) && this.hasPickaxe(target) && pick.func_77984_f() && !this.isPickaxeBroken(target);
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Gets the radius of the bore's effects")
    public int getRadius(Object target) {
        return 1 + ((Integer)this.AREA.get(target) + (Integer)this.MAX_RADIUS.get(target)) * 2;
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Gets the speed of the bore")
    public int getSpeed(Object target) {
        return (Integer)this.SPEED.get(target);
    }

    @ScriptCallable(returnTypes={ReturnType.BOOLEAN}, description="Does the bore mine native clusters as well as normal ores")
    public boolean hasNativeClusters(Object target) {
        ItemStack pick = this.getPick(target);
        return pick != null && this.ITEM_ELEMENTAL_PICK.isInstance(pick.func_77973_b());
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Gets the fortune level the Bore is mining with")
    public int getFortune(Object target) {
        ItemStack pick = this.getPick(target);
        return EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)pick);
    }

    @ScriptCallable(returnTypes={ReturnType.BOOLEAN}, description="Does the Bore mine with silk touch")
    public boolean hasSilkTouch(Object target) {
        ItemStack pick = this.getPick(target);
        return EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)pick) > 0;
    }
}

