/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.buildcraft.subproxies;

import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.render.FakeBlock;
import buildcraft.robotics.RobotStationPluggable;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gates.GatePluggable;
import buildcraft.transport.pluggable.LensPluggable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.buildcraft.robots.LPRobotConnectionControl;
import logisticspipes.proxy.buildcraft.robots.boards.LogisticsRoutingBoardRobot;
import logisticspipes.proxy.buildcraft.subproxies.IBCPipePart;
import logisticspipes.proxy.buildcraft.subproxies.IBCPipePluggable;
import logisticspipes.proxy.buildcraft.subproxies.IBCPluggableState;
import logisticspipes.proxy.buildcraft.subproxies.IBCRenderState;
import logisticspipes.proxy.buildcraft.subproxies.IBCTilePart;
import logisticspipes.proxy.buildcraft.subproxies.LPBCPipe;
import logisticspipes.proxy.buildcraft.subproxies.LPBCPipeRenderState;
import logisticspipes.proxy.buildcraft.subproxies.LPBCPluggableState;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.ReflectionHelper;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LPBCTileGenericPipe
extends TileGenericPipe
implements IBCTilePart {
    private final LPBCPipe bcPipe;
    private final LPBCPluggableState bcPlugState;
    private final LPBCPipeRenderState bcRenderState;
    private final LogisticsTileGenericPipe lpPipe;
    public Map<ForgeDirection, List<StatementSlot>> activeActions = new HashMap<ForgeDirection, List<StatementSlot>>();

    public LPBCTileGenericPipe(LPBCPipe pipe, LogisticsTileGenericPipe lpPipe) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.bcPipe = pipe;
        this.pipe = this.bcPipe;
        this.bcPipe.setTile((TileEntity)this);
        this.lpPipe = lpPipe;
        this.bcPlugState = new LPBCPluggableState();
        this.bcRenderState = new LPBCPipeRenderState();
        ReflectionHelper.setFinalField(TileGenericPipe.class, "pluggableState", this, this.bcPlugState);
        ReflectionHelper.setFinalField(TileGenericPipe.class, "renderState", this, this.bcRenderState);
    }

    @Override
    public void writeToNBT_LP(NBTTagCompound nbt) {
        NBTTagCompound bcNBT = new NBTTagCompound();
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            String key = "redstoneInputSide[" + i + "]";
            bcNBT.func_74774_a(key, (byte)this.redstoneInputSide[i]);
        }
        this.pipe.writeToNBT(bcNBT);
        this.sideProperties.writeToNBT(bcNBT);
        nbt.func_74782_a("BC_Pipe_NBT", (NBTBase)bcNBT);
    }

    @Override
    public void readFromNBT_LP(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("BC_Pipe_NBT")) {
            this.redstoneInput = 0;
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                String key = "redstoneInputSide[" + i + "]";
                if (nbt.func_74764_b(key)) {
                    this.redstoneInputSide[i] = nbt.func_74771_c(key);
                    if (this.redstoneInputSide[i] <= this.redstoneInput) continue;
                    this.redstoneInput = this.redstoneInputSide[i];
                    continue;
                }
                this.redstoneInputSide[i] = 0;
            }
            this.pipe.readFromNBT(nbt);
            this.pipeBound = true;
            this.sideProperties.readFromNBT(nbt);
            this.attachPluggables = true;
            return;
        }
        NBTTagCompound bcNBT = nbt.func_74775_l("BC_Pipe_NBT");
        this.redstoneInput = 0;
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            String key = "redstoneInputSide[" + i + "]";
            if (bcNBT.func_74764_b(key)) {
                this.redstoneInputSide[i] = bcNBT.func_74771_c(key);
                if (this.redstoneInputSide[i] <= this.redstoneInput) continue;
                this.redstoneInput = this.redstoneInputSide[i];
                continue;
            }
            this.redstoneInputSide[i] = 0;
        }
        this.pipeBound = true;
        this.pipe.readFromNBT(bcNBT);
        this.sideProperties.readFromNBT(bcNBT);
        this.attachPluggables = true;
    }

    @Override
    public void invalidate_LP() {
        this.func_145843_s();
    }

    @Override
    public void validate_LP() {
        this.func_145829_t();
    }

    @Override
    public void updateEntity_LP() {
        this.field_145851_c = this.lpPipe.field_145851_c;
        this.field_145848_d = this.lpPipe.field_145848_d;
        this.field_145849_e = this.lpPipe.field_145849_e;
        if (this.attachPluggables) {
            this.attachPluggables = false;
            PipePluggable[] pluggables = ReflectionHelper.getPrivateField(PipePluggable[].class, TileGenericPipe.SideProperties.class, "pluggables", this.sideProperties);
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                if (pluggables[i] == null) continue;
                this.pipe.eventBus.registerHandler((Object)pluggables[i]);
                pluggables[i].onAttachedPipe((IPipeTile)this, ForgeDirection.getOrientation((int)i));
            }
            this.notifyBlockChanged();
        }
        if (!BlockGenericPipe.isValid((Pipe)this.pipe)) {
            return;
        }
        this.pipe.updateEntity();
        boolean recheckThisPipe = false;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            PipePluggable p = this.getPipePluggable(direction);
            if (p == null) continue;
            p.update((IPipeTile)this, direction);
            if (p instanceof GatePluggable && this.lpPipe.isRoutingPipe()) {
                if (!this.activeActions.containsKey(direction)) {
                    this.activeActions.put(direction, new ArrayList());
                }
                if (!this.listEquals(this.activeActions.get(direction), this.pipe.gates[direction.ordinal()].activeActions)) {
                    this.activeActions.get(direction).clear();
                    this.activeActions.get(direction).addAll(this.pipe.gates[direction.ordinal()].activeActions);
                    this.lpPipe.getRoutingPipe().triggerConnectionCheck();
                    recheckThisPipe = true;
                }
            } else if (this.activeActions.containsKey(direction)) {
                this.activeActions.remove(direction);
            }
            if (!(p instanceof RobotStationPluggable) || ((RobotStationPluggable)p).getStation() == null || ((RobotStationPluggable)p).getStation().robotTaking() == null || !(((RobotStationPluggable)p).getStation().robotTaking().getBoard() instanceof LogisticsRoutingBoardRobot)) continue;
            ((RobotStationPluggable)p).getStation().robotTaking().getBoard().cycle();
        }
        if (recheckThisPipe) {
            LPRobotConnectionControl.instance.checkAll(this.field_145850_b);
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.resyncGateExpansions) {
                ReflectionHelper.invokePrivateMethod(Object.class, TileGenericPipe.class, this, "syncGateExpansions", new Class[0], new Object[0]);
            }
            return;
        }
        if (this.blockNeighborChange) {
            ReflectionHelper.invokePrivateMethod(Object.class, TileGenericPipe.class, this, "computeConnections", new Class[0], new Object[0]);
            this.pipe.onNeighborBlockChange(0);
            this.blockNeighborChange = false;
            this.refreshRenderState = true;
        }
        if (this.refreshRenderState) {
            this.refreshRenderState();
            this.refreshRenderState = false;
        }
    }

    private boolean listEquals(List<StatementSlot> list1, List<StatementSlot> list2) {
        ListIterator<StatementSlot> e1 = list1.listIterator();
        ListIterator<StatementSlot> e2 = list2.listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            StatementSlot o1 = e1.next();
            StatementSlot o2 = e2.next();
            if (o1 != null ? this.statementEquals(o1, o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    private boolean statementEquals(StatementSlot slot1, StatementSlot slot2) {
        if (slot1.statement != slot2.statement || slot1.parameters.length != slot2.parameters.length) {
            return false;
        }
        for (int i = 0; i < slot1.parameters.length; ++i) {
            IStatementParameter p1 = slot1.parameters[i];
            IStatementParameter p2 = slot2.parameters[i];
            if ((p1 == null || p1.equals(p2)) && (p1 != null || p2 == null)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IBCRenderState getBCRenderState() {
        return this.bcRenderState;
    }

    @Override
    public IBCPipePart getBCPipePart() {
        return this.bcPipe;
    }

    @Override
    public IBCPluggableState getBCPlugableState() {
        return this.bcPlugState;
    }

    @Override
    public void readOldRedStone(NBTTagCompound nbt) {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            String key = "redstoneInputSide[" + i + "]";
            if (nbt.func_74764_b(key)) {
                this.redstoneInputSide[i] = nbt.func_74771_c(key);
                if (this.redstoneInputSide[i] <= this.redstoneInput) continue;
                this.redstoneInput = this.redstoneInputSide[i];
                continue;
            }
            this.redstoneInputSide[i] = 0;
        }
    }

    @Override
    public IBCPipePluggable getBCPipePluggable(final ForgeDirection sideHit) {
        final PipePluggable plug = this.getPipePluggable(sideHit);
        if (plug == null) {
            return null;
        }
        return new IBCPipePluggable(){

            @Override
            public ItemStack[] getDropItems(LogisticsTileGenericPipe container) {
                return plug.getDropItems((IPipeTile)container);
            }

            @Override
            public boolean isBlocking() {
                return plug.isBlocking((IPipeTile)LPBCTileGenericPipe.this.pipe.container, sideHit);
            }

            @Override
            public Object getOriginal() {
                return plug;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void renderPluggable(RenderBlocks renderblocks, ForgeDirection dir, int renderPass, int x, int y, int z) {
                if (plug.getRenderer() == null) {
                    return;
                }
                plug.getRenderer().renderPluggable(renderblocks, (IPipe)LPBCTileGenericPipe.this.bcPipe, dir, plug, (ITextureStates)FakeBlock.INSTANCE, renderPass, x, y, z);
            }

            @Override
            public boolean isAcceptingItems(LPTravelingItem.LPTravelingItemServer arrivingItem) {
                return plug instanceof RobotStationPluggable;
            }

            @Override
            public LPTravelingItem.LPTravelingItemServer handleItem(LPTravelingItem.LPTravelingItemServer arrivingItem) {
                DockingStation station = ((RobotStationPluggable)plug).getStation();
                if (!station.isTaken()) {
                    return arrivingItem;
                }
                EntityRobotBase robot = station.robotTaking();
                if (!(robot.getBoard() instanceof LogisticsRoutingBoardRobot)) {
                    return arrivingItem;
                }
                if (!((LogisticsRoutingBoardRobot)robot.getBoard()).isAcceptsItems()) {
                    return arrivingItem;
                }
                LPPosition robotPos = new LPPosition((Entity)robot);
                LPPosition lPPosition = new LPPosition((TileEntity)LPBCTileGenericPipe.this);
                if (lPPosition.center().moveForward(sideHit, 0.5).distanceTo(robotPos) > 0.05) {
                    return arrivingItem;
                }
                return ((LogisticsRoutingBoardRobot)robot.getBoard()).handleItem(arrivingItem);
            }
        };
    }

    @Override
    public void afterStateUpdated() {
        if (this.field_145850_b == null) {
            this.field_145850_b = this.lpPipe.func_145831_w();
        }
        this.afterStateUpdated((byte)2);
    }

    @Override
    public Object getOriginal() {
        this.field_145851_c = this.lpPipe.field_145851_c;
        this.field_145848_d = this.lpPipe.field_145848_d;
        this.field_145849_e = this.lpPipe.field_145849_e;
        return this;
    }

    public Block getBlock(ForgeDirection to) {
        return this.lpPipe.getBlock(to);
    }

    public TileEntity getTile(ForgeDirection to) {
        return this.lpPipe.getTile(to);
    }

    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        this.lpPipe.sendUpdateToClient();
    }

    @Override
    public void setWorldObj_LP(World world) {
        this.func_145834_a(world);
        this.field_145851_c = this.lpPipe.field_145851_c;
        this.field_145848_d = this.lpPipe.field_145848_d;
        this.field_145849_e = this.lpPipe.field_145849_e;
    }

    public IPipeTile.PipeType getPipeType() {
        return IPipeTile.PipeType.ITEM;
    }

    public boolean isPipeConnected(ForgeDirection with) {
        return this.lpPipe.isPipeConnected(with);
    }

    public boolean setPluggable(ForgeDirection direction, PipePluggable pluggable, EntityPlayer player) {
        if (pluggable instanceof LensPluggable) {
            return false;
        }
        return super.setPluggable(direction, pluggable, player);
    }

    public LogisticsTileGenericPipe getLpPipe() {
        return this.lpPipe;
    }
}

