/*
 * Decompiled with CFR 0.152.
 */
package emasher.packethandling;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import emasher.api.SideConfig;
import emasher.packethandling.Handlers;
import emasher.packethandling.NetworkUtilities;
import emasher.tileentities.TileSocket;
import io.netty.buffer.ByteBuf;

public class SocketStateMessage
implements IMessage {
    public byte[] msg;
    byte side;
    TileSocket ts;

    public SocketStateMessage() {
    }

    public SocketStateMessage(TileSocket ts, byte side) {
        this.ts = ts;
        this.side = side;
    }

    public void fromBytes(ByteBuf buf) {
        this.msg = new byte[buf.capacity()];
        buf.readBytes(this.msg);
    }

    public void toBytes(ByteBuf buf) {
        buf.capacity(36);
        SideConfig c = this.ts.configs[this.side];
        byte[] out = new byte[36];
        out[0] = 0;
        out[2] = (byte)c.tank;
        out[3] = (byte)c.inventory;
        out[4] = (byte)this.ts.rsIndicatorIndex(this.side);
        out[5] = (byte)this.ts.latchIndicatorIndex(this.side);
        NetworkUtilities.toByte(out, c.meta, 6);
        NetworkUtilities.toByte(out, this.ts.field_145851_c, 10);
        NetworkUtilities.toByte(out, this.ts.field_145848_d, 14);
        NetworkUtilities.toByte(out, this.ts.field_145849_e, 18);
        NetworkUtilities.toByte(out, this.ts.facID[this.side], 27);
        NetworkUtilities.toByte(out, this.ts.facMeta[this.side], 31);
        out[1] = this.side;
        NetworkUtilities.toByte(out, this.ts.sides[this.side], 22);
        out[26] = NetworkUtilities.boolToByte(this.ts.sideLocked[this.side]);
        buf.writeBytes(out);
        this.msg = out;
    }

    public static class Handler
    implements IMessageHandler<SocketStateMessage, IMessage> {
        public IMessage onMessage(SocketStateMessage message, MessageContext ctx) {
            Handlers.onSocketStateMessage(message, ctx);
            return null;
        }
    }
}

