/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.waterhooks;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class BlockDynamicLiquidVisitor
extends ClassVisitor
implements IClassTransformer {
    private String obfClassName;
    private final String description = "(Lnet/minecraft/world/World;IIILjava/util/Random;)V";
    private final String srgName = "updateTick";
    private final String mcpName = "func_149674_a";

    public BlockDynamicLiquidVisitor() {
        super(262144);
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes != null && transformedName.equals("net.minecraft.block.BlockDynamicLiquid")) {
            ClassReader cr = new ClassReader(bytes);
            ClassWriter cw = new ClassWriter(cr, 2);
            FMLRelaunchLog.info((String)"[waterhooks] Trying to patch BlockDynamicLiquid.updateTick (class: %s)", (Object[])new Object[]{name});
            this.obfClassName = name;
            this.cv = cw;
            cr.accept((ClassVisitor)this, 0);
            return cw.toByteArray();
        }
        return bytes;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor parent = super.visitMethod(access, name, desc, signature, exceptions);
        return this.match(name, desc) ? new HookMethodVisitor(parent) : parent;
    }

    public boolean match(String methodName, String methodDesc) {
        if (!methodDesc.equals("(Lnet/minecraft/world/World;IIILjava/util/Random;)V")) {
            return false;
        }
        if (methodName.equals("func_149674_a")) {
            return true;
        }
        String mapped = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(this.obfClassName, methodName, methodDesc);
        return mapped.equals("updateTick");
    }

    private static class HookMethodVisitor
    extends MethodVisitor {
        public static boolean HookSuccess = false;
        int state = 0;

        public HookMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitInsn(int opcode) {
            super.visitInsn(opcode);
            if (this.state == 2) {
                this.state = opcode == 5 ? ++this.state : 0;
            }
        }

        public void visitVarInsn(int opcode, int var) {
            super.visitVarInsn(opcode, var);
            if (this.state == 0) {
                if (opcode == 25 && var == 0) {
                    ++this.state;
                }
            } else if (this.state == 4) {
                this.state = opcode == 25 && var == 0 ? ++this.state : 0;
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            super.visitFieldInsn(opcode, owner, name, desc);
            if (this.state == 1) {
                this.state = opcode == 180 && "net/minecraft/block/BlockDynamicLiquid".equals(owner) && "field_149815_a".equals(name) ? ++this.state : 0;
            } else if (this.state == 5) {
                this.state = opcode == 180 && "net/minecraft/block/BlockDynamicLiquid".equals(owner) && ("field_149764_J".equals(name) || "blockMaterial".equals(name)) ? ++this.state : 0;
            } else if (this.state == 6) {
                this.state = opcode == 178 && "net/minecraft/block/material/Material".equals(owner) && ("field_151586_h".equals(name) || "water".equals(name)) ? ++this.state : 0;
            }
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            if (this.state == 3) {
                this.state = opcode == 161 ? ++this.state : 0;
            } else if (this.state == 7) {
                if (opcode == 166) {
                    ++this.state;
                    this.mv.visitVarInsn(25, 1);
                    this.mv.visitVarInsn(21, 2);
                    this.mv.visitVarInsn(21, 3);
                    this.mv.visitVarInsn(21, 4);
                    this.mv.visitMethodInsn(184, "info/loenwind/waterhooks/Hooks", "allowFormWaterSourceBlock", "(Lnet/minecraft/world/World;III)Z", false);
                    this.mv.visitJumpInsn(153, label);
                    HookSuccess = true;
                    FMLRelaunchLog.info((String)"[waterhooks] net.minecraft.block.BlockDynamicLiquid.updateTick() patch applied.", (Object[])new Object[0]);
                } else {
                    this.state = 0;
                }
            }
        }

        public void visitEnd() {
            super.visitEnd();
            if (!HookSuccess) {
                FMLRelaunchLog.warning((String)"[waterhooks] net.minecraft.block.BlockDynamicLiquid.updateTick() failed to apply patch!", (Object[])new Object[0]);
            }
        }
    }
}

