/*
 * Decompiled with CFR 0.152.
 */
package terrails.terracore.world.generator;

import com.google.common.base.Predicate;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenCustomMinable
extends WorldGenerator {
    private final int veinSize;
    private final IBlockState oreToGenerate;
    private final BlockMatcher blockToReplace;

    public WorldGenCustomMinable(IBlockState oreToGenerate, int minVeinSize, int maxVeinSize, Block blockToReplace) {
        this.oreToGenerate = oreToGenerate;
        this.veinSize = ThreadLocalRandom.current().nextInt(minVeinSize, maxVeinSize + 1);
        this.blockToReplace = BlockMatcher.func_177642_a((Block)blockToReplace);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (this.veinSize < 4) {
            return this.generateSmallVein(world, rand, x, y, z);
        }
        WorldGenMinable generate = new WorldGenMinable(this.oreToGenerate, this.veinSize, (Predicate)this.blockToReplace);
        return generate.func_180709_b(world, rand, pos);
    }

    private boolean generateSmallVein(World world, Random random, int x, int y, int z) {
        boolean value = false;
        int newX = x + 8;
        int newZ = z + 8;
        IBlockState blockState = world.func_180495_p(new BlockPos(newX, y, newZ));
        if (blockState.func_177230_c().isReplaceableOreGen(blockState, (IBlockAccess)world, new BlockPos(x, y, z), (Predicate)this.blockToReplace)) {
            for (int i = 0; i < this.veinSize; ++i) {
                int posX = newX + random.nextInt(2);
                int posY = y + random.nextInt(2);
                int posZ = newZ + random.nextInt(2);
                world.func_180501_a(new BlockPos(posX, posY, posZ), this.oreToGenerate, 2);
                value = true;
            }
        }
        return value;
    }
}

