/*
 * Decompiled with CFR 0.152.
 */
package terrails.terracore.base.proxies;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import terrails.terracore.base.proxies.ProxyBase;
import terrails.terracore.base.registry.LoadingStage;
import terrails.terracore.base.registry.RegistryType;
import terrails.terracore.registry.client.ICustomModel;

public class ClientProxy
extends ProxyBase {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.modEntry.getRegistry().initClientProxy(LoadingStage.PRE_INIT);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        this.modEntry.getRegistry().initClientProxy(LoadingStage.INIT);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        this.modEntry.getRegistry().initClientProxy(LoadingStage.POST_INIT);
    }

    @Override
    public boolean isOP(EntityPlayer player) {
        return false;
    }

    @Override
    public EntityPlayer getEntityPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public boolean isGamePaused() {
        return Minecraft.func_71410_x().func_147113_T();
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        List blocks = this.modEntry.getRegistry().getForgeEntries(Lists.newArrayList(), RegistryType.BLOCK);
        blocks.stream().filter(ICustomModel.class::isInstance).map(ICustomModel.class::cast).forEach(ICustomModel::initModel);
        blocks.stream().filter(((Predicate<Block>)ICustomModel.class::isInstance).negate()).forEach(ClientProxy::registerModel);
        List items = this.modEntry.getRegistry().getForgeEntries(Lists.newArrayList(), RegistryType.ITEM);
        items.stream().filter(ICustomModel.class::isInstance).map(ICustomModel.class::cast).forEach(ICustomModel::initModel);
        items.stream().filter(((Predicate<Item>)ICustomModel.class::isInstance).negate()).forEach(ClientProxy::registerModel);
    }

    private static void registerModel(Block block) {
        ModelResourceLocation resourceLocation = new ModelResourceLocation(Objects.requireNonNull(block.getRegistryName()), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)resourceLocation);
    }

    private static void registerModel(Item item) {
        ModelResourceLocation resourceLocation = new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)resourceLocation);
    }
}

