/*
 * Decompiled with CFR 0.152.
 */
package com.github.voxelfriend.rusticthaumaturgy.crafting;

import com.github.voxelfriend.rusticthaumaturgy.common.blocks.ModBlocksRT;
import com.github.voxelfriend.rusticthaumaturgy.common.blocks.fluids.ModFluidsRT;
import com.github.voxelfriend.rusticthaumaturgy.common.items.ModItemsRT;
import com.github.voxelfriend.rusticthaumaturgy.configuration.RTConfiguration;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import rustic.common.Config;
import rustic.common.crafting.BrewingBarrelRecipe;
import rustic.common.crafting.CrushingTubRecipe;
import rustic.common.crafting.EvaporatingBasinRecipe;
import rustic.common.items.ModItems;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;

@Mod.EventBusSubscriber(modid="rusticthaumaturgy")
public class Recipes {
    public static void init() {
        Recipes.addCrushingTubRecipes();
        Recipes.addEvaporatingRecipes();
        Recipes.addBrewingRecipes();
        Recipes.addSqueezingRecipes();
    }

    public static void addOreDictEntries() {
        OreDictionary.registerOre((String)"dustTinyBlaze", (ItemStack)new ItemStack((Item)ModItemsRT.BLAZE_POWDER_TINY));
    }

    @SubscribeEvent
    public static void initRecipes(RegistryEvent.Register<IRecipe> event) {
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rusticthaumaturgy", "brass_candle_tallow"), (ResourceLocation)new ResourceLocation("rusticthaumaturgy", "candle_brass"), (ItemStack)new ItemStack((Block)ModBlocksRT.CANDLE_BRASS, 4), (Object[])new Object[]{"S", "T", "I", Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('T'), new ItemStack((Item)ModItems.TALLOW), Character.valueOf('I'), new ItemStack(ItemsTC.ingots, 1, 2)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rusticthaumaturgy", "brass_candle_beeswax"), (ResourceLocation)new ResourceLocation("rusticthaumaturgy", "candle_brass"), (ItemStack)new ItemStack((Block)ModBlocksRT.CANDLE_BRASS, 4), (Object[])new Object[]{"S", "B", "I", Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('B'), new ItemStack((Item)ModItems.BEESWAX), Character.valueOf('I'), new ItemStack(ItemsTC.ingots, 1, 2)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rusticthaumaturgy", "chandelier_brass"), (ResourceLocation)new ResourceLocation("rusticthaumaturgy", "chandelier_brass"), (ItemStack)new ItemStack((Block)ModBlocksRT.CHANDELIER_BRASS, 2), (Object[])new Object[]{" B ", "C C", "BBB", Character.valueOf('B'), new ItemStack(ItemsTC.ingots, 1, 2), Character.valueOf('C'), new ItemStack((Block)ModBlocksRT.CHAIN_BRASS)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rusticthaumaturgy", "brass_lantern"), (ResourceLocation)new ResourceLocation("rusticthaumaturgy", "lantern_brass"), (ItemStack)new ItemStack((Block)ModBlocksRT.LANTERN_BRASS, 4), (Object[])new Object[]{" B ", " C ", " B ", Character.valueOf('B'), new ItemStack(ItemsTC.ingots, 1, 2), Character.valueOf('C'), new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rusticthaumaturgy", "chain_brass"), (ResourceLocation)new ResourceLocation("rusticthaumaturgy", "chain_brass"), (ItemStack)new ItemStack((Block)ModBlocksRT.CHAIN_BRASS, 12), (Object[])new Object[]{" B ", " B ", " B ", Character.valueOf('B'), new ItemStack(ItemsTC.ingots, 1, 2)});
        if (Config.ENABLE_CHAIRS) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rusticthaumaturgy", "greatwood_chair"), (ResourceLocation)new ResourceLocation("rusticthaumaturgy", "chair"), (ItemStack)new ItemStack((Block)ModBlocksRT.CHAIR_GREATWOOD, 4), (Object[])new Object[]{"P  ", "PPP", "S S", Character.valueOf('P'), new ItemStack(BlocksTC.plankGreatwood), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rusticthaumaturgy", "silverwood_chair"), (ResourceLocation)new ResourceLocation("rusticthaumaturgy", "chair"), (ItemStack)new ItemStack((Block)ModBlocksRT.CHAIR_SILVERWOOD, 4), (Object[])new Object[]{"P  ", "PPP", "S S", Character.valueOf('P'), new ItemStack(BlocksTC.plankSilverwood), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
        }
        if (Config.ENABLE_TABLES) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rusticthaumaturgy", "greatwood_table"), (ResourceLocation)new ResourceLocation("rusticthaumaturgy", "table"), (ItemStack)new ItemStack((Block)ModBlocksRT.TABLE_GREATWOOD, 2), (Object[])new Object[]{"PPP", "S S", Character.valueOf('P'), new ItemStack(BlocksTC.plankGreatwood), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rusticthaumaturgy", "silverwood_table"), (ResourceLocation)new ResourceLocation("rusticthaumaturgy", "table"), (ItemStack)new ItemStack((Block)ModBlocksRT.TABLE_SILVERWOOD, 2), (Object[])new Object[]{"PPP", "S S", Character.valueOf('P'), new ItemStack(BlocksTC.plankSilverwood), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            if (RTConfiguration.enableColoredCandles) {
                // empty if block
            }
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rusticthaumaturgy", "dustTinyBlaze"), (ResourceLocation)new ResourceLocation("rusticthaumaturgy", "conversion"), (ItemStack)new ItemStack(Items.field_151065_br, 1), (Object[])new Object[]{"PP", "PP", Character.valueOf('P'), new ItemStack((Item)ModItemsRT.BLAZE_POWDER_TINY)});
            GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("rusticthaumaturgy", "blaze_powder"), (ResourceLocation)new ResourceLocation("rusticthaumaturgy", "conversion"), (ItemStack)new ItemStack((Item)ModItemsRT.BLAZE_POWDER_TINY, 4), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151065_br)})});
            GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("rusticthaumaturgy", "cindermote"), (ResourceLocation)new ResourceLocation("rusticthaumaturgy", "conversion"), (ItemStack)new ItemStack((Item)ModItemsRT.BLAZE_POWDER_TINY), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)ModItemsRT.CINDERMOTE)})});
            GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("rusticthaumaturgy", "shimmerpetal"), (ResourceLocation)new ResourceLocation("rusticthaumaturgy", "conversion"), (ItemStack)new ItemStack(ItemsTC.nuggets, 1, 5), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)ModItemsRT.SHIMMERPETAL)})});
        }
    }

    public static void addSqueezingRecipes() {
        if (Loader.isModLoaded((String)"immersiveengineering")) {
            // empty if block
        }
    }

    public static void addCrushingTubRecipes() {
        rustic.common.crafting.Recipes.crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluidsRT.CINDERFIRE_WORT, 125), new ItemStack((Item)ModItemsRT.CINDERMOTE)));
        rustic.common.crafting.Recipes.crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluidsRT.CINDERFIRE_WORT, 250), new ItemStack(BlocksTC.cinderpearl)));
        rustic.common.crafting.Recipes.crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluidsRT.SHIMMERDEW_WORT, 125), new ItemStack((Item)ModItemsRT.SHIMMERPETAL)));
        rustic.common.crafting.Recipes.crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluidsRT.SHIMMERDEW_WORT, 250), new ItemStack(BlocksTC.shimmerleaf)));
        rustic.common.crafting.Recipes.crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluidsRT.VISCOUS_WORT, 125), new ItemStack((Item)ModItemsRT.VISCAP)));
        rustic.common.crafting.Recipes.crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluidsRT.VISCOUS_WORT, 250), new ItemStack(BlocksTC.vishroom)));
    }

    public static void addEvaporatingRecipes() {
        rustic.common.crafting.Recipes.evaporatingRecipes.add(new EvaporatingBasinRecipe(new ItemStack((Item)ModItemsRT.BLAZE_POWDER_TINY, 1), new FluidStack(ModFluidsRT.CINDERFIRE_WORT, 500)));
    }

    public static void addBrewingRecipes() {
        rustic.common.crafting.Recipes.brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluidsRT.CINDERFIRE_WHISKEY, 1), new FluidStack(ModFluidsRT.CINDERFIRE_WORT, 1)));
        rustic.common.crafting.Recipes.brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluidsRT.SHIMMERDEW_SPIRITS, 1), new FluidStack(ModFluidsRT.SHIMMERDEW_WORT, 1)));
        rustic.common.crafting.Recipes.brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluidsRT.VISCOUS_BREW, 1), new FluidStack(ModFluidsRT.VISCOUS_WORT, 1)));
    }
}

