/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions.recipes;

import gregicadditions.GAConfig;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.common.blocks.BlockMachineCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.MetaItems;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class GAMachineRecipeRemoval {
    private static final MaterialStack[] solderingList = new MaterialStack[]{new MaterialStack((Material)Materials.Tin, 2L), new MaterialStack((Material)Materials.SolderingAlloy, 1L), new MaterialStack((Material)Materials.Lead, 4L)};

    public static void init() {
        for (Material m : Material.MATERIAL_REGISTRY) {
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.BENDER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)m), IntCircuitIngredient.getIntegratedCircuit((int)0));
            if (!OreDictUnifier.get((OrePrefix)OrePrefix.rotor, (Material)m).func_190926_b() && GAConfig.GT6.BendingRotors && GAConfig.GT6.BendingCylinders) {
                GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)m, (int)4), OreDictUnifier.get((OrePrefix)OrePrefix.ring, (Material)m)}, new FluidStack[]{Materials.SolderingAlloy.getFluid(32)});
            }
            if (m instanceof IngotMaterial && !m.hasFlag(DustMaterial.MatFlags.NO_SMASHING) && GAConfig.GT6.ExpensiveWrenches) {
                ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation(String.format("gregtech:wrench_%s", m.toString())));
            }
            if (!OreDictUnifier.get((OrePrefix)OrePrefix.wireFine, (Material)m).func_190926_b() && !OreDictUnifier.get((OrePrefix)OrePrefix.stick, (Material)m).func_190926_b() && GAConfig.GT5U.OldFineWireRecipes) {
                GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.WIREMILL_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.stick, (Material)m));
            }
            if (!GAConfig.GT5U.CablesGT5U) continue;
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtSingle, (Material)m), IntCircuitIngredient.getIntegratedCircuit((int)24)}, new FluidStack[]{Materials.Rubber.getFluid(144)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtSingle, (Material)m, (int)2), IntCircuitIngredient.getIntegratedCircuit((int)25)}, new FluidStack[]{Materials.Rubber.getFluid(288)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtSingle, (Material)m, (int)4), IntCircuitIngredient.getIntegratedCircuit((int)26)}, new FluidStack[]{Materials.Rubber.getFluid(576)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtSingle, (Material)m, (int)8), IntCircuitIngredient.getIntegratedCircuit((int)27)}, new FluidStack[]{Materials.Rubber.getFluid(1152)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtSingle, (Material)m, (int)16), IntCircuitIngredient.getIntegratedCircuit((int)28)}, new FluidStack[]{Materials.Rubber.getFluid(2304)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtDouble, (Material)m), IntCircuitIngredient.getIntegratedCircuit((int)24)}, new FluidStack[]{Materials.Rubber.getFluid(288)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtQuadruple, (Material)m), IntCircuitIngredient.getIntegratedCircuit((int)24)}, new FluidStack[]{Materials.Rubber.getFluid(576)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtOctal, (Material)m), IntCircuitIngredient.getIntegratedCircuit((int)24)}, new FluidStack[]{Materials.Rubber.getFluid(1152)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtHex, (Material)m), IntCircuitIngredient.getIntegratedCircuit((int)24)}, new FluidStack[]{Materials.Rubber.getFluid(2304)});
        }
        if (GAConfig.GT6.BendingCurvedPlates) {
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.BENDER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Iron, (int)12), IntCircuitIngredient.getIntegratedCircuit((int)1));
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.BENDER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.WroughtIron, (int)12), IntCircuitIngredient.getIntegratedCircuit((int)1));
        }
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.MACERATOR_RECIPES, new ItemStack(Items.field_151118_aC));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Silicon, (int)2), OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Polytetrafluoroethylene));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Silicon), OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Plastic));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.LASER_ENGRAVER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.foil, (Material)Materials.Platinum), OreDictUnifier.get((OrePrefix)OrePrefix.craftingLens, (Material)MarkerMaterials.Color.Red));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.LASER_ENGRAVER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.foil, (Material)Materials.Gold), OreDictUnifier.get((OrePrefix)OrePrefix.craftingLens, (Material)MarkerMaterials.Color.Red));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.LASER_ENGRAVER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.foil, (Material)Materials.Electrum), OreDictUnifier.get((OrePrefix)OrePrefix.craftingLens, (Material)MarkerMaterials.Color.Red));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.LASER_ENGRAVER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.foil, (Material)Materials.Copper), OreDictUnifier.get((OrePrefix)OrePrefix.craftingLens, (Material)MarkerMaterials.Color.Red));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.LASER_ENGRAVER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.foil, (Material)Materials.AnnealedCopper), OreDictUnifier.get((OrePrefix)OrePrefix.craftingLens, (Material)MarkerMaterials.Color.Red));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.FORMING_PRESS_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Lapis), OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Glowstone));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.FORMING_PRESS_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Lazurite), OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Glowstone));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.LASER_ENGRAVER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Lazurite, (int)15), OreDictUnifier.get((OrePrefix)OrePrefix.lens, (Material)Materials.Diamond));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.LASER_ENGRAVER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Emerald), OreDictUnifier.get((OrePrefix)OrePrefix.craftingLens, (Material)MarkerMaterials.Color.Lime));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.LASER_ENGRAVER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Olivine), OreDictUnifier.get((OrePrefix)OrePrefix.craftingLens, (Material)MarkerMaterials.Color.Lime));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, MetaItems.ENERGY_LAPOTRONIC_ORB.getStackForm(8), OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Europium, (int)4));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, MetaItems.ENERGY_LAPOTRONIC_ORB2.getStackForm(8), OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Darmstadtium, (int)16));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Tantalum), OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Manganese)}, new FluidStack[]{Materials.Plastic.getFluid(144)});
        for (MaterialStack stack : solderingList) {
            IngotMaterial material = (IngotMaterial)stack.material;
            int multiplier = (int)stack.amount;
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Plastic), OreDictUnifier.get((OrePrefix)OrePrefix.wireGtSingle, (Material)Materials.RedAlloy)}, new FluidStack[]{material.getFluid(18 * multiplier)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtSingle, (Material)Materials.RedAlloy, (int)2), OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Steel)}, new FluidStack[]{material.getFluid(18 * multiplier)});
            ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation("gregtech:primitive_circuit"));
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Plastic, (int)2), MetaItems.DATA_CONTROL_CIRCUIT_IV.getStackForm()}, new FluidStack[]{material.getFluid(72 * multiplier)});
        }
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Silicon)}, new FluidStack[]{Materials.Epichlorhydrin.getFluid(144)});
        GAMachineRecipeRemoval.removeAllRecipes(RecipeMaps.PYROLYSE_RECIPES);
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.NaturalGas.getFluid(16000), Materials.Hydrogen.getFluid(1000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.SulfuricGas.getFluid(16000), Materials.Hydrogen.getFluid(1000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.SulfuricLightFuel.getFluid(6000), Materials.Hydrogen.getFluid(1000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.SulfuricHeavyFuel.getFluid(4000), Materials.Hydrogen.getFluid(1000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.SulfuricNaphtha.getFluid(7000), Materials.Hydrogen.getFluid(1000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Carbon, (int)3), OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Rutile)}, new FluidStack[]{Materials.Chlorine.getFluid(2000)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CENTRIFUGE_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.DarkAsh, (int)2));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CENTRIFUGE_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Ash));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ALLOY_SMELTER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.RawRubber, (int)3), OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Sulfur));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.AUTOCLAVE_RECIPES, new ItemStack[]{new ItemStack(Items.field_151156_bN)}, new FluidStack[]{Materials.Darmstadtium.getFluid(288)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.ingot, (Material)Materials.Plutonium, (int)6));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.Water.getFluid(2000), Materials.NitrogenDioxide.getFluid(4000), Materials.Oxygen.getFluid(1000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ALLOY_SMELTER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.ingot, (Material)Materials.Rubber, (int)2), OreDictUnifier.get((OrePrefix)OrePrefix.wireGtSingle, (Material)Materials.Copper));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.Naphtha.getFluid(288), Materials.Air.getFluid(2000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.dustTiny, (Material)Materials.Titanium)}, new FluidStack[]{Materials.Naphtha.getFluid(1296), Materials.Oxygen.getFluid(16000)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.Epichlorhydrin.getFluid(432), Materials.Naphtha.getFluid(3000), Materials.Fluorine.getFluid(1000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Carbon)}, new FluidStack[]{Materials.LPG.getFluid(432), Materials.Chlorine.getFluid(1000)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Darmstadtium, (int)8), IntCircuitIngredient.getIntegratedCircuit((int)8));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{MetaBlocks.MACHINE_CASING.getItemVariant((Enum)BlockMachineCasing.MachineCasingType.MAX), OreDictUnifier.get((OrePrefix)OrePrefix.wireGtSingle, (Material)MarkerMaterials.Tier.Superconductor, (int)2)}, new FluidStack[]{Materials.Polytetrafluoroethylene.getFluid(288)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ELECTROLYZER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Sphalerite, (int)2));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ELECTROLYZER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Bentonite, (int)66));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.BLAST_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Silicon));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.Oxygen.getFluid(500), Materials.Hydrogen.getFluid(1000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.Hydrogen.getFluid(2000), Materials.Oxygen.getFluid(1000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Carbon)}, new FluidStack[]{Materials.Hydrogen.getFluid(4000)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.Nitrogen.getFluid(1000), Materials.Oxygen.getFluid(2000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.Oxygen.getFluid(2000), Materials.Nitrogen.getFluid(1000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.Glyceryl.getFluid(250), Materials.LightFuel.getFluid(1000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.Glyceryl.getFluid(250), Materials.Fuel.getFluid(1000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.Fuel.getFluid(4000), Materials.Glyceryl.getFluid(1000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CHEMICAL_RECIPES, Materials.LightFuel.getFluid(4000), Materials.Glyceryl.getFluid(1000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.MIXER_RECIPES, Materials.LightFuel.getFluid(5000), Materials.HeavyFuel.getFluid(1000));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.FLUID_EXTRACTION_RECIPES, new ItemStack(Items.field_151014_N));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.FLUID_EXTRACTION_RECIPES, new ItemStack(Items.field_151081_bc));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.FLUID_EXTRACTION_RECIPES, new ItemStack(Items.field_151080_bb));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.FUSION_RECIPES, Materials.Lithium.getFluid(16), Materials.Tungsten.getFluid(16));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.COMPRESSOR_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Redstone));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CUTTER_RECIPES, new ItemStack[]{new ItemStack(Blocks.field_150371_ca)}, new FluidStack[]{Materials.Water.getFluid(73)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CUTTER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.block, (Material)Materials.CertusQuartz)}, new FluidStack[]{Materials.Water.getFluid(73)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CUTTER_RECIPES, new ItemStack[]{new ItemStack(Blocks.field_150371_ca)}, new FluidStack[]{Materials.DistilledWater.getFluid(55)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CUTTER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.block, (Material)Materials.CertusQuartz)}, new FluidStack[]{Materials.DistilledWater.getFluid(55)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CUTTER_RECIPES, new ItemStack[]{new ItemStack(Blocks.field_150371_ca)}, new FluidStack[]{Materials.Lubricant.getFluid(18)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CUTTER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.block, (Material)Materials.CertusQuartz)}, new FluidStack[]{Materials.Lubricant.getFluid(18)});
    }

    private static <R extends RecipeBuilder<R>> void removeRecipesByInputs(RecipeMap<R> map, ItemStack ... itemInputs) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (ItemStack s : itemInputs) {
            inputs.add(s);
        }
        map.removeRecipe(map.findRecipe(Long.MAX_VALUE, inputs, Collections.emptyList(), Integer.MAX_VALUE));
    }

    private static <R extends RecipeBuilder<R>> void removeRecipesByInputs(RecipeMap<R> map, FluidStack ... fluidInputs) {
        ArrayList<FluidStack> inputs = new ArrayList<FluidStack>();
        for (FluidStack s : fluidInputs) {
            inputs.add(s);
        }
        map.removeRecipe(map.findRecipe(Long.MAX_VALUE, Collections.emptyList(), inputs, Integer.MAX_VALUE));
    }

    private static <R extends RecipeBuilder<R>> void removeRecipesByInputs(RecipeMap<R> map, ItemStack[] itemInputs, FluidStack[] fluidInputs) {
        ArrayList<ItemStack> itemIn = new ArrayList<ItemStack>();
        for (ItemStack s : itemInputs) {
            itemIn.add(s);
        }
        ArrayList<FluidStack> fluidIn = new ArrayList<FluidStack>();
        for (FluidStack s : fluidInputs) {
            fluidIn.add(s);
        }
        map.removeRecipe(map.findRecipe(Long.MAX_VALUE, itemIn, fluidIn, Integer.MAX_VALUE));
    }

    private static <R extends RecipeBuilder<R>> void removeAllRecipes(RecipeMap<R> map) {
        ArrayList recipes = new ArrayList();
        recipes.addAll(map.getRecipeList());
        for (Recipe r : recipes) {
            map.removeRecipe(r);
        }
    }
}

