/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions.machines;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregicadditions.client.ClientHandler;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.render.Textures;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.util.GTUtility;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityCrate
extends MetaTileEntity {
    private final SolidMaterial material;
    private final int inventorySize;
    private ItemStackHandler inventory;

    public TileEntityCrate(ResourceLocation metaTileEntityId, SolidMaterial material, int inventorySize) {
        super(metaTileEntityId);
        this.material = material;
        this.inventorySize = inventorySize;
        this.initializeInventory();
    }

    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new TileEntityCrate(this.metaTileEntityId, this.material, this.inventorySize);
    }

    public boolean hasFrontFacing() {
        return false;
    }

    public int getLightOpacity() {
        return 1;
    }

    public String getHarvestTool() {
        return this.material.toString().contains("wood") ? "axe" : "pickaxe";
    }

    protected void initializeInventory() {
        super.initializeInventory();
        this.inventory = new ItemStackHandler(this.inventorySize){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileEntityCrate.this.updateComparatorValue();
            }
        };
        this.itemInventory = this.inventory;
        this.updateComparatorValue();
    }

    public int getActualComparatorValue() {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.inventory);
    }

    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        TileEntityCrate.clearInventory(itemBuffer, (IItemHandlerModifiable)this.inventory);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture() {
        return this.material.toString().contains("wood") ? Textures.WOODEN_CHEST.getParticleTexture() : ClientHandler.METAL_CRATE.getParticleTexture();
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        if (this.material.toString().contains("wood")) {
            ClientHandler.WOODEN_CRATE.render(renderState, translation, GTUtility.convertRGBtoOpaqueRGBA_CL((int)this.getPaintingColorForRendering()), pipeline);
        } else {
            int baseColor = ColourRGBA.multiply((int)GTUtility.convertRGBtoOpaqueRGBA_CL((int)this.material.materialRGB), (int)GTUtility.convertRGBtoOpaqueRGBA_CL((int)this.getPaintingColorForRendering()));
            ClientHandler.METAL_CRATE.render(renderState, translation, baseColor, pipeline);
        }
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder((TextureArea)GuiTextures.BACKGROUND, (int)338, (int)(8 + this.inventorySize + 104)).label(5, 5, this.getMetaFullName());
        for (int i = 0; i < this.inventorySize; ++i) {
            builder.slot((IItemHandlerModifiable)this.inventory, i, 8 + i % 18 * 18, 18 + i / 18 * 18, new TextureArea[]{GuiTextures.SLOT});
        }
        builder.bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT, 90, 18 + this.inventorySize + 12);
        return builder.build((IUIHolder)this.getHolder(), entityPlayer);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
        return data;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inventory.deserializeNBT(data.func_74775_l("Inventory"));
    }

    protected boolean shouldSerializeInventories() {
        return false;
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_storage_capacity", (Object[])new Object[]{this.inventorySize}));
    }
}

