/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions;

import gregicadditions.GAEnums;
import gregicadditions.item.GAMetaBlocks;
import gregicadditions.item.GAMetaItems;
import gregicadditions.machines.GATileEntities;
import gregicadditions.recipes.GAMachineRecipeRemoval;
import gregicadditions.recipes.GARecipeAddition;
import gregicadditions.recipes.GeneratorFuels;
import gregicadditions.recipes.MachineCraftingRecipes;
import gregicadditions.recipes.MatterReplication;
import gregtech.common.blocks.VariantItemBlock;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="gtadditions", name="Shadows of Greg", version="1.12.2-2.8.0", dependencies="required-after:gregtech@[1.8.1.404,);after:gtcebees", acceptedMinecraftVersions="[1.12.2]")
public class GregicAdditions {
    public static final String MODID = "gtadditions";
    public static final String NAME = "Shadows of Greg";
    public static final String VERSION = "1.12.2-2.8.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"gtadditions");

    public GregicAdditions() {
        GAEnums.preInit();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        GAMetaItems.init();
        GAMetaBlocks.init();
        GATileEntities.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        GARecipeAddition.generatedRecipes();
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)GAMetaBlocks.MUTLIBLOCK_CASING);
        registry.register((IForgeRegistryEntry)GAMetaBlocks.TRANSPARENT_CASING);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)this.createItemBlock(GAMetaBlocks.MUTLIBLOCK_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)this.createItemBlock(GAMetaBlocks.TRANSPARENT_CASING, VariantItemBlock::new));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        GAMachineRecipeRemoval.init();
        GARecipeAddition.init();
        GARecipeAddition.init2();
        GARecipeAddition.forestrySupport();
        MatterReplication.init();
        MachineCraftingRecipes.init();
        GeneratorFuels.init();
        GAMetaItems.registerOreDict();
        GAMetaItems.registerRecipes();
    }

    private <T extends Block> ItemBlock createItemBlock(T block, Function<T, ItemBlock> producer) {
        ItemBlock itemBlock = producer.apply(block);
        itemBlock.setRegistryName(block.getRegistryName());
        return itemBlock;
    }
}

