/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank;

import com.enderio.core.api.client.gui.IGuiOverlay;
import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.IDrawingElement;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.common.util.NullHelper;
import com.google.common.base.Predicate;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import crazypants.enderio.base.gui.RedstoneModeButton;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.machine.gui.GuiButtonIoConfig;
import crazypants.enderio.base.machine.gui.GuiOverlayIoConfig;
import crazypants.enderio.base.machine.gui.IPowerBarData;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.base.machine.interfaces.IRedstoneModeControlable;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.powertools.machine.capbank.ContainerCapBank;
import crazypants.enderio.powertools.machine.capbank.TileCapBank;
import crazypants.enderio.powertools.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.powertools.machine.capbank.packet.PacketGuiChange;
import crazypants.enderio.powertools.machine.capbank.packet.PacketNetworkStateRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCapBank
extends GuiContainerBaseEIO {
    @Nonnull
    private static final CapBankClientNetwork NULL_NETWORK = new CapBankClientNetwork(-1);
    protected static final int INPUT_BUTTON_ID = 18;
    protected static final int OUTPUT_BUTTON_ID = 37;
    protected static final int CONFIG_ID = 377996104;
    private static final int POWER_X = 8;
    private static final int POWER_Y = 9;
    private static final int POWER_HEIGHT = 68;
    protected static final int BOTTOM_POWER_Y = 77;
    private int inputX = 104;
    private int inputY = 18;
    private int outputX = 104;
    private int outputY = 36;
    private int rightMargin = 8;
    @Nonnull
    private final TileCapBank capBank;
    @Nonnull
    private final RedstoneModeButton<?> inputRsButton;
    @Nonnull
    private final RedstoneModeButton<?> outputRsButton;
    @Nonnull
    private final TextFieldEnder maxInputTF;
    @Nonnull
    private final TextFieldEnder maxOutputTF;
    @Nonnull
    private final GuiOverlayIoConfig<TileCapBank> configOverlay;
    @Nonnull
    private final GuiButtonIoConfig<TileCapBank> configB;
    @Nonnull
    private CapBankClientNetwork network = NULL_NETWORK;
    private int initialStateCount = -1;
    private boolean initState = true;
    private boolean textFieldsHaveRealData = false;
    @Nonnull
    private PowerBar powerBar;

    public GuiCapBank(Entity player, InventoryPlayer playerInv, @Nonnull TileCapBank te, @Nonnull ContainerCapBank container) {
        super((Container)container, new String[]{"capacitor_bank"});
        this.capBank = te;
        this.updateState();
        this.field_146999_f = 176;
        int x = this.field_146999_f - this.rightMargin - 16;
        int y = this.inputY;
        this.inputRsButton = new RedstoneModeButton((IGuiScreen)this, -1, x, y, new IRedstoneModeControlable(){

            public void setRedstoneControlMode(@Nonnull RedstoneControlMode mode) {
                GuiCapBank.this.network.setInputControlMode(mode);
                GuiCapBank.this.sendUpdateToServer();
            }

            @Nonnull
            public RedstoneControlMode getRedstoneControlMode() {
                return GuiCapBank.this.network.getInputControlMode();
            }

            public boolean getRedstoneControlStatus() {
                return false;
            }
        });
        this.inputRsButton.setToolTip(new String[]{"enderio.gui.cap_bank.inputRs"});
        this.outputRsButton = new RedstoneModeButton((IGuiScreen)this, -1, x, y += 18, new IRedstoneModeControlable(){

            public void setRedstoneControlMode(@Nonnull RedstoneControlMode mode) {
                GuiCapBank.this.network.setOutputControlMode(mode);
                GuiCapBank.this.sendUpdateToServer();
            }

            @Nonnull
            public RedstoneControlMode getRedstoneControlMode() {
                return GuiCapBank.this.network.getOutputControlMode();
            }

            public boolean getRedstoneControlStatus() {
                return false;
            }
        });
        this.outputRsButton.setToolTip(new String[]{"enderio.gui.cap_bank.output_rs"});
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        if (this.network.getMembers().size() < 200) {
            for (TileCapBank cb : this.network.getMembers()) {
                coords.add(cb.getLocation());
            }
        }
        if (coords.isEmpty()) {
            coords.add(te.getLocation());
        }
        this.configOverlay = new GuiOverlayIoConfig<TileCapBank>(coords){

            @Nonnull
            protected String getLabelForMode(IoMode mode) {
                if (mode == IoMode.PUSH) {
                    return crazypants.enderio.powertools.lang.Lang.GUI_CAPBANK_OUTPUT_MODE.get();
                }
                if (mode == IoMode.PULL) {
                    return crazypants.enderio.powertools.lang.Lang.GUI_CAPBANK_INPUT_MODE.get();
                }
                return super.getLabelForMode(mode);
            }
        };
        this.addOverlay((IGuiOverlay)this.configOverlay);
        this.configB = new GuiButtonIoConfig((IGuiScreen)this, 377996104, x, y += 20, (TileEntity)te, this.configOverlay);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        Predicate inputValidator = s -> s == null || s.isEmpty() || !s.startsWith("0") && (Integer)NullHelper.first((Object[])new Integer[]{LangPower.parsePower((String)s), Integer.MAX_VALUE}) <= this.network.getMaxIO();
        x = this.inputX - 24;
        y = this.inputY;
        this.maxInputTF = new TextFieldEnder(fr, x, y, 68, 16);
        this.maxInputTF.func_175205_a(inputValidator);
        this.maxInputTF.setCharFilter(TextFieldEnder.FILTER_NUMERIC);
        x = this.outputX - 24;
        y = this.outputY;
        this.maxOutputTF = new TextFieldEnder(fr, x, y, 68, 16);
        this.maxOutputTF.func_175205_a(inputValidator);
        this.maxOutputTF.setCharFilter(TextFieldEnder.FILTER_NUMERIC);
        this.textFields.add((Object)this.maxInputTF);
        this.textFields.add((Object)this.maxOutputTF);
        this.powerBar = new PowerBar((IPowerBarData)te, (GuiContainerBaseEIO)this, 8, 9, 68);
        this.addDrawingElement((IDrawingElement)this.powerBar);
        this.powerBar.addTooltip(PowerBar.Op.REPLACE, PowerBar.What.ALL, new Supplier[]{() -> LangPower.format((long)this.network.getEnergyStoredL()) + " " + LangPower.ofStr(), () -> TextFormatting.WHITE + LangPower.format((long)this.network.getMaxEnergyStoredL()) + " " + TextFormatting.GRAY + LangPower.RF(), () -> Lang.POWER_PERTICK.get(new Object[]{this.getIOColor() + LangPower.format((int)Math.round(this.network.getAverageChangePerTick())) + TextFormatting.GRAY})});
    }

    @Nonnull
    private String getIOColor() {
        float change = this.network.getAverageChangePerTick();
        if (change > 0.0f) {
            return TextFormatting.GREEN + "+";
        }
        if (change < 0.0f) {
            return TextFormatting.RED + "";
        }
        return TextFormatting.WHITE + "";
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.configB.onGuiInit();
        this.inputRsButton.onGuiInit();
        this.outputRsButton.onGuiInit();
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        this.updateInputOutput();
    }

    private void updateInputOutput() {
        int output;
        if (!this.textFieldsHaveRealData) {
            return;
        }
        int input = LangPower.parsePower((GuiTextField)this.maxInputTF);
        if (input >= 0 && this.network.getMaxInput() != input) {
            this.setMaxInput(input);
        }
        if ((output = LangPower.parsePower((GuiTextField)this.maxOutputTF)) >= 0 && this.network.getMaxOutput() != output) {
            this.setMaxOutput(output);
        }
    }

    private void setMaxOutput(int output) {
        if (output != this.network.getMaxOutput()) {
            this.network.setMaxOutput(output);
            this.maxOutputTF.func_146180_a(LangPower.format((int)this.network.getMaxOutput()));
            this.sendUpdateToServer();
        }
    }

    private void setMaxInput(int input) {
        if (input != this.network.getMaxInput()) {
            this.network.setMaxInput(input);
            this.maxInputTF.func_146180_a(LangPower.format((int)this.network.getMaxInput()));
            this.sendUpdateToServer();
        }
    }

    protected void sendUpdateToServer() {
        if (this.network != NULL_NETWORK) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGuiChange(this.capBank));
        }
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        this.requestStateUpdate();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(i);
            guibutton.func_191745_a(this.field_146297_k, 0, 0, par1);
        }
        int midX = sx + this.field_146999_f / 2;
        String str = crazypants.enderio.powertools.lang.Lang.GUI_CAPBANK_MAX_IO.get() + " " + LangPower.RFt((int)this.network.getMaxIO());
        FontRenderer fr = this.getFontRenderer();
        int swid = fr.func_78256_a(str);
        int x = midX - swid / 2;
        int y = this.field_147009_r + 5;
        this.func_73731_b(fr, str, x, y, -1);
        str = crazypants.enderio.powertools.lang.Lang.GUI_CAPBANK_MAX_INPUT.get() + ":";
        swid = fr.func_78256_a(str);
        x = this.field_147003_i + this.inputX - swid - 26;
        y = this.field_147009_r + this.inputY + 2;
        this.func_73731_b(fr, str, x, y, -1);
        str = crazypants.enderio.powertools.lang.Lang.GUI_CAPBANK_MAX_OUTPUT.get() + ":";
        swid = fr.func_78256_a(str);
        x = this.field_147003_i + this.outputX - swid - 26;
        y = this.field_147009_r + this.outputY + 2;
        this.func_73731_b(fr, str, x, y, -1);
        super.func_146976_a(par1, par2, par3);
    }

    public void drawHoveringText(@Nonnull List<String> par1List, int par2, int par3, @Nonnull FontRenderer font) {
        super.drawHoveringText(par1List, par2, par3, font);
    }

    @Nonnull
    public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    private void requestStateUpdate() {
        if (EnderIO.proxy.getTickCount() % 2L == 0L && !this.updateState()) {
            this.network.requestPowerUpdate(this.capBank, 2);
        }
    }

    private boolean updateState() {
        if (!this.initState) {
            return false;
        }
        if (this.capBank.getNetwork() == null) {
            this.network = NULL_NETWORK;
            return true;
        }
        if (this.network == NULL_NETWORK) {
            this.network = (CapBankClientNetwork)NullHelper.first((Object[])new CapBankClientNetwork[]{(CapBankClientNetwork)this.capBank.getNetwork(), NULL_NETWORK});
            this.initialStateCount = this.network.getStateUpdateCount();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNetworkStateRequest(this.capBank));
            return true;
        }
        if (this.network.getStateUpdateCount() == this.initialStateCount) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNetworkStateRequest(this.capBank));
            return true;
        }
        if (this.network.getStateUpdateCount() > this.initialStateCount) {
            this.updateFieldsFromState();
            this.initState = false;
            return true;
        }
        return false;
    }

    private void updateFieldsFromState() {
        this.maxInputTF.func_146180_a(LangPower.format((int)this.network.getMaxInput()));
        this.maxOutputTF.func_146180_a(LangPower.format((int)this.network.getMaxOutput()));
        this.textFieldsHaveRealData = true;
        this.inputRsButton.setModeRaw(RedstoneControlMode.IconHolder.getFromMode((RedstoneControlMode)this.network.getInputControlMode()));
        this.outputRsButton.setModeRaw(RedstoneControlMode.IconHolder.getFromMode((RedstoneControlMode)this.network.getOutputControlMode()));
    }
}

