/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.gui;

import com.enderio.core.client.gui.widget.GhostBackgroundItemSlot;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.ContainerEnderCap;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IExternalConnectionContainer;
import crazypants.enderio.base.conduit.IFilterChangeListener;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.IFilterContainer;
import crazypants.enderio.base.filter.capability.CapabilityFilterHolder;
import crazypants.enderio.base.filter.capability.IFilterHolder;
import crazypants.enderio.base.filter.network.IOpenFilterRemoteExec;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.conduits.capability.CapabilityUpgradeHolder;
import crazypants.enderio.conduits.capability.IUpgradeHolder;
import crazypants.enderio.conduits.conduit.TileConduitBundle;
import crazypants.enderio.conduits.gui.InventoryUpgrades;
import crazypants.enderio.conduits.init.ConduitObject;
import crazypants.enderio.conduits.network.PacketSlotVisibility;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ExternalConnectionContainer
extends ContainerEnderCap<InventoryUpgrades, TileConduitBundle>
implements IExternalConnectionContainer,
IOpenFilterRemoteExec.Container,
IFilterContainer {
    private int speedUpgradeSlotLimit = 15;
    private Slot slotFunctionUpgrade;
    private Slot slotInputFilter;
    private Slot slotOutputFilter;
    @Nonnull
    private EnumFacing dir;
    @Nonnull
    private EntityPlayer player;
    private IConduit currentCon;
    final List<IFilterChangeListener> filterListeners = new ArrayList<IFilterChangeListener>();
    private int guiId = -1;

    public ExternalConnectionContainer(@Nonnull InventoryPlayer playerInv, @Nonnull EnumFacing dir, @Nonnull TileConduitBundle bundle) {
        super(playerInv, (IItemHandler)new InventoryUpgrades(dir), (TileEntity)bundle);
        this.dir = dir;
        this.player = playerInv.field_70458_d;
    }

    protected void addSlots() {
        this.slotInputFilter = new FilterSlot(this.getItemHandler(), 3, 23, 71);
        this.func_75146_a(this.slotInputFilter);
        this.slotOutputFilter = new FilterSlot(this.getItemHandler(), 2, 113, 71);
        this.func_75146_a(this.slotOutputFilter);
        this.slotFunctionUpgrade = new SlotItemHandler(this.getItemHandler(), 0, 131, 71){

            public boolean func_75214_a(@Nonnull ItemStack itemStack) {
                return ((InventoryUpgrades)ExternalConnectionContainer.this.getItemHandler()).isItemValidForSlot(0, itemStack, ExternalConnectionContainer.this.currentCon);
            }

            public int func_75219_a() {
                return ExternalConnectionContainer.this.speedUpgradeSlotLimit;
            }
        };
        this.func_75146_a(this.slotFunctionUpgrade);
    }

    public void createGhostSlots(@Nonnull NNList<GhostSlot> ghostSlots) {
        NNList filtersAll = new NNList((Object[])new ItemStack[]{new ItemStack(ModObject.itemBasicItemFilter.getItemNN())});
        NNList upgrades = new NNList((Object[])new ItemStack[]{new ItemStack(ConduitObject.item_extract_speed_upgrade.getItemNN()), new ItemStack(ConduitObject.item_extract_speed_downgrade.getItemNN())});
        this.createGhostSlots(ghostSlots, (NNList<ItemStack>)filtersAll, (NNList<ItemStack>)filtersAll, (NNList<ItemStack>)upgrades);
    }

    public void createGhostSlots(@Nonnull NNList<GhostSlot> ghostSlots, @Nonnull NNList<ItemStack> filters, @Nonnull NNList<ItemStack> upgrades) {
        this.createGhostSlots(ghostSlots, filters, filters, upgrades);
    }

    public void createGhostSlots(@Nonnull NNList<GhostSlot> ghostSlots, @Nonnull NNList<ItemStack> filtersIn, @Nonnull NNList<ItemStack> filtersOut, @Nonnull NNList<ItemStack> upgrades) {
        ghostSlots.add((Object)new GhostBackgroundItemSlot(filtersIn, this.slotInputFilter));
        ghostSlots.add((Object)new GhostBackgroundItemSlot(filtersOut, this.slotOutputFilter));
        ghostSlots.add((Object)new GhostBackgroundItemSlot(upgrades, this.slotFunctionUpgrade));
    }

    @Nonnull
    public Point getPlayerInventoryOffset() {
        return new Point(23, 113);
    }

    public void addFilterListener(@Nonnull IFilterChangeListener list) {
        this.filterListeners.add(list);
    }

    protected void filterChanged() {
        for (IFilterChangeListener list : this.filterListeners) {
            list.onFilterChanged();
        }
    }

    public boolean hasFunctionUpgrade() {
        return this.slotFunctionUpgrade != null && this.slotFunctionUpgrade.func_75216_d();
    }

    public boolean hasFilter(boolean input) {
        Slot slot = input ? this.slotInputFilter : this.slotOutputFilter;
        return slot != null && slot.func_75216_d();
    }

    public void setInOutSlotsVisible(boolean filterVisible, boolean upgradeVisible, @Nonnull IConduit conduit) {
        if (conduit == null) {
            return;
        }
        World world = ((TileConduitBundle)this.getTileEntityNN()).getBundleworld();
        boolean hasFilterHolder = false;
        boolean hasUpgradeHolder = false;
        this.currentCon = conduit;
        if (filterVisible || upgradeVisible) {
            hasFilterHolder = conduit.hasInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, this.dir);
            hasUpgradeHolder = conduit.hasInternalCapability(CapabilityUpgradeHolder.UPGRADE_HOLDER_CAPABILITY, this.dir);
            if (hasFilterHolder) {
                ((InventoryUpgrades)this.getItemHandler()).setFilterHolder((IFilterHolder<IFilter>)((IFilterHolder)conduit.getInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, this.dir)));
            }
            if (hasUpgradeHolder) {
                ((InventoryUpgrades)this.getItemHandler()).setUpgradeHolder((IUpgradeHolder)conduit.getInternalCapability(CapabilityUpgradeHolder.UPGRADE_HOLDER_CAPABILITY, this.dir));
            }
        }
        this.setSlotsVisible(filterVisible && hasFilterHolder, upgradeVisible && hasUpgradeHolder);
        if (world.field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSlotVisibility(conduit, filterVisible, upgradeVisible));
        }
    }

    private void setSlotsVisible(boolean filterVisible, boolean upgradeVisible) {
        Slot inFilter = this.func_75139_a(1);
        Slot outFilter = this.func_75139_a(0);
        Slot funcUpgrade = this.func_75139_a(2);
        if (filterVisible) {
            this.slotInputFilter.field_75223_e = ((Point)this.slotLocations.get((Object)this.slotInputFilter)).x;
            this.slotInputFilter.field_75221_f = ((Point)this.slotLocations.get((Object)this.slotInputFilter)).y;
            this.slotOutputFilter.field_75223_e = ((Point)this.slotLocations.get((Object)this.slotOutputFilter)).x;
            this.slotOutputFilter.field_75221_f = ((Point)this.slotLocations.get((Object)this.slotOutputFilter)).y;
            inFilter.field_75223_e = ((Point)this.slotLocations.get((Object)inFilter)).x;
            inFilter.field_75221_f = ((Point)this.slotLocations.get((Object)inFilter)).y;
            outFilter.field_75223_e = ((Point)this.slotLocations.get((Object)outFilter)).x;
            outFilter.field_75221_f = ((Point)this.slotLocations.get((Object)outFilter)).y;
        } else {
            this.slotInputFilter.field_75223_e = -3000;
            this.slotInputFilter.field_75221_f = -3000;
            this.slotOutputFilter.field_75223_e = -3000;
            this.slotOutputFilter.field_75221_f = -3000;
            inFilter.field_75223_e = -3000;
            inFilter.field_75221_f = -3000;
            outFilter.field_75223_e = -3000;
            outFilter.field_75221_f = -3000;
        }
        if (upgradeVisible) {
            this.slotFunctionUpgrade.field_75223_e = ((Point)this.slotLocations.get((Object)this.slotFunctionUpgrade)).x;
            this.slotFunctionUpgrade.field_75221_f = ((Point)this.slotLocations.get((Object)this.slotFunctionUpgrade)).y;
            funcUpgrade.field_75223_e = ((Point)this.slotLocations.get((Object)funcUpgrade)).x;
            funcUpgrade.field_75221_f = ((Point)this.slotLocations.get((Object)funcUpgrade)).y;
        } else {
            this.slotFunctionUpgrade.field_75223_e = -3000;
            this.slotFunctionUpgrade.field_75221_f = -3000;
            funcUpgrade.field_75223_e = -3000;
            funcUpgrade.field_75221_f = -3000;
        }
    }

    public void setGuiID(int id) {
        this.guiId = id;
    }

    public int getGuiID() {
        return this.guiId;
    }

    public IMessage doOpenFilterGui(int filterIndex) {
        if (this.currentCon.hasInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, this.dir)) {
            IFilterHolder filterHolder = (IFilterHolder)this.currentCon.getInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, this.dir);
            int param1 = this.dir.ordinal();
            if (filterHolder != null) {
                filterHolder.getFilter(filterIndex, param1).openGui(this.player, filterHolder.getFilterStack(filterIndex, param1), ((TileConduitBundle)this.getTileEntityNN()).getBundleworld(), ((TileConduitBundle)this.getTileEntityNN()).func_174877_v(), this.dir, filterIndex);
            }
        }
        return null;
    }

    @Nonnull
    public IFilter getFilter(int filterIndex) {
        if (this.currentCon.hasInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, this.dir)) {
            IFilterHolder filterHolder = (IFilterHolder)this.currentCon.getInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, this.dir);
            int param1 = this.dir.ordinal();
            if (filterHolder != null) {
                return filterHolder.getFilter(filterIndex, param1);
            }
        }
        return null;
    }

    private class FilterSlot
    extends SlotItemHandler {
        public FilterSlot(IItemHandler handler, int index, int x, int y) {
            super(handler, index, x, y);
        }

        public int func_75219_a() {
            return 1;
        }

        public void func_75218_e() {
            ExternalConnectionContainer.this.filterChanged();
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return ((InventoryUpgrades)ExternalConnectionContainer.this.getItemHandler()).isItemValidForSlot(this.getSlotIndex(), stack, ExternalConnectionContainer.this.currentCon);
        }
    }
}

