/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.power;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.diagnostics.Prof;
import crazypants.enderio.base.power.IPowerInterface;
import crazypants.enderio.base.power.IPowerStorage;
import crazypants.enderio.conduits.conduit.power.IPowerConduit;
import crazypants.enderio.conduits.conduit.power.PowerConduitNetwork;
import crazypants.enderio.conduits.conduit.power.PowerTracker;
import crazypants.enderio.conduits.config.ConduitConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class NetworkPowerManager {
    private final PowerConduitNetwork network;
    long maxEnergyStored;
    long energyStored;
    private final List<PowerConduitNetwork.ReceptorEntry> receptors = new ArrayList<PowerConduitNetwork.ReceptorEntry>();
    private ListIterator<PowerConduitNetwork.ReceptorEntry> receptorIterator = this.receptors.listIterator();
    private final List<PowerConduitNetwork.ReceptorEntry> storageReceptors = new ArrayList<PowerConduitNetwork.ReceptorEntry>();
    private boolean receptorsDirty = true;
    private final Map<IPowerConduit, PowerTracker> powerTrackers = new HashMap<IPowerConduit, PowerTracker>();
    private final PowerTracker networkPowerTracker = new PowerTracker();
    private final CapBankSupply capSupply = new CapBankSupply();
    private int errorSupressionA = 0;
    private int errorSupressionB = 0;

    public NetworkPowerManager(@Nonnull PowerConduitNetwork network, @Nonnull World world) {
        this.network = network;
        this.maxEnergyStored = 64L;
    }

    public PowerTracker getTracker(IPowerConduit conduit) {
        return this.powerTrackers.get(conduit);
    }

    public PowerTracker getNetworkPowerTracker() {
        return this.networkPowerTracker;
    }

    public int getPowerInConduits() {
        return this.energyStored > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.energyStored;
    }

    public int getMaxPowerInConduits() {
        return this.maxEnergyStored > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.maxEnergyStored;
    }

    public long getPowerInCapacitorBanks() {
        if (this.capSupply == null) {
            return 0L;
        }
        return this.capSupply.stored;
    }

    public long getMaxPowerInCapacitorBanks() {
        if (this.capSupply == null) {
            return 0L;
        }
        return this.capSupply.maxCap;
    }

    public long getPowerInReceptors() {
        long result = 0L;
        HashSet<Object> done = new HashSet<Object>();
        for (PowerConduitNetwork.ReceptorEntry re : this.receptors) {
            IPowerInterface powerReceptor;
            if (re.emmiter.getConnectionsDirty() || (powerReceptor = re.getPowerInterface()) == null || done.contains(powerReceptor.getProvider())) continue;
            done.add(powerReceptor.getProvider());
            result += (long)powerReceptor.getEnergyStored();
        }
        return result;
    }

    public long getMaxPowerInReceptors() {
        long result = 0L;
        HashSet<Object> done = new HashSet<Object>();
        for (PowerConduitNetwork.ReceptorEntry re : this.receptors) {
            IPowerInterface powerReceptor;
            if (re.emmiter.getConnectionsDirty() || (powerReceptor = re.getPowerInterface()) == null || done.contains(powerReceptor.getProvider())) continue;
            done.add(powerReceptor.getProvider());
            result += (long)powerReceptor.getMaxEnergyStored();
        }
        return result;
    }

    public void applyRecievedPower(@Nullable Profiler theProfiler) {
        block3: {
            try {
                this.doApplyRecievedPower(theProfiler);
            }
            catch (Exception e) {
                if (this.errorSupressionA-- <= 0) {
                    Log.warn((Object[])new Object[]{"NetworkPowerManager: Exception thrown when updating power network " + e});
                    e.printStackTrace();
                    this.errorSupressionA = 200;
                    this.errorSupressionB = 20;
                }
                if (this.errorSupressionB-- > 0) break block3;
                Log.warn((Object[])new Object[]{"NetworkPowerManager: Exception thrown when updating power network " + e});
                this.errorSupressionB = 20;
            }
        }
    }

    public void doApplyRecievedPower(@Nullable Profiler profiler) {
        long available;
        this.trackerStartTick();
        Prof.start((Profiler)profiler, (String)"checkReceptors");
        this.checkReceptors();
        Prof.next((Profiler)profiler, (String)"updateNetworkStorage");
        this.updateNetworkStorage();
        this.networkPowerTracker.tickStart(this.energyStored);
        Prof.next((Profiler)profiler, (String)"capSupplyInit");
        this.capSupply.init();
        int numReceptors = this.receptors.size();
        long wasAvailable = available = this.energyStored + (long)this.capSupply.canExtract;
        if (available <= 0L || this.receptors.isEmpty() && this.storageReceptors.isEmpty()) {
            this.trackerEndTick();
            this.networkPowerTracker.tickEnd(this.energyStored);
            Prof.stop((Profiler)profiler);
            return;
        }
        Prof.next((Profiler)profiler, (String)"sendEnergy");
        for (int appliedCount = 0; available > 0L && appliedCount < numReceptors; ++appliedCount) {
            PowerConduitNetwork.ReceptorEntry r;
            IPowerInterface pp;
            if (!this.receptors.isEmpty() && !this.receptorIterator.hasNext()) {
                this.receptorIterator = this.receptors.listIterator();
            }
            if ((pp = (r = this.receptorIterator.next()).getPowerInterface()) == null) continue;
            int canOffer = (int)Math.min((long)r.emmiter.getMaxEnergyExtracted(r.direction), available);
            Prof.start((Profiler)profiler, (String)"", (Object)pp.getProvider());
            int used = pp.receiveEnergy(canOffer, false);
            Prof.next((Profiler)profiler, (String)"trackEnergy");
            used = Math.max(0, used);
            this.trackerSend(r.emmiter, used, false);
            Prof.stop((Profiler)profiler);
            if ((available -= (long)used) <= 0L) break;
        }
        long used = wasAvailable - available;
        this.energyStored -= used;
        Prof.next((Profiler)profiler, (String)"capBankUpdate");
        if (!this.capSupply.capBanks.isEmpty()) {
            long capBankChange = 0L;
            if (this.energyStored < 0L) {
                capBankChange = this.energyStored;
                this.energyStored = 0L;
            } else if (this.energyStored > 0L) {
                capBankChange = Math.min(this.energyStored, (long)this.capSupply.canFill);
                this.energyStored -= capBankChange;
            }
            if (capBankChange < 0L) {
                this.capSupply.remove(Math.abs(capBankChange));
            } else if (capBankChange > 0L) {
                this.energyStored += this.capSupply.add(capBankChange);
            }
            this.capSupply.balance();
        }
        Prof.next((Profiler)profiler, (String)"conduitUpdate");
        this.distributeStorageToConduits();
        Prof.next((Profiler)profiler, (String)"trackEnergy");
        this.trackerEndTick();
        this.networkPowerTracker.tickEnd(this.energyStored);
        Prof.stop((Profiler)profiler);
    }

    private void trackerStartTick() {
        if (!((Boolean)ConduitConfig.detailedTracking.get()).booleanValue()) {
            return;
        }
        for (IPowerConduit con : this.network.getConduits()) {
            if (!con.hasExternalConnections()) continue;
            PowerTracker tracker = this.getOrCreateTracker(con);
            tracker.tickStart(con.getEnergyStored());
        }
    }

    private void trackerSend(@Nonnull IPowerConduit con, int sent, boolean fromBank) {
        if (!fromBank) {
            this.networkPowerTracker.powerSent(sent);
        }
        if (!((Boolean)ConduitConfig.detailedTracking.get()).booleanValue()) {
            return;
        }
        this.getOrCreateTracker(con).powerSent(sent);
    }

    private void trackerRecieve(@Nonnull IPowerConduit con, int recieved, boolean fromBank) {
        if (!fromBank) {
            this.networkPowerTracker.powerRecieved(recieved);
        }
        if (!((Boolean)ConduitConfig.detailedTracking.get()).booleanValue()) {
            return;
        }
        this.getOrCreateTracker(con).powerRecieved(recieved);
    }

    private void trackerEndTick() {
        if (!((Boolean)ConduitConfig.detailedTracking.get()).booleanValue()) {
            return;
        }
        for (IPowerConduit con : this.network.getConduits()) {
            if (!con.hasExternalConnections()) continue;
            PowerTracker tracker = this.getOrCreateTracker(con);
            tracker.tickEnd(con.getEnergyStored());
        }
    }

    private PowerTracker getOrCreateTracker(@Nonnull IPowerConduit con) {
        PowerTracker result = this.powerTrackers.get(con);
        if (result == null) {
            result = new PowerTracker();
            this.powerTrackers.put(con, result);
        }
        return result;
    }

    private void distributeStorageToConduits() {
        if (this.maxEnergyStored <= 0L || this.energyStored <= 0L) {
            for (IPowerConduit con : this.network.getConduits()) {
                con.setEnergyStored(0);
            }
            return;
        }
        this.energyStored = this.energyStored < 0L ? 0L : (this.energyStored > this.maxEnergyStored ? this.maxEnergyStored : this.energyStored);
        float filledRatio = (float)this.energyStored / (float)this.maxEnergyStored;
        long energyLeft = this.energyStored;
        for (IPowerConduit con : this.network.getConduits()) {
            if (energyLeft > 0L) {
                int give = (int)Math.ceil((float)con.getMaxEnergyStored() * filledRatio);
                give = Math.min(give, con.getMaxEnergyStored());
                give = Math.min(give, (int)Math.min(Integer.MAX_VALUE, energyLeft));
                con.setEnergyStored(give);
                energyLeft -= (long)give;
                continue;
            }
            con.setEnergyStored(0);
        }
    }

    boolean isActive() {
        return this.energyStored > 0L;
    }

    private void updateNetworkStorage() {
        this.maxEnergyStored = 0L;
        this.energyStored = 0L;
        for (IPowerConduit con : this.network.getConduits()) {
            this.maxEnergyStored += (long)con.getMaxEnergyStored();
            con.onTick();
            this.energyStored += (long)con.getEnergyStored();
        }
        this.energyStored = this.energyStored < 0L ? 0L : (this.energyStored > this.maxEnergyStored ? this.maxEnergyStored : this.energyStored);
    }

    public void receptorsChanged() {
        this.receptorsDirty = true;
    }

    private void checkReceptors() {
        if (!this.receptorsDirty) {
            return;
        }
        this.receptors.clear();
        this.storageReceptors.clear();
        for (PowerConduitNetwork.ReceptorEntry rec : this.network.getPowerReceptors()) {
            IPowerInterface powerInterface = rec.getPowerInterface();
            if (powerInterface != null) {
                if (powerInterface.getProvider() instanceof IPowerStorage) {
                    this.storageReceptors.add(rec);
                    continue;
                }
                this.receptors.add(rec);
                continue;
            }
            rec.emmiter.setConnectionsDirty();
        }
        this.receptorIterator = this.receptors.listIterator();
        this.receptorsDirty = false;
    }

    void onNetworkDestroyed() {
    }

    private int minAbs(int amount, int limit) {
        if (amount < 0) {
            return Math.max(amount, -limit);
        }
        return Math.min(amount, limit);
    }

    private static class CapBankSupplyEntry {
        @Nonnull
        final IPowerStorage capBank;
        final int canExtract;
        final int canFill;
        int toBalance;
        @Nonnull
        final IPowerConduit emmiter;
        @Nonnull
        final EnumFacing direction;

        private CapBankSupplyEntry(@Nonnull IPowerStorage capBank, int available, int canFill, @Nonnull IPowerConduit emmiter, @Nonnull EnumFacing direction) {
            this.capBank = capBank;
            this.canExtract = available;
            this.canFill = canFill;
            this.emmiter = emmiter;
            this.direction = direction;
        }

        void calcToBalance(double targetRatio) {
            if (this.capBank.isCreative()) {
                this.toBalance = 0;
                return;
            }
            long targetAmount = (long)Math.floor((double)this.capBank.getMaxEnergyStoredL() * targetRatio);
            long b = targetAmount - this.capBank.getEnergyStoredL();
            this.toBalance = b < 0L ? -this.canExtract : this.canFill;
        }
    }

    private class CapBankSupply {
        int canExtract;
        int canFill;
        Set<IPowerStorage> capBanks = new HashSet<IPowerStorage>();
        double filledRatio;
        long stored = 0L;
        long maxCap = 0L;
        List<CapBankSupplyEntry> enteries = new ArrayList<CapBankSupplyEntry>();

        CapBankSupply() {
        }

        void init() {
            this.capBanks.clear();
            this.enteries.clear();
            this.canExtract = 0;
            this.canFill = 0;
            this.stored = 0L;
            this.maxCap = 0L;
            double toBalance = 0.0;
            double maxToBalance = 0.0;
            for (PowerConduitNetwork.ReceptorEntry rec : NetworkPowerManager.this.storageReceptors) {
                IPowerInterface powerInterface = rec.getPowerInterface();
                if (powerInterface == null) continue;
                IPowerStorage cb = (IPowerStorage)powerInterface.getProvider();
                boolean processed = this.capBanks.contains(cb.getController());
                if (!processed) {
                    this.stored += cb.getEnergyStoredL();
                    this.maxCap += cb.getMaxEnergyStoredL();
                    this.capBanks.add(cb.getController());
                }
                if (rec.emmiter.getConnectionMode(rec.direction) == ConnectionMode.IN_OUT) {
                    toBalance += (double)cb.getEnergyStoredL();
                    maxToBalance += (double)cb.getMaxEnergyStoredL();
                }
                long canGet = 0L;
                long canFillLocal = 0L;
                if (!cb.isNetworkControlledIo(rec.direction.func_176734_d())) continue;
                if (cb.isOutputEnabled(rec.direction.func_176734_d())) {
                    canGet = Math.min(cb.getEnergyStoredL(), (long)cb.getMaxOutput());
                    canGet = Math.min(canGet, (long)rec.emmiter.getMaxEnergyRecieved(rec.direction));
                    this.canExtract = (int)((long)this.canExtract + canGet);
                }
                if (cb.isInputEnabled(rec.direction.func_176734_d())) {
                    canFillLocal = Math.min(cb.getMaxEnergyStoredL() - cb.getEnergyStoredL(), (long)cb.getMaxInput());
                    canFillLocal = Math.min(canFillLocal, (long)rec.emmiter.getMaxEnergyExtracted(rec.direction));
                    this.canFill = (int)((long)this.canFill + canFillLocal);
                }
                this.enteries.add(new CapBankSupplyEntry(cb, (int)canGet, (int)canFillLocal, rec.emmiter, rec.direction));
            }
            this.filledRatio = 0.0;
            if (maxToBalance > 0.0) {
                this.filledRatio = toBalance / maxToBalance;
            }
        }

        void balance() {
            if (this.enteries.size() < 2) {
                return;
            }
            this.init();
            int canRemove = 0;
            int canAdd = 0;
            for (CapBankSupplyEntry entry : this.enteries) {
                if (entry.emmiter.getConnectionMode(entry.direction) != ConnectionMode.IN_OUT) continue;
                entry.calcToBalance(this.filledRatio);
                if (entry.toBalance < 0) {
                    canRemove += -entry.toBalance;
                    continue;
                }
                canAdd += entry.toBalance;
            }
            int toalTransferAmount = Math.min(canAdd, canRemove);
            for (int i = 0; i < this.enteries.size() && toalTransferAmount > 0; ++i) {
                CapBankSupplyEntry from = this.enteries.get(i);
                if (from.emmiter.getConnectionMode(from.direction) != ConnectionMode.IN_OUT) continue;
                int amount = from.toBalance;
                amount = NetworkPowerManager.this.minAbs(amount, toalTransferAmount);
                from.capBank.addEnergy(amount);
                toalTransferAmount -= Math.abs(amount);
                int toTranfser = Math.abs(amount);
                for (int j = i + 1; j < this.enteries.size() && toTranfser > 0; ++j) {
                    CapBankSupplyEntry to = this.enteries.get(j);
                    if (Math.signum(amount) == Math.signum(to.toBalance)) continue;
                    int toAmount = Math.min(toTranfser, Math.abs(to.toBalance));
                    to.capBank.addEnergy(toAmount * (int)Math.signum(to.toBalance));
                    toTranfser -= toAmount;
                }
            }
        }

        void remove(long amount) {
            if (this.canExtract <= 0 || amount <= 0L) {
                return;
            }
            double ratio = (double)amount / (double)this.canExtract;
            for (CapBankSupplyEntry entry : this.enteries) {
                long use = (int)Math.ceil(ratio * (double)entry.canExtract);
                use = Math.min(use, amount);
                use = Math.min(use, (long)entry.canExtract);
                entry.capBank.addEnergy((int)(-use));
                NetworkPowerManager.this.trackerRecieve(entry.emmiter, (int)use, true);
                if ((amount -= use) != 0L) continue;
                return;
            }
        }

        long add(long amount) {
            if (this.canFill <= 0 || amount <= 0L) {
                return amount;
            }
            double ratio = (double)amount / (double)this.canFill;
            for (CapBankSupplyEntry entry : this.enteries) {
                long add = (int)Math.ceil(ratio * (double)entry.canFill);
                add = Math.min(add, (long)entry.canFill);
                add = Math.min(add, amount);
                add -= (long)entry.capBank.addEnergy((int)add);
                NetworkPowerManager.this.trackerSend(entry.emmiter, (int)add, true);
                if ((amount -= add) != 0L) continue;
                return amount;
            }
            return amount;
        }
    }
}

