/*
 * Decompiled with CFR 0.152.
 */
package com.timwoodcreates.roost.render;

import com.google.common.collect.ImmutableList;
import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import com.timwoodcreates.roost.data.DataChicken;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ModelItemChicken
implements IModel {
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakedModelItemChicken(state, format, bakedTextureGetter);
    }

    public static Collection<ResourceLocation> getItemTextures() {
        List<ResourceLocation> textures = ChickensRegistry.getItems().stream().map(item -> new ResourceLocation("roost", "items/chicken/" + item.getRegistryName().func_110623_a())).collect(Collectors.toList());
        textures.add(new ResourceLocation("roost", "items/chicken/vanilla"));
        return textures;
    }

    @SubscribeEvent
    public static void preStitch(TextureStitchEvent.Pre event) {
        for (ResourceLocation itemTexture : ModelItemChicken.getItemTextures()) {
            event.getMap().func_174942_a(itemTexture);
        }
    }

    public static class ModelItemChickenLoader
    implements ICustomModelLoader {
        public static ModelItemChickenLoader INSTANCE = new ModelItemChickenLoader();

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("roost") && modelLocation.func_110623_a().equals("models/item/chicken");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            return new ModelItemChicken();
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }

    public static class BakedModelItemChicken
    implements IBakedModel {
        public Map<String, IBakedModel> models = new HashMap<String, IBakedModel>();
        public ChickenItemOverrideList overrides = new ChickenItemOverrideList();

        public BakedModelItemChicken(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            try {
                IModel model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("roost:item/chicken/vanilla"));
                for (ChickensRegistryItem item : ChickensRegistry.getItems()) {
                    ResourceLocation name = item.getRegistryName();
                    ResourceLocation texLoc = new ResourceLocation("roost", "items/chicken/" + name.func_110623_a());
                    IBakedModel baked = model.bake(state, format, loc -> (TextureAtlasSprite)bakedTextureGetter.apply(texLoc));
                    this.models.put(name.toString(), baked);
                }
                IBakedModel baked = model.bake(state, format, bakedTextureGetter);
                this.models.put("minecraft:vanilla", baked);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        public class ChickenItemOverrideList
        extends ItemOverrideList {
            public ChickenItemOverrideList() {
                super((List)ImmutableList.of());
            }

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                String name;
                IBakedModel model;
                DataChicken chickenData = DataChicken.getDataFromStack(stack);
                if (chickenData != null && (model = (IBakedModel)BakedModelItemChicken.this.models.getOrDefault(name = chickenData.getChickenType(), null)) != null) {
                    return model;
                }
                return BakedModelItemChicken.this;
            }
        }
    }
}

