/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.discordintegration;

import ca.teamdman.discordintegration.Config;
import club.minnced.discord.rpc.DiscordEventHandlers;
import club.minnced.discord.rpc.DiscordRPC;
import club.minnced.discord.rpc.DiscordRichPresence;
import java.lang.reflect.Field;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ProgressManager;

public class RichPresence {
    private static final DiscordRichPresence presence = new DiscordRichPresence();
    private static final DiscordRPC rpc = DiscordRPC.INSTANCE;
    private static State state = State.DISABLED;

    public static void enable() {
        System.out.println("Creating Discord Rich Presence");
        String applicationId = Config.client.appid;
        DiscordEventHandlers handlers = new DiscordEventHandlers();
        handlers.ready = user -> System.out.println("Ready!");
        rpc.Discord_Initialize(applicationId, handlers, true, null);
        RichPresence.presence.startTimestamp = System.currentTimeMillis() / 1000L;
        RichPresence.presence.largeImageKey = Config.client.largeImageKey;
        RichPresence.presence.smallImageKey = Config.client.smallImageKey;
        RichPresence.presence.smallImageText = Config.client.smallImageText;
        rpc.Discord_UpdatePresence(presence);
        state = State.ENABLED;
        System.out.println("Discord Rich Presence thread started");
    }

    public static void setState(State state) {
        if (state == State.DISABLED) {
            return;
        }
        RichPresence.state = state;
    }

    public static void update(Consumer<DiscordRichPresence> consumer) {
        if (state == State.DISABLED) {
            return;
        }
        try {
            consumer.accept(presence);
        }
        catch (Exception exception) {
            // empty catch block
        }
        rpc.Discord_UpdatePresence(presence);
    }

    public static void disable() {
        rpc.Discord_ClearPresence();
        rpc.Discord_Shutdown();
        state = State.DISABLED;
    }

    static {
        ProgressManager.ProgressBar barbar = null;
        try {
            Field f = Loader.class.getDeclaredField("progressBar");
            f.setAccessible(true);
            barbar = (ProgressManager.ProgressBar)f.get(Loader.instance());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        ProgressManager.ProgressBar bar = barbar;
        final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        executor.scheduleAtFixedRate(() -> {
            if (state == State.LOADING && bar != null) {
                RichPresence.update(presence -> {
                    presence.details = "Launching [" + bar.getStep() + "/" + bar.getSteps() + "]";
                    presence.state = bar.getMessage();
                });
            }
            if (state != State.DISABLED) {
                rpc.Discord_RunCallbacks();
            }
        }, 0L, 2L, TimeUnit.SECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread("Discord Rich Presence Shutdown"){

            @Override
            public void run() {
                executor.shutdown();
            }
        });
    }

    public static enum State {
        DISABLED,
        ENABLED,
        LOADING;

    }
}

