/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.discordintegration;

import ca.teamdman.discordintegration.RichPresence;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

@Mod.EventBusSubscriber(modid="discord")
public class PresenceEventHandler {
    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        RichPresence.setState(RichPresence.State.ENABLED);
        RichPresence.update(presence -> {
            presence.details = "In Game";
            presence.state = PresenceEventHandler.localizeDimension(event.player.func_130014_f_().field_73011_w.func_186058_p().func_186065_b());
        });
    }

    private static String localizeDimension(String dim) {
        return Arrays.stream(dim.replaceAll("_", " ").split("\\s+")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (PresenceEventHandler.isEntityPlayer(event.getEntity())) {
            RichPresence.setState(RichPresence.State.ENABLED);
            RichPresence.update(presence -> {
                presence.details = "Spawning";
                presence.state = PresenceEventHandler.localizeDimension(event.getEntity().func_130014_f_().field_73011_w.func_186058_p().func_186065_b());
            });
        }
    }

    private static boolean isEntityPlayer(Entity entity) {
        return entity != null && entity.func_110124_au() != null && Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_110124_au() != null && entity.func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au());
    }

    @SubscribeEvent
    public static void onClientConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        RichPresence.setState(RichPresence.State.ENABLED);
        RichPresence.update(presence -> {
            presence.details = "In Game";
        });
    }

    @SubscribeEvent
    public static void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        RichPresence.update(presence -> {
            presence.details = "Main Menu";
            presence.state = Loader.instance().getActiveModList().size() + " mods loaded";
        });
    }

    @SubscribeEvent
    public static void onJoinWorld(EntityJoinWorldEvent event) {
        if (PresenceEventHandler.isEntityPlayer(event.getEntity())) {
            RichPresence.setState(RichPresence.State.ENABLED);
            RichPresence.update(presence -> {
                presence.details = "In Game";
                presence.state = PresenceEventHandler.getWorldName(event.getWorld());
            });
        }
    }

    private static String getWorldName(World world) {
        if (world != null && world.field_73011_w != null && world.field_73011_w.func_186058_p() != null && world.field_73011_w.func_186058_p().func_186065_b() != null) {
            return PresenceEventHandler.localizeDimension(world.field_73011_w.func_186058_p().func_186065_b());
        }
        return "";
    }

    @SubscribeEvent
    public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (PresenceEventHandler.isEntityPlayer((Entity)event.player)) {
            RichPresence.update(presence -> {
                presence.details = "In Game";
                presence.state = PresenceEventHandler.getWorldName(event.player.field_70170_p);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (PresenceEventHandler.isEntityPlayer((Entity)event.player)) {
            RichPresence.update(presence -> {
                presence.details = "In Game";
                presence.largeImageText = "Respawning";
                presence.state = PresenceEventHandler.getWorldName(event.player.field_70170_p);
            });
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (PresenceEventHandler.isEntityPlayer((Entity)event.getEntityPlayer()) && event.getItemStack() != null && !event.getItemStack().func_190926_b() && event.getItemStack().func_82833_r() != null) {
            RichPresence.update(presence -> {
                presence.largeImageText = "Researching " + event.getItemStack().func_82833_r();
            });
        }
    }

    @SubscribeEvent
    public static void onSleep(PlayerSleepInBedEvent event) {
        if (PresenceEventHandler.isEntityPlayer(event.getEntity()) && event.getResultStatus() == EntityPlayer.SleepResult.OK) {
            RichPresence.update(presence -> {
                presence.largeImageText = "Sleeping";
            });
        }
    }

    @SubscribeEvent
    public static void onHoe(UseHoeEvent event) {
        if (PresenceEventHandler.isEntityPlayer(event.getEntity())) {
            RichPresence.update(presence -> {
                presence.largeImageText = "Farming";
            });
        }
    }

    @SubscribeEvent
    public static void onItemUse(PlayerEvent.ItemPickupEvent event) {
        if (PresenceEventHandler.isEntityPlayer((Entity)event.player) && event.getStack() != null && !event.getStack().func_190926_b() && event.getStack().func_82833_r() != null) {
            RichPresence.update(presence -> {
                presence.largeImageText = "Using " + event.getStack().func_82833_r();
            });
        }
    }

    @SubscribeEvent
    public static void onAttack(AttackEntityEvent event) {
        if (PresenceEventHandler.isEntityPlayer(event.getEntity()) && event.getTarget() != null && event.getTarget().func_70005_c_() != null) {
            RichPresence.update(presence -> {
                presence.largeImageText = "Attacking " + event.getTarget().func_70005_c_();
            });
        }
    }

    @SubscribeEvent
    public static void onHarvest(BlockEvent.BreakEvent event) {
        if (PresenceEventHandler.isEntityPlayer((Entity)event.getPlayer()) && event.getState() != null && event.getState().func_177230_c() != null && event.getState().func_177230_c().func_149732_F() != null) {
            RichPresence.update(presence -> {
                presence.largeImageText = "Mining " + event.getState().func_177230_c().func_149732_F();
            });
        }
    }

    @SubscribeEvent
    public static void onSmelt(PlayerEvent.ItemSmeltedEvent event) {
        if (PresenceEventHandler.isEntityPlayer((Entity)event.player) && event.smelting != null && event.smelting.func_82833_r() != null) {
            RichPresence.update(presence -> {
                presence.largeImageText = "Smelting " + event.smelting.func_82833_r();
            });
        }
    }

    @SubscribeEvent
    public static void onCraft(PlayerEvent.ItemCraftedEvent event) {
        if (PresenceEventHandler.isEntityPlayer((Entity)event.player) && event.crafting != null && event.crafting.func_82833_r() != null) {
            RichPresence.update(presence -> {
                presence.largeImageText = "Crafting " + event.crafting.func_82833_r();
            });
        }
    }

    @SubscribeEvent
    public static void onPickup(PlayerEvent.ItemPickupEvent event) {
        if (PresenceEventHandler.isEntityPlayer((Entity)event.player) && event.getStack() != null && event.getStack().func_82833_r() != null) {
            RichPresence.update(presence -> {
                presence.largeImageText = "Obtaining " + event.getStack().func_82833_r();
            });
        }
    }

    @SubscribeEvent
    public static void onCraft(AnvilRepairEvent event) {
        if (PresenceEventHandler.isEntityPlayer(event.getEntity()) && event.getItemResult() != null && event.getItemResult().func_82833_r() != null) {
            RichPresence.update(presence -> {
                presence.largeImageText = "Anviling " + event.getItemResult().func_82833_r();
            });
        }
    }

    @SubscribeEvent
    public static void onToss(ItemTossEvent event) {
        if (PresenceEventHandler.isEntityPlayer(event.getEntity()) && event.getEntityItem() != null && event.getEntityItem().func_92059_d() != null && event.getEntityItem().func_145748_c_() != null) {
            RichPresence.update(presence -> {
                presence.largeImageText = "Tossing " + event.getEntityItem().func_92059_d().func_82833_r();
            });
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        if (PresenceEventHandler.isEntityPlayer(event.getEntity())) {
            RichPresence.update(presence -> {
                presence.largeImageText = "Taking Damage";
            });
        }
    }

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent event) {
        if (PresenceEventHandler.isEntityPlayer(event.getEntity()) && event.getWorld() != null && event.getPos() != null && event.getWorld().func_180495_p(event.getPos()) != null && event.getWorld().func_180495_p(event.getPos()).func_177230_c() != null && event.getWorld().func_180495_p(event.getPos()).func_177230_c().func_149732_F() != null) {
            RichPresence.update(presence -> {
                presence.largeImageText = "Interacting With " + event.getWorld().func_180495_p(event.getPos()).func_177230_c().func_149732_F();
            });
        }
    }

    @SubscribeEvent
    public static void onCraft(PlayerPickupXpEvent event) {
        if (PresenceEventHandler.isEntityPlayer(event.getEntity())) {
            RichPresence.update(presence -> {
                presence.largeImageText = "Gaining Experience";
            });
        }
    }
}

