/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.locationgps;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.BlockPosDim;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.core.BaseItem;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLocationGps
extends BaseItem
implements IHasRecipe,
IContent {
    private boolean enabled;

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150357_h) {
            this.deletePosition(player, pos, hand);
        } else {
            this.savePosition(player, pos, hand);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        BlockPosDim dim = ItemLocationGps.getPosition(stack);
        if (dim != null) {
            tooltip.add(dim.toString());
        }
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    private void deletePosition(EntityPlayer player, BlockPos pos, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        held.func_77982_d(null);
        UtilChat.sendStatusMessage(player, UtilChat.lang("item.location.saved") + "---");
    }

    private void savePosition(EntityPlayer player, BlockPos pos, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        player.func_184609_a(hand);
        UtilNBT.setItemStackBlockPos(held, pos);
        UtilNBT.setItemStackNBTVal(held, "dim", player.field_71093_bK);
        UtilChat.sendStatusMessage(player, UtilChat.lang("item.location.saved") + UtilChat.blockPosToString(pos));
    }

    public static BlockPosDim getPosition(ItemStack item) {
        BlockPos p = UtilNBT.getItemStackBlockPos(item);
        if (p == null) {
            return null;
        }
        BlockPosDim dim = new BlockPosDim(0, p, UtilNBT.getItemStackNBTVal(item, "dim"), "");
        return dim;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " o ", " s ", " r ", Character.valueOf('o'), "dyeLightBlue", Character.valueOf('s'), Items.field_151121_aF, Character.valueOf('r'), "stickWood");
    }

    @Override
    public String getContentName() {
        return "card_location";
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean(this.getContentName(), "cyclicmagic.items", true, " Set false to delete - requires restart  WARNING disabling this may cause other blocks to not function (wireless nodes)");
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName(), GuideCategory.ITEM);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }
}

