/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.gui.container;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineFluid;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.data.ITileStackWrapper;
import com.lothrazar.cyclicmagic.data.ITooltipButton;
import com.lothrazar.cyclicmagic.gui.button.ButtonTileEntityField;
import com.lothrazar.cyclicmagic.gui.button.ButtonTriggerWrapper;
import com.lothrazar.cyclicmagic.gui.button.GuiButtonTogglePreview;
import com.lothrazar.cyclicmagic.gui.button.GuiButtonToggleRedstone;
import com.lothrazar.cyclicmagic.gui.component.EnergyBar;
import com.lothrazar.cyclicmagic.gui.component.FluidBar;
import com.lothrazar.cyclicmagic.gui.component.GuiTextFieldInteger;
import com.lothrazar.cyclicmagic.gui.component.ProgressBar;
import com.lothrazar.cyclicmagic.gui.container.StackWrapper;
import com.lothrazar.cyclicmagic.net.PacketTileStackWrapped;
import com.lothrazar.cyclicmagic.util.Const;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GuiBaseContainer
extends GuiContainer {
    public static final int FONTCOLOR = 0x404040;
    static final int stackWrapperColor = -1130706433;
    public TileEntityBaseMachineInvo tile;
    private Const.ScreenSize screenSize = Const.ScreenSize.STANDARD;
    protected int fieldRedstoneBtn = -1;
    protected int fieldPreviewBtn = -1;
    protected ArrayList<GuiTextField> txtBoxes = new ArrayList();
    public ArrayList<ButtonTriggerWrapper> buttonWrappers = new ArrayList();
    public ProgressBar progressBar = null;
    public EnergyBar energyBar = null;
    public FluidBar fluidBar = null;
    protected GuiButtonToggleRedstone redstoneBtn = null;
    protected GuiButtonTogglePreview previewBtn;
    public List<ButtonTileEntityField> leftClickers = new ArrayList<ButtonTileEntityField>();

    public GuiBaseContainer(Container inventorySlotsIn, TileEntityBaseMachineInvo tile) {
        super(inventorySlotsIn);
        this.tile = tile;
    }

    public GuiBaseContainer(Container inventorySlotsIn) {
        super(inventorySlotsIn);
        this.tile = null;
    }

    protected void setScreenSize(Const.ScreenSize ss) {
        this.screenSize = ss;
        this.field_146999_f = this.screenSize.width();
        this.field_147000_g = this.screenSize.height();
    }

    protected Const.ScreenSize getScreenSize() {
        return this.screenSize;
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiTextField txt : this.txtBoxes) {
            if (txt == null) continue;
            txt.func_146178_a();
        }
    }

    protected GuiTextFieldInteger addTextbox(int fieldId, int x, int y, String text, int maxLen) {
        int width = 10 * maxLen;
        int height = 20;
        GuiTextFieldInteger txt = new GuiTextFieldInteger(fieldId, this.field_146289_q, x, y, width, height);
        txt.func_146203_f(maxLen);
        txt.func_146180_a(text);
        this.txtBoxes.add(txt);
        return txt;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof ButtonTileEntityField) {
            ButtonTileEntityField btn = (ButtonTileEntityField)button;
            for (GuiTextField t : this.txtBoxes) {
                GuiTextFieldInteger txt = (GuiTextFieldInteger)t;
                if (txt.getTileFieldId() != btn.getFieldId()) continue;
                int val = btn.getValue() + txt.getCurrent();
                txt.func_146180_a(val + "");
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_147003_i + 4;
        int y = this.field_147009_r + 4;
        if (this.fieldRedstoneBtn >= 0) {
            this.redstoneBtn = new GuiButtonToggleRedstone(131, x, y, this.tile.func_174877_v());
            this.func_189646_b(this.redstoneBtn);
            y += 4 + this.redstoneBtn.field_146120_f;
        }
        if (this.fieldPreviewBtn > 0) {
            this.previewBtn = new GuiButtonTogglePreview(132, x, y, this.tile.func_174877_v(), this.fieldPreviewBtn);
            this.func_189646_b(this.previewBtn);
        }
    }

    protected void drawFieldAt(int x, int y, int f) {
        String display = "" + this.tile.func_174887_a_(f);
        x = display.length() > 1 ? x - 3 : x;
        this.drawString(display, x, y);
    }

    @SideOnly(value=Side.CLIENT)
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.drawNameText();
        this.updateToggleButtonStates();
        for (GuiTextField txt : this.txtBoxes) {
            if (txt == null) continue;
            txt.func_146194_f();
        }
    }

    public void drawStringCenteredCheckLength(String display, int x, int y) {
        x = display.length() > 1 ? x - 3 : x;
        this.drawString(display, x, y);
    }

    public void drawNameText() {
        if (this.tile != null) {
            String s = UtilChat.lang(this.tile.func_70005_c_());
            this.drawString(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6);
        }
    }

    public void updateToggleButtonStates() {
        if (this.redstoneBtn != null) {
            this.redstoneBtn.setState(this.tile.func_174887_a_(this.fieldRedstoneBtn));
        }
        if (this.previewBtn != null) {
            if (this.tile.func_174887_a_(this.fieldPreviewBtn) == 1) {
                this.previewBtn.setStateOn();
            } else {
                this.previewBtn.setStateOff();
            }
        }
        this.updateDisabledButtonTriggers();
    }

    public void drawStringCentered(String s, int x, int y) {
        this.drawString(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, y);
    }

    public void drawString(String s, int x, int y) {
        this.field_146289_q.func_78276_b(UtilChat.lang(s), x, y, 0x404040);
    }

    public int getMiddleY() {
        int yMiddle = (this.field_146295_m - this.field_147000_g) / 2;
        return yMiddle;
    }

    public int getMiddleX() {
        int xMiddle = (this.field_146294_l - this.field_146999_f) / 2;
        return xMiddle;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getScreenSize().texture());
        int thisX = this.getMiddleX();
        int thisY = this.getMiddleY();
        boolean u = false;
        boolean v = false;
        Gui.func_146110_a((int)thisX, (int)thisY, (float)((float)u), (float)((float)v), (int)this.getScreenSize().width(), (int)this.getScreenSize().height(), (float)this.getScreenSize().width(), (float)this.getScreenSize().height());
        if (this.progressBar != null) {
            this.progressBar.draw();
        }
        if (this.energyBar != null && this.tile != null && this.tile.hasCapability(CapabilityEnergy.ENERGY, EnumFacing.UP)) {
            this.energyBar.draw((IEnergyStorage)this.tile.getCapability(CapabilityEnergy.ENERGY, EnumFacing.UP));
        }
    }

    private String getFuelAmtDisplay() {
        IEnergyStorage energy = (IEnergyStorage)this.tile.getCapability(CapabilityEnergy.ENERGY, EnumFacing.UP);
        return energy.getEnergyStored() + "/" + energy.getMaxEnergyStored();
    }

    private void renderEnergyTooltip(int mouseX, int mouseY) {
        String display = this.getFuelAmtDisplay();
        this.drawHoveringText(Arrays.asList(display), mouseX, mouseY, this.field_146289_q);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.drawStackWrappers(mouseX, mouseY);
        if (this.energyBar != null && this.energyBar.isMouseover(mouseX, mouseY)) {
            this.renderEnergyTooltip(mouseX, mouseY);
        }
        if (this.fluidBar != null && this.fluidBar.isMouseover(mouseX, mouseY)) {
            int has = ((TileEntityBaseMachineFluid)this.tile).getCurrentFluidStackAmount();
            this.drawHoveringText(Arrays.asList(has + "/" + this.fluidBar.getCapacity()), mouseX, mouseY, this.field_146289_q);
        }
        this.drawButtonTooltips(mouseX, mouseY);
    }

    private void drawButtonTooltips(int mouseX, int mouseY) {
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            if (!((GuiButton)this.field_146292_n.get(i)).func_146115_a() || !(this.field_146292_n.get(i) instanceof ITooltipButton)) continue;
            ITooltipButton btn = (ITooltipButton)this.field_146292_n.get(i);
            if (btn.getTooltips() == null) break;
            this.func_146283_a(btn.getTooltips(), mouseX, mouseY);
            break;
        }
    }

    private void drawStackWrappers(int mouseX, int mouseY) {
        if (this.tile instanceof ITileStackWrapper) {
            ITileStackWrapper te = (ITileStackWrapper)((Object)this.tile);
            for (int i = 0; i < te.getWrapperCount(); ++i) {
                StackWrapper wrap = te.getStackWrapper(i);
                if (!this.func_146978_c(wrap.getX() - this.field_147003_i, wrap.getY() - this.field_147009_r, 16, 16, mouseX, mouseY)) continue;
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                int j1 = wrap.getX() + 1;
                int k1 = wrap.getY() + 1;
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.func_73733_a(j1, k1, j1 + 16, k1 + 16, -1130706433, -1130706433);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
                if (wrap.isEmpty()) continue;
                this.func_146285_a(wrap.getStack(), mouseX, mouseY);
            }
        }
    }

    protected <T extends GuiButton> T func_189646_b(T buttonIn) {
        return (T)super.func_189646_b(buttonIn);
    }

    protected void registerButtonDisableTrigger(GuiButton buttonIn, ButtonTriggerWrapper.ButtonTriggerType trigger, int fieldId, int fv) {
        this.buttonWrappers.add(new ButtonTriggerWrapper(buttonIn, trigger, fieldId, fv));
    }

    private void updateDisabledButtonTriggers() {
        for (ButtonTriggerWrapper btnWrap : this.buttonWrappers) {
            int fieldValue = this.tile.func_174887_a_(btnWrap.fld);
            boolean isDisabled = true;
            switch (btnWrap.trig) {
                case EQUAL: {
                    isDisabled = fieldValue == btnWrap.triggerValue;
                    break;
                }
                case GREATER: {
                    isDisabled = fieldValue > btnWrap.triggerValue;
                    break;
                }
                case LESS: {
                    isDisabled = fieldValue < btnWrap.triggerValue;
                    break;
                }
                case NOTEQUAL: {
                    isDisabled = fieldValue != btnWrap.triggerValue;
                }
            }
            btnWrap.btn.field_146124_l = !isDisabled;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int btn) throws IOException {
        super.func_73864_a(mouseX, mouseY, btn);
        for (ButtonTileEntityField bf : this.leftClickers) {
            if (!bf.func_146115_a() || btn != 1) continue;
            bf.setValue(-1);
            bf.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY);
            bf.setValue(1);
            UtilSound.playSound(ModCyclic.proxy.getClientPlayer(), SoundEvents.field_187909_gi, 0.05f);
        }
        if (this.tile instanceof ITileStackWrapper) {
            this.mouseClickedWrapper((ITileStackWrapper)((Object)this.tile), mouseX, mouseY);
        }
        if (this.txtBoxes != null) {
            this.mouseClickedTextboxes(mouseX, mouseY, btn);
        }
    }

    private void mouseClickedTextboxes(int mouseX, int mouseY, int btn) {
        for (GuiTextField txt : this.txtBoxes) {
            txt.func_146192_a(mouseX, mouseY, btn);
            if (btn != 0) continue;
            boolean flag = mouseX >= this.field_147003_i + txt.field_146209_f && mouseX < this.field_147003_i + txt.field_146209_f + txt.field_146218_h && mouseY >= this.field_147009_r + txt.field_146210_g && mouseY < this.field_147009_r + txt.field_146210_g + txt.field_146219_i;
            txt.func_146195_b(flag);
        }
    }

    protected void mouseClickedWrapper(ITileStackWrapper te, int mouseX, int mouseY) {
        ItemStack stackInMouse = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        for (int i = 0; i < te.getWrapperCount(); ++i) {
            StackWrapper wrap = te.getStackWrapper(i);
            if (!this.func_146978_c(wrap.getX() - this.field_147003_i, wrap.getY() - this.field_147009_r, 16, 16, mouseX, mouseY)) continue;
            if (stackInMouse.func_190926_b() && wrap.isEmpty()) break;
            if (stackInMouse.func_190926_b()) {
                wrap.setStack(ItemStack.field_190927_a);
            } else {
                wrap.setStack(stackInMouse.func_77946_l());
                wrap.setCount(1);
            }
            ModCyclic.network.sendToServer((IMessage)new PacketTileStackWrapped(i, wrap, this.tile.func_174877_v()));
            return;
        }
    }

    public void renderStackWrappers(ITileStackWrapper te) {
        this.renderStackWrappers(te, true);
    }

    public void renderStackWrappers(ITileStackWrapper te, boolean background) {
        StackWrapper wrap;
        int i;
        if (background) {
            this.field_146297_k.func_110434_K().func_110577_a(Const.Res.SLOT);
            for (i = 0; i < te.getWrapperCount(); ++i) {
                wrap = te.getStackWrapper(i);
                Gui.func_146110_a((int)wrap.getX(), (int)wrap.getY(), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
            }
        }
        for (i = 0; i < te.getWrapperCount(); ++i) {
            wrap = te.getStackWrapper(i);
            if (wrap.isEmpty()) continue;
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            this.field_146297_k.func_175599_af().func_180450_b(wrap.getStack(), wrap.getX() + 1, wrap.getY() + 1);
            GlStateManager.func_179121_F();
        }
    }

    public void insertButton(GuiButton buttonIn) {
        super.func_189646_b(buttonIn);
    }
}

