/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.gui.component;

import com.lothrazar.cyclicmagic.gui.container.GuiBaseContainer;
import com.lothrazar.cyclicmagic.util.Const;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.fluids.FluidStack;

public class FluidBar {
    private GuiBaseContainer parent;
    private int x;
    private int y;
    private int capacity;
    private int width = 18;
    private int height = 62;

    public FluidBar(GuiBaseContainer p, int x, int y) {
        this.parent = p;
        this.setX(x);
        this.setY(y);
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void draw(FluidStack fluid) {
        boolean u = false;
        boolean v = false;
        int x = this.parent.getGuiLeft() + this.getX();
        int y = this.parent.getGuiTop() + this.getY();
        this.parent.field_146297_k.func_110434_K().func_110577_a(Const.Res.FLUID_BACKGROUND);
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (float)this.width, (float)this.height);
        if (fluid == null || this.getCapacity() == 0 || fluid.amount == 0) {
            return;
        }
        float capacity = this.getCapacity();
        float amount = fluid.amount;
        float scale = amount / capacity;
        int fluidAmount = (int)(scale * (float)this.height);
        this.parent.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getStill(fluid).toString());
        this.drawFluid(x + 1, y + this.height - fluidAmount + 1, icon, 16, fluidAmount - 2);
    }

    private void drawFluid(int x, int y, TextureAtlasSprite icon, int width, int height) {
        int size = width;
        int drawHeight = 0;
        int drawWidth = 0;
        for (int i = 0; i < width; i += size) {
            for (int j = 0; j < height; j += size) {
                drawWidth = Math.min(width - i, size);
                drawHeight = Math.min(height - j, size);
                this.parent.func_175175_a(x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
    }

    public boolean isMouseover(int mouseX, int mouseY) {
        return this.parent.getGuiLeft() + this.getX() < mouseX && mouseX < this.parent.getGuiLeft() + this.getX() + this.width && this.parent.getGuiTop() + this.getY() < mouseY && mouseY < this.parent.getGuiTop() + this.getY() + this.height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }
}

