/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.sound;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.block.core.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.block.password.IPlayerClaimed;
import com.lothrazar.cyclicmagic.block.sound.TileEntitySoundPlayer;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class BlockSoundPlayer
extends BlockBaseHasTile
implements IHasRecipe,
IContent {
    public static boolean playToEverybody = true;
    private boolean enabled;

    public BlockSoundPlayer() {
        super(Material.field_151576_e);
        super.setGuiId(42);
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntitySoundPlayer();
    }

    @Override
    public String getContentName() {
        return "sound_player";
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean(this.getContentName(), "cyclicmagic.content", true, " Set false to delete - requires restart");
        playToEverybody = config.getBoolean(this.getContentName() + "_everybody", "modpacks", true, "If true, then this block plays sound to everybody just like a record player.  If false, it only plays for the player who most recently opened the block.  This is useful for servers if players are using this block to grief others, you can set it to false and only the block owner will hear it.  ");
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IPlayerClaimed) {
            ((IPlayerClaimed)te).toggleClaimedHash(player);
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void register() {
        BlockRegistry.registerBlock((Block)this, this.getContentName(), GuideCategory.BLOCK);
        BlockRegistry.registerTileEntity(TileEntitySoundPlayer.class, this.getContentName() + "_te");
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this), "sss", "sns", "sss", Character.valueOf('s'), Blocks.field_150323_B, Character.valueOf('n'), Blocks.field_150421_aI);
    }
}

