/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.screentarget;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.block.screentarget.EnumDisplayStyle;
import com.lothrazar.cyclicmagic.block.screentarget.EnumShowType;
import com.lothrazar.cyclicmagic.data.BlockPosDim;
import com.lothrazar.cyclicmagic.data.ITileTextbox;
import com.lothrazar.cyclicmagic.item.locationgps.ItemLocationGps;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityScreenTarget
extends TileEntityBaseMachineInvo
implements ITileTextbox,
ITickable {
    public static final int SLOT_TRANSFER = 0;
    private String text = "";
    private int red = 100;
    private int green = 100;
    private int blue = 100;
    private int style;
    private int showType;
    private int xp;
    private int yp;
    private int fontSize = 30;

    public TileEntityScreenTarget() {
        super(1);
    }

    BlockPosDim getTarget(int slot) {
        return ItemLocationGps.getPosition(this.func_70301_a(slot));
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemLocationGps;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String s) {
        this.text = s;
    }

    public int getColor() {
        return (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | (this.blue & 0xFF) << 0;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.text = tags.func_74779_i("text");
        this.red = tags.func_74762_e("red");
        this.green = tags.func_74762_e("green");
        this.blue = tags.func_74762_e("blue");
        this.style = tags.func_74762_e("style");
        this.showType = tags.func_74762_e("showtype");
        this.fontSize = tags.func_74762_e("font");
        this.xp = tags.func_74762_e("xp");
        this.yp = tags.func_74762_e("yp");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74778_a("text", this.text);
        tags.func_74768_a("red", this.red);
        tags.func_74768_a("green", this.green);
        tags.func_74768_a("blue", this.blue);
        tags.func_74768_a("style", this.style);
        tags.func_74768_a("showtype", this.showType);
        tags.func_74768_a("font", this.fontSize);
        tags.func_74768_a("xp", this.xp);
        tags.func_74768_a("yp", this.yp);
        return super.func_189515_b(tags);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case BLUE: {
                return this.blue;
            }
            case GREEN: {
                return this.green;
            }
            case RED: {
                return this.red;
            }
            case STYLE: {
                return this.style;
            }
            case SHOWTYPE: {
                return this.showType;
            }
            case FONT: {
                return this.fontSize;
            }
            case XPADDING: {
                return this.xp;
            }
            case YPADDING: {
                return this.yp;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case BLUE: {
                this.blue = value;
                break;
            }
            case GREEN: {
                this.green = value;
                break;
            }
            case RED: {
                this.red = value;
                break;
            }
            case STYLE: {
                this.style = value % EnumDisplayStyle.values().length;
                break;
            }
            case SHOWTYPE: {
                this.showType = value % EnumShowType.values().length;
                break;
            }
            case FONT: {
                this.fontSize = value;
                break;
            }
            case XPADDING: {
                this.xp = value;
                break;
            }
            case YPADDING: {
                this.yp = value;
            }
        }
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L != 0L) {
            return;
        }
        TileEntity te = this.getTargetTile();
        if (te == null) {
            this.text = "";
            return;
        }
        this.updateText(te);
    }

    private void updateText(TileEntity te) {
        switch (this.showType()) {
            case ENERGY: {
                this.text = this.getEnergyString(te);
                break;
            }
            case FLUID: {
                this.text = this.getFluidStr(te);
                break;
            }
            case ITEM: {
                this.text = this.getItemStr(te);
            }
        }
    }

    private TileEntity getTargetTile() {
        BlockPosDim target = this.getTarget(0);
        if (target == null || target.getDimension() != this.field_145850_b.field_73011_w.getDimension()) {
            return null;
        }
        return this.field_145850_b.func_175625_s(target.toBlockPos());
    }

    private String getItemStr(TileEntity te) {
        String itemStr;
        if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
            IItemHandler itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            int max = itemHandler.getSlots();
            int empty = 0;
            for (int i = 0; i < max; ++i) {
                if (!itemHandler.getStackInSlot(i).func_190926_b()) continue;
                ++empty;
            }
            itemStr = this.formatQuantity(max - empty, max);
        } else {
            itemStr = "--";
        }
        return itemStr;
    }

    private String getFluidStr(TileEntity te) {
        String fluidStr = "";
        if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)) {
            IFluidHandler energy = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
            for (IFluidTankProperties f : energy.getTankProperties()) {
                if (f == null || f.getContents() == null) continue;
                fluidStr = fluidStr + this.formatQuantity(f.getContents().amount, f.getCapacity());
                break;
            }
        } else {
            fluidStr = "--";
        }
        return fluidStr;
    }

    private String getEnergyString(TileEntity te) {
        String energyStr;
        if (te.hasCapability(CapabilityEnergy.ENERGY, EnumFacing.UP)) {
            IEnergyStorage energy = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, EnumFacing.UP);
            energyStr = this.formatQuantity(energy.getEnergyStored(), energy.getMaxEnergyStored());
        } else {
            energyStr = "--";
        }
        return energyStr;
    }

    public EnumShowType showType() {
        return EnumShowType.values()[this.showType];
    }

    public EnumDisplayStyle displayStyle() {
        return EnumDisplayStyle.values()[this.style];
    }

    private String formatQuantity(float current, float max) {
        if (this.style == EnumDisplayStyle.PERCENT.ordinal()) {
            float pct = current / max * 100.0f;
            return String.format("%.2f", Float.valueOf(pct)) + "%";
        }
        String qty = (int)current + "";
        if (this.style == EnumDisplayStyle.MAX.ordinal()) {
            qty = qty + "/" + (int)max;
        }
        return qty;
    }

    public float getFontSize() {
        return (float)this.fontSize / 1000.0f;
    }

    public float getXOffset() {
        return (float)this.xp / 100.0f;
    }

    public float getYOffset() {
        return (float)this.yp / -100.0f;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public static enum Fields {
        RED,
        GREEN,
        BLUE,
        SHOWTYPE,
        STYLE,
        FONT,
        XPADDING,
        YPADDING;

    }
}

