/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.api;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;

public class Emoji
implements Predicate<String> {
    public static final ResourceLocation loading_texture = new ResourceLocation("emojiful", "textures/26a0.png");
    public static final ResourceLocation noSignal_texture = new ResourceLocation("emojiful", "textures/26d4.png");
    public static final ResourceLocation error_texture = new ResourceLocation("emojiful", "textures/26d4.png");
    private static final AtomicInteger threadDownloadCounter = new AtomicInteger(0);
    public String name;
    public List<String> strings;
    public String location;
    public int version = 1;
    public boolean deleteOldTexture;
    public SimpleTexture img;
    public ResourceLocation resourceLocation = loading_texture;

    public void checkLoad() {
        if (this.img != null) {
            return;
        }
        this.img = new DownloadImageData(new File("emojiful/cache/" + this.name + "-" + this.version), "https://raw.githubusercontent.com/HrznStudio/Emojiful/master/" + this.location, loading_texture);
        this.resourceLocation = new ResourceLocation("emojiful", "texures/emoji/" + this.name + "-" + this.version);
        Minecraft.func_71410_x().field_71446_o.func_110579_a(this.resourceLocation, (ITextureObject)this.img);
    }

    public ResourceLocation getResourceLocationForBinding() {
        this.checkLoad();
        if (this.deleteOldTexture) {
            this.img.func_147631_c();
            this.deleteOldTexture = false;
        }
        return this.resourceLocation;
    }

    @Override
    public boolean test(String s) {
        for (String text : this.strings) {
            if (!s.equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    public class DownloadImageData
    extends SimpleTexture {
        private final File cacheFile;
        private final String imageUrl;
        private BufferedImage bufferedImage;
        private Thread imageThread;
        private boolean textureUploaded;

        public DownloadImageData(File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation) {
            super(textureResourceLocation);
            this.cacheFile = cacheFileIn;
            this.imageUrl = imageUrlIn;
        }

        private void checkTextureUploaded() {
            if (!this.textureUploaded && this.bufferedImage != null) {
                if (this.field_110568_b != null) {
                    this.func_147631_c();
                }
                TextureUtil.func_110987_a((int)super.func_110552_b(), (BufferedImage)this.bufferedImage);
                this.textureUploaded = true;
            }
        }

        public int func_110552_b() {
            this.checkTextureUploaded();
            return super.func_110552_b();
        }

        public void setBufferedImage(BufferedImage bufferedImageIn) {
            this.bufferedImage = bufferedImageIn;
        }

        public void func_110551_a(IResourceManager resourceManager) throws IOException {
            if (this.bufferedImage == null && this.field_110568_b != null) {
                super.func_110551_a(resourceManager);
            }
            if (this.imageThread == null) {
                if (this.cacheFile != null && this.cacheFile.isFile()) {
                    try {
                        this.bufferedImage = ImageIO.read(this.cacheFile);
                    }
                    catch (IOException ioexception) {
                        this.loadTextureFromServer();
                    }
                } else {
                    this.loadTextureFromServer();
                }
            }
        }

        protected void loadTextureFromServer() {
            this.imageThread = new Thread("Emojiful Texture Downloader #" + threadDownloadCounter.incrementAndGet()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpURLConnection httpurlconnection = null;
                    try {
                        httpurlconnection = (HttpURLConnection)new URL(DownloadImageData.this.imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                        httpurlconnection.setDoInput(true);
                        httpurlconnection.setDoOutput(false);
                        httpurlconnection.connect();
                        if (httpurlconnection.getResponseCode() / 100 == 2) {
                            BufferedImage bufferedimage;
                            int contentLength = httpurlconnection.getContentLength();
                            if (DownloadImageData.this.cacheFile != null) {
                                FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)DownloadImageData.this.cacheFile);
                                bufferedimage = ImageIO.read(DownloadImageData.this.cacheFile);
                            } else {
                                bufferedimage = TextureUtil.func_177053_a((InputStream)httpurlconnection.getInputStream());
                            }
                            DownloadImageData.this.setBufferedImage(bufferedimage);
                        } else {
                            Emoji.this.resourceLocation = noSignal_texture;
                            Emoji.this.deleteOldTexture = true;
                        }
                    }
                    catch (Exception exception) {
                        Emoji.this.resourceLocation = error_texture;
                        Emoji.this.deleteOldTexture = true;
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                    }
                }
            };
            this.imageThread.setDaemon(true);
            this.imageThread.start();
        }
    }
}

