/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.gui;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.foodqueue.FixedHungerQueue;
import squeek.spiceoflife.foodtracker.foodqueue.FixedSizeQueue;
import squeek.spiceoflife.foodtracker.foodqueue.FixedTimeQueue;
import squeek.spiceoflife.gui.widget.WidgetButtonNextPage;
import squeek.spiceoflife.gui.widget.WidgetButtonSortDirection;
import squeek.spiceoflife.gui.widget.WidgetFoodEaten;
import squeek.spiceoflife.helpers.StringHelper;

@SideOnly(value=Side.CLIENT)
public class GuiScreenFoodJournal
extends GuiContainer {
    private static final ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    public static final DecimalFormat dfOne = new DecimalFormat("#.#");
    private int bookImageWidth = 192;
    private int bookImageHeight = 192;
    protected List<WidgetFoodEaten> foodEatenWidgets = new ArrayList<WidgetFoodEaten>();
    protected int pageNum = 0;
    protected static final int numPerPage = 5;
    protected int numPages;
    @Nonnull
    public ItemStack hoveredStack = ItemStack.field_190927_a;
    protected GuiButton buttonNextPage;
    protected GuiButton buttonPrevPage;
    protected WidgetButtonSortDirection buttonSortDirection;

    public GuiScreenFoodJournal() {
        super(Minecraft.func_71410_x().field_71439_g.field_71069_bz);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttonPrevPage = new WidgetButtonNextPage(1, (this.field_146294_l - this.bookImageWidth) / 2 + 38, 156, false);
        this.field_146292_n.add(this.buttonPrevPage);
        this.buttonNextPage = new WidgetButtonNextPage(2, (this.field_146294_l - this.bookImageWidth) / 2 + 120, 156, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonSortDirection = new WidgetButtonSortDirection(3, this.field_146294_l / 2 - 55, 18, false);
        this.field_146292_n.add(this.buttonSortDirection);
        this.foodEatenWidgets.clear();
        FoodHistory foodHistory = FoodHistory.get((EntityPlayer)this.field_146297_k.field_71439_g);
        if (!ModConfig.CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD || foodHistory.totalFoodsEatenAllTime >= ModConfig.FOOD_EATEN_THRESHOLD) {
            for (FoodEaten foodEaten : foodHistory.getHistory()) {
                this.foodEatenWidgets.add(new WidgetFoodEaten(foodEaten));
            }
        }
        this.numPages = (int)Math.max(1.0, Math.ceil((float)this.foodEatenWidgets.size() / 5.0f));
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.pageNum < this.numPages - 1;
        this.buttonPrevPage.field_146125_m = this.pageNum > 0;
    }

    public static String getTimeEatenString(FoodEaten foodEaten) {
        Minecraft mc = Minecraft.func_71410_x();
        long elapsedTime = foodEaten.elapsedTime(mc.field_71441_e.func_82737_E(), FoodHistory.get((EntityPlayer)mc.field_71439_g).ticksActive);
        double daysElapsed = (double)elapsedTime / 24000.0;
        String numDays = dfOne.format(daysElapsed);
        String singularOrPlural = numDays.equals("1") ? "spiceoflife.gui.x.day" : "spiceoflife.gui.x.days";
        String daysAgo = I18n.func_135052_a((String)singularOrPlural, (Object[])new Object[]{numDays});
        return I18n.func_135052_a((String)"spiceoflife.gui.time.elapsed.since.food.eaten", (Object[])new Object[]{daysAgo});
    }

    public static String getExpiresInString(FoodEaten foodEaten) {
        Minecraft mc = Minecraft.func_71410_x();
        FoodHistory foodHistory = FoodHistory.get((EntityPlayer)mc.field_71439_g);
        if (ModConfig.USE_HUNGER_QUEUE) {
            FixedHungerQueue queue = (FixedHungerQueue)foodHistory.getHistory();
            FixedHungerQueue slice = queue.sliceUntil(foodEaten);
            int hungerOverflow = queue.totalHunger() - queue.hunger();
            int hungerNeededIfThisWereFirst = foodEaten.foodValues.hunger - hungerOverflow;
            int spaceInQueue = queue.getMaxSize() - queue.hunger();
            int sliceHunger = slice.totalHunger();
            int hungerUntilExpire = Math.max(1, spaceInQueue + hungerNeededIfThisWereFirst + sliceHunger);
            return I18n.func_135052_a((String)"spiceoflife.gui.expires.in.hunger", (Object[])new Object[]{StringHelper.hungerHistoryLength(hungerUntilExpire)});
        }
        if (ModConfig.USE_TIME_QUEUE) {
            FixedTimeQueue queue = (FixedTimeQueue)foodHistory.getHistory();
            long elapsedTime = foodEaten.elapsedTime(mc.field_71441_e.func_82737_E(), foodHistory.ticksActive);
            long maxTime = queue.getMaxTime();
            long timeUntilExpire = maxTime - elapsedTime;
            double daysUntilExpire = (double)timeUntilExpire / 24000.0;
            String numDays = dfOne.format(daysUntilExpire);
            String singularOrPlural = numDays.equals("1") ? "spiceoflife.gui.x.day" : "spiceoflife.gui.x.days";
            String value = I18n.func_135052_a((String)singularOrPlural, (Object[])new Object[]{numDays});
            return I18n.func_135052_a((String)"spiceoflife.gui.expires.in.time", (Object[])new Object[]{value});
        }
        FixedSizeQueue queue = (FixedSizeQueue)foodHistory.getHistory();
        int spaceInQueue = queue.getMaxSize() - queue.size();
        int foodsUntilExpire = spaceInQueue + queue.indexOf(foodEaten) + 1;
        String singularOrPlural = foodsUntilExpire == 1 ? I18n.func_135052_a((String)"spiceoflife.tooltip.times.singular", (Object[])new Object[0]) : I18n.func_135052_a((String)"spiceoflife.tooltip.times.plural", (Object[])new Object[0]);
        return I18n.func_135052_a((String)"spiceoflife.gui.expires.in.food", (Object[])new Object[]{dfOne.format(foodsUntilExpire), singularOrPlural});
    }

    public static boolean isMouseInsideBox(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= x && mouseY >= y && mouseX < x + w && mouseY < y + h;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
        int x = (this.field_146294_l - this.bookImageWidth) / 2;
        int y = 2;
        this.func_73729_b(x, y, 0, 0, this.bookImageWidth, this.bookImageHeight);
        boolean sortedDescending = this.buttonSortDirection.sortDesc;
        int startIndex = Math.max(0, this.pageNum * 5);
        int endIndex = startIndex + 5;
        int totalNum = this.foodEatenWidgets.size();
        if (totalNum > 0) {
            int firstItemNum = sortedDescending ? totalNum - startIndex : startIndex + 1;
            int lastItemNum = sortedDescending ? Math.max(1, totalNum - endIndex + 1) : Math.min(totalNum, endIndex);
            String pageIndicator = I18n.func_135052_a((String)"spiceoflife.gui.items.on.page", (Object[])new Object[]{firstItemNum, lastItemNum, totalNum});
            this.field_146289_q.func_78276_b(pageIndicator, x + this.bookImageWidth - this.field_146289_q.func_78256_a(pageIndicator) - 44, y + 16, 0);
        }
        String numFoodsEatenAllTime = Integer.toString(FoodHistory.get((EntityPlayer)this.field_146297_k.field_71439_g).totalFoodsEatenAllTime);
        int allTimeW = this.field_146289_q.func_78256_a(numFoodsEatenAllTime);
        int allTimeX = this.field_146294_l / 2 - allTimeW / 2 - 5;
        int allTimeY = y + 158;
        this.field_146289_q.func_78276_b(numFoodsEatenAllTime, allTimeX, allTimeY, 0xA0A0A0);
        for (Object objButton : this.field_146292_n) {
            ((GuiButton)objButton).func_191745_a(this.field_146297_k, mouseX, mouseY, f);
        }
        if (!ModConfig.CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD || FoodHistory.get((EntityPlayer)this.field_146297_k.field_71439_g).totalFoodsEatenAllTime >= ModConfig.FOOD_EATEN_THRESHOLD) {
            if (!this.foodEatenWidgets.isEmpty()) {
                int localY;
                int localX;
                WidgetFoodEaten foodEatenWidget;
                int foodEatenIndex;
                GlStateManager.func_179094_E();
                RenderHelper.func_74520_c();
                for (foodEatenIndex = startIndex; foodEatenIndex < this.foodEatenWidgets.size() && foodEatenIndex < endIndex; ++foodEatenIndex) {
                    foodEatenWidget = this.foodEatenWidgets.get(foodEatenIndex);
                    localX = x + 36;
                    localY = y + 32 + (int)((float)((foodEatenIndex - startIndex) * this.field_146289_q.field_78288_b) * 2.5f);
                    foodEatenWidget.draw(localX, localY);
                    if (foodEatenWidget.foodEaten.itemStack == ItemStack.field_190927_a) continue;
                    this.drawItemStack(foodEatenWidget.foodEaten.itemStack, localX, localY);
                }
                GlStateManager.func_179121_F();
                this.hoveredStack = ItemStack.field_190927_a;
                for (foodEatenIndex = startIndex; foodEatenIndex < this.foodEatenWidgets.size() && foodEatenIndex < endIndex; ++foodEatenIndex) {
                    foodEatenWidget = this.foodEatenWidgets.get(foodEatenIndex);
                    localX = x + 36;
                    localY = y + 32 + (int)((float)((foodEatenIndex - startIndex) * this.field_146289_q.field_78288_b) * 2.5f);
                    if (GuiScreenFoodJournal.isMouseInsideBox(mouseX, mouseY, localX, localY, 16, 16)) {
                        this.hoveredStack = foodEatenWidget.foodEaten.itemStack;
                        if (this.hoveredStack == ItemStack.field_190927_a) continue;
                        this.func_146285_a(this.hoveredStack, mouseX, mouseY);
                        continue;
                    }
                    if (!GuiScreenFoodJournal.isMouseInsideBox(mouseX, mouseY, localX + 18, localY, foodEatenWidget.width(), 16)) continue;
                    ArrayList<String> toolTipStrings = new ArrayList<String>();
                    int foodIndex = sortedDescending ? Math.max(1, totalNum - foodEatenIndex) : foodEatenIndex + 1;
                    toolTipStrings.add(I18n.func_135052_a((String)"spiceoflife.gui.food.num", (Object[])new Object[]{foodIndex}));
                    toolTipStrings.add(TextFormatting.GRAY + GuiScreenFoodJournal.getTimeEatenString(foodEatenWidget.foodEaten));
                    List splitExpiresIn = this.field_146289_q.func_78271_c(TextFormatting.DARK_AQUA.toString() + TextFormatting.ITALIC + GuiScreenFoodJournal.getExpiresInString(foodEatenWidget.foodEaten), 150);
                    toolTipStrings.addAll(splitExpiresIn);
                    this.drawHoveringText(toolTipStrings, mouseX, mouseY, this.field_146289_q);
                }
            } else {
                this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"spiceoflife.gui.no.recent.food.eaten", (Object[])new Object[0]), x + 36, y + 16 + 16, 116, 0x404040);
            }
        } else {
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"spiceoflife.gui.no.food.history.yet", (Object[])new Object[0]), x + 36, y + 16 + 16, 116, 0x404040);
        }
        if (GuiScreenFoodJournal.isMouseInsideBox(mouseX, mouseY, allTimeX, allTimeY, allTimeW, this.field_146289_q.field_78288_b)) {
            this.drawHoveringText(Collections.singletonList(I18n.func_135052_a((String)"spiceoflife.gui.alltime.food.eaten", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
        }
        GlStateManager.func_179140_f();
    }

    protected void drawItemStack(@Nonnull ItemStack stack, int x, int y) {
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146124_l) {
            if (button.field_146127_k == 1) {
                --this.pageNum;
            } else if (button.field_146127_k == 2) {
                ++this.pageNum;
            } else if (button.field_146127_k == 3) {
                Collections.reverse(this.foodEatenWidgets);
                this.buttonSortDirection.sortDesc = !this.buttonSortDirection.sortDesc;
            }
            this.updateButtons();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
    }
}

