/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import xt9.deepmoblearning.common.config.Config;
import xt9.deepmoblearning.common.items.ItemLivingMatter;
import xt9.deepmoblearning.common.util.MathHelper;

public class ConsumeLivingMatterMessage
implements IMessage {
    private boolean consumeStack;

    public ConsumeLivingMatterMessage() {
    }

    public ConsumeLivingMatterMessage(boolean consumeStack) {
        this.consumeStack = consumeStack;
    }

    public void fromBytes(ByteBuf buf) {
        this.consumeStack = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.consumeStack);
    }

    public static class Handler
    implements IMessageHandler<ConsumeLivingMatterMessage, IMessage> {
        public IMessage onMessage(ConsumeLivingMatterMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack mainHand = player.func_184614_ca();
            ItemStack offHand = player.func_184592_cb();
            if (mainHand.func_77973_b() instanceof ItemLivingMatter) {
                player.func_71121_q().func_152344_a(() -> this.consumeMatter(mainHand, message.consumeStack, player));
            } else if (offHand.func_77973_b() instanceof ItemLivingMatter) {
                player.func_71121_q().func_152344_a(() -> this.consumeMatter(offHand, message.consumeStack, player));
            }
            return null;
        }

        private void consumeMatter(ItemStack matter, boolean consumeStack, EntityPlayerMP player) {
            ItemLivingMatter item = (ItemLivingMatter)matter.func_77973_b();
            int exp = MathHelper.ensureRange(Config.livingMatterEXP.get(item.getType()).getInt(), 1, 999);
            if (consumeStack) {
                int size = matter.func_190916_E();
                matter.func_190918_g(matter.func_190916_E());
                player.func_71023_q(exp * size);
            } else {
                matter.func_190918_g(1);
                player.func_71023_q(exp);
            }
        }
    }
}

