/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xt9.deepmoblearning.common.items.ItemBase;
import xt9.deepmoblearning.common.util.DataModel;
import xt9.deepmoblearning.common.util.DataModelExperience;
import xt9.deepmoblearning.common.util.KeyboardHelper;

public class ItemDataModel
extends ItemBase {
    private String mobKey;

    private ItemDataModel(String name, String mobKey) {
        super(name, 1);
        this.mobKey = mobKey;
    }

    public String getMobKey() {
        return this.mobKey;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        if (DataModel.hasExtraTooltip(stack)) {
            list.add(DataModel.getExtraTooltip(stack));
        }
        if (!KeyboardHelper.isHoldingShift()) {
            list.add(I18n.func_135052_a((String)"deepmoblearning.holdshift", (Object[])new Object[0]));
        } else {
            list.add(I18n.func_135052_a((String)"deepmoblearning.data_model.tier", (Object[])new Object[]{DataModel.getTierName(stack, false)}));
            int tier = DataModel.getTier(stack);
            if (tier != 4) {
                list.add(I18n.func_135052_a((String)"deepmoblearning.data_model.data.collected", (Object[])new Object[]{DataModel.getCurrentTierSimulationCountWithKills(stack), DataModel.getTierRoof(stack)}));
                list.add(I18n.func_135052_a((String)"deepmoblearning.data_model.data.killmultiplier", (Object[])new Object[]{DataModelExperience.getKillMultiplier(DataModel.getTier(stack))}));
            }
            list.add(I18n.func_135052_a((String)"deepmoblearning.data_model.rfcost", (Object[])new Object[]{DataModel.getSimulationTickCost(stack)}));
            list.add(I18n.func_135052_a((String)"deepmoblearning.data_model.type", (Object[])new Object[]{DataModel.getMatterTypeName(stack)}));
        }
    }

    public static class MOAndroid
    extends ItemDataModel {
        public MOAndroid() {
            super("data_model_mo_android", "mo_android");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class TinkerSlime
    extends ItemDataModel {
        public TinkerSlime() {
            super("data_model_tinker_slime", "tinkerslime");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class TwilightGlacier
    extends ItemDataModel {
        public TwilightGlacier() {
            super("data_model_twilight_glacier", "twilightglacier");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class TwilightDarkwood
    extends ItemDataModel {
        public TwilightDarkwood() {
            super("data_model_twilight_darkwood", "twilightdarkwood");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class TwilightSwamp
    extends ItemDataModel {
        public TwilightSwamp() {
            super("data_model_twilight_swamp", "twilightswamp");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class TwilightForest
    extends ItemDataModel {
        public TwilightForest() {
            super("data_model_twilight_forest", "twilightforest");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class TE
    extends ItemDataModel {
        public TE() {
            super("data_model_thermal_elemental", "thermalelemental");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class Zombie
    extends ItemDataModel {
        public Zombie() {
            super("data_model_zombie", "zombie");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class WitherSkeleton
    extends ItemDataModel {
        public WitherSkeleton() {
            super("data_model_wither_skeleton", "witherskeleton");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class Wither
    extends ItemDataModel {
        public Wither() {
            super("data_model_wither", "wither");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class Witch
    extends ItemDataModel {
        public Witch() {
            super("data_model_witch", "witch");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class Spider
    extends ItemDataModel {
        public Spider() {
            super("data_model_spider", "spider");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class Slime
    extends ItemDataModel {
        public Slime() {
            super("data_model_slime", "slime");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class Skeleton
    extends ItemDataModel {
        public Skeleton() {
            super("data_model_skeleton", "skeleton");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class Shulker
    extends ItemDataModel {
        public Shulker() {
            super("data_model_shulker", "shulker");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class Guardian
    extends ItemDataModel {
        public Guardian() {
            super("data_model_guardian", "guardian");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class Ghast
    extends ItemDataModel {
        public Ghast() {
            super("data_model_ghast", "ghast");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class Enderman
    extends ItemDataModel {
        public Enderman() {
            super("data_model_enderman", "enderman");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class Dragon
    extends ItemDataModel {
        public Dragon() {
            super("data_model_dragon", "dragon");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class Creeper
    extends ItemDataModel {
        public Creeper() {
            super("data_model_creeper", "creeper");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class Blaze
    extends ItemDataModel {
        public Blaze() {
            super("data_model_blaze", "blaze");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }
}

