/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;
import xt9.deepmoblearning.DeepMobLearning;
import xt9.deepmoblearning.common.capabilities.PlayerTrial;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class TrialOverlay
extends GuiScreen {
    private FontRenderer fontRender;
    private Minecraft minecraft;
    private long lastTick = 0L;
    private static String lastMessage = "";
    private static int ticksToRender = 0;
    private static int ticksToRenderGlitchNotification = 0;
    private static int ticksToRenderNextWaveMessage = 0;
    private static PlayerTrial clientCapability;
    private static final ResourceLocation texture;

    public TrialOverlay(Minecraft mc) {
        this.minecraft = mc;
        this.fontRender = mc.field_71466_p;
        this.field_146296_j = this.minecraft.func_175599_af();
        this.func_183500_a(89, 12);
    }

    public static void initPlayerCapability() {
        clientCapability = (PlayerTrial)DeepMobLearning.proxy.getClientPlayerTrialCapability();
    }

    public static void handleMessage(String type) {
        clientCapability = (PlayerTrial)DeepMobLearning.proxy.getClientPlayerTrialCapability();
        switch (type) {
            case "GlitchNotification": {
                ticksToRenderGlitchNotification = 80;
                break;
            }
            case "TrialAborted": {
                ticksToRender = 80;
                lastMessage = "Trial aborted due to unknown reasons";
                break;
            }
            case "TrialCompleted": {
                ticksToRender = 120;
                lastMessage = "Good job! Collect your reward from the keystone";
                break;
            }
            case "WaveNumber": {
                ticksToRender = 80;
                lastMessage = "Wave " + (clientCapability.getCurrentWave() + 1);
                break;
            }
            case "WaveCountdown": {
                ticksToRenderNextWaveMessage = 118;
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        this.doTickChecks();
        if (event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        if (!this.minecraft.field_71415_G) {
            return;
        }
        if (ticksToRender > 0) {
            this.renderMessage();
        }
        if (ticksToRenderGlitchNotification > 0) {
            this.renderGlitchNotification();
        }
        if (ticksToRenderNextWaveMessage > 0) {
            this.renderWaveCountdown();
        }
        if (clientCapability == null) {
            clientCapability = (PlayerTrial)DeepMobLearning.proxy.getClientPlayerTrialCapability();
        }
        if (!clientCapability.isTrialActive()) {
            return;
        }
        this.renderTrialScoreboard();
    }

    private void doTickChecks() {
        if (this.lastTick != this.minecraft.field_71441_e.func_82737_E()) {
            this.lastTick = this.minecraft.field_71441_e.func_82737_E();
            if (ticksToRender > 0) {
                --ticksToRender;
            }
            if (ticksToRenderNextWaveMessage > 0) {
                --ticksToRenderNextWaveMessage;
            }
            if (ticksToRenderGlitchNotification > 0) {
                --ticksToRenderGlitchNotification;
            }
        }
    }

    private void renderWaveCountdown() {
        float scale = 1.6f;
        int x = this.getScreenCenterX(scale) - this.getHalfLineWidth("Next wave in: 0", scale);
        if (ticksToRenderNextWaveMessage / 20 > 0) {
            this.renderScaledString(scale, x, 80, "Next wave in: " + ticksToRenderNextWaveMessage / 20);
        }
    }

    private void renderMessage() {
        float scale = lastMessage.length() < 8 ? 2.2f : 1.6f;
        int x = this.getScreenCenterX(scale) - this.getHalfLineWidth(lastMessage, scale);
        this.renderScaledString(scale, x, 80, lastMessage);
    }

    private void renderGlitchNotification() {
        float scale1 = 1.9f;
        float scale2 = 1.2f;
        String notif1 = "! Glitch Alert !";
        String notif2 = "Deal with it before it becomes a problem";
        int x1 = this.getScreenCenterX(scale1) - this.getHalfLineWidth(notif1, scale1);
        int x2 = this.getScreenCenterX(scale2) - this.getHalfLineWidth(notif2, scale2);
        int string1Width = this.fontRender.func_78256_a(notif1);
        this.minecraft.func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.getScreenCenterX() - string1Width - 22, 108, 0, 0, 17, 17);
        this.func_73729_b(this.getScreenCenterX() + string1Width + 4, 108, 0, 0, 17, 17);
        this.renderScaledStringWithColor(scale1, x1, 110, notif1, 13068507);
        this.renderScaledString(scale2, x2, 130, notif2);
    }

    private void renderTrialScoreboard() {
        int x = this.getRightCornerX() - 50;
        float scale = 1.3f;
        int scaledX = (int)((float)x / scale);
        int y = 145;
        this.drawItemStackWithCount(x - 21, y + 4, new ItemStack(Items.field_151113_aN));
        this.renderScaledStringWithColor(scale, scaledX, y + 2, "Wave", 3403740);
        this.func_73731_b(this.fontRender, clientCapability.getCurrentWave() + 1 + "/" + clientCapability.getLastWave(), x + 1, y + 16, 0xFFFFFF);
        ItemStack skull = new ItemStack(Items.field_151144_bL);
        skull.func_77964_b(0);
        this.drawItemStackWithCount(x - 21, y + 36, skull);
        this.renderScaledStringWithColor(scale, scaledX, y + 32, "Opponents", 3403740);
        int toKill = clientCapability.getWaveMobTotal() - clientCapability.getDefated();
        if (toKill == 0) {
            this.func_73731_b(this.fontRender, "Wave cleared", x + 1, y + 46, 0xFFFFFF);
        } else {
            this.func_73731_b(this.fontRender, toKill + " to go", x + 1, y + 46, 0xFFFFFF);
        }
    }

    private void renderScaledStringWithColor(float scale, int x, int y, String text, int color) {
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.func_73731_b(this.fontRender, text, x, (int)((float)y / scale), color);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void renderScaledString(float scale, int x, int y, String text) {
        this.renderScaledStringWithColor(scale, x, y, text, 0xFFFFFF);
    }

    private int getHalfLineWidth(String text, float glScale) {
        return (int)((float)(this.fontRender.func_78256_a(text) / 2) * glScale / glScale);
    }

    private int getScreenCenterX() {
        ScaledResolution scaledResolution = new ScaledResolution(this.minecraft);
        return scaledResolution.func_78326_a() / 2;
    }

    private int getScreenCenterX(float glScale) {
        ScaledResolution scaledResolution = new ScaledResolution(this.minecraft);
        return (int)((float)(scaledResolution.func_78326_a() / 2) / glScale);
    }

    private int getLeftCornerX() {
        return 5;
    }

    private int getRightCornerX() {
        ScaledResolution scaledResolution = new ScaledResolution(this.minecraft);
        return scaledResolution.func_78326_a() - this.field_146294_l - 5;
    }

    private void drawItemStackWithCount(int x, int y, ItemStack stack) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(this.fontRender, stack, x - 1, y - 1, "");
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
    }

    static {
        texture = new ResourceLocation("deepmoblearning", "textures/gui/trial_overlay_gui.png");
    }
}

