/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.client.gui;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import xt9.deepmoblearning.common.energy.DeepEnergyStorage;
import xt9.deepmoblearning.common.inventory.ContainerSimulationChamber;
import xt9.deepmoblearning.common.mobmetas.MobMetaData;
import xt9.deepmoblearning.common.tiles.TileEntitySimulationChamber;
import xt9.deepmoblearning.common.util.Animation;
import xt9.deepmoblearning.common.util.DataModel;
import xt9.deepmoblearning.common.util.MathHelper;

public class SimulationChamberGui
extends GuiContainer {
    private static final int WIDTH = 232;
    private static final int HEIGHT = 230;
    private HashMap<String, Animation> animationList;
    private ItemStack currentDataModel = ItemStack.field_190927_a;
    private TileEntitySimulationChamber tile;
    private DeepEnergyStorage energyStorage;
    private FontRenderer renderer;
    private World world;
    private static final ResourceLocation base = new ResourceLocation("deepmoblearning", "textures/gui/simulation_chamber_base.png");
    private static final ResourceLocation defaultGui = new ResourceLocation("deepmoblearning", "textures/gui/default_gui.png");

    public SimulationChamberGui(TileEntitySimulationChamber te, InventoryPlayer inventory, World world) {
        super((Container)new ContainerSimulationChamber(te, inventory, world));
        this.energyStorage = (DeepEnergyStorage)((Object)te.getCapability(CapabilityEnergy.ENERGY, null));
        this.renderer = Minecraft.func_71410_x().field_71466_p;
        this.animationList = new HashMap();
        this.world = world;
        this.tile = te;
        this.field_146999_f = 232;
        this.field_147000_g = 230;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int x = mouseX - this.field_147003_i;
        int y = mouseY - this.field_147009_r;
        NumberFormat f = NumberFormat.getNumberInstance(Locale.ENGLISH);
        ArrayList<String> tooltip = new ArrayList<String>();
        if (47 <= y && y < 135) {
            if (13 <= x && x < 22) {
                if (this.tile.hasDataModel()) {
                    if (DataModel.getTier(this.tile.getDataModel()) != 4) {
                        tooltip.add(DataModel.getCurrentTierSimulationCountWithKills(this.tile.getDataModel()) + "/" + DataModel.getTierRoof(this.tile.getDataModel()) + " Data collected");
                    } else {
                        tooltip.add("This data model has reached the max tier.");
                    }
                } else {
                    tooltip.add("Machine is missing a data model");
                }
                this.func_146283_a(tooltip, x + 2, y + 2);
            } else if (211 <= x && x < 220) {
                tooltip.add(f.format(this.energyStorage.getEnergyStored()) + "/" + f.format(this.energyStorage.getMaxEnergyStored()) + " RF");
                if (this.tile.hasDataModel()) {
                    MobMetaData data = DataModel.getMobMetaData(this.tile.getDataModel());
                    tooltip.add("Simulations with current data model drains " + f.format(data.getSimulationTickCost()) + "RF/t");
                }
                this.func_146283_a(tooltip, x - 90, y - 16);
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        DecimalFormat f = new DecimalFormat("0.#");
        int left = this.getGuiLeft() + 8;
        int top = this.getGuiTop();
        int spacing = 12;
        int topStart = top - 3;
        MobMetaData data = DataModel.getMobMetaData(this.tile.getDataModel());
        if (this.dataModelChanged()) {
            this.resetAnimations();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(base);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(left, top, 0, 0, 216, 141);
        this.func_73729_b(left - 22, top, 0, 141, 18, 18);
        int energyBarHeight = MathHelper.ensureRange((int)((float)this.energyStorage.getEnergyStored() / (float)(this.energyStorage.getMaxEnergyStored() - data.getSimulationTickCost()) * 87.0f), 0, 87);
        int energyBarOffset = 87 - energyBarHeight;
        this.func_73729_b(left + 203, top + 48 + energyBarOffset, 25, 141, 7, energyBarHeight);
        if (!this.tile.hasDataModel()) {
            String[] lines = new String[]{"Please insert a data model", "to begin the simulation"};
            Animation a1 = this.getAnimation("pleaseInsert1");
            Animation a2 = this.getAnimation("pleaseInsert2");
            this.animateString(lines[0], a1, null, 1, false, left + 10, topStart + spacing, 0xFFFFFF);
            this.animateString(lines[1], a2, a1, 1, false, left + 10, topStart + spacing * 2, 0xFFFFFF);
        } else if (DataModel.getTier(this.tile.getDataModel()) == 0) {
            String[] lines = new String[]{"Insufficient data in model", "please insert a basic model", "or better "};
            Animation insufData = this.getAnimation("insufData1");
            Animation insufData2 = this.getAnimation("insufData2");
            Animation insufData3 = this.getAnimation("insufData3");
            this.animateString(lines[0], insufData, null, 1, false, left + 10, topStart + spacing, 0xFFFFFF);
            this.animateString(lines[1], insufData2, insufData, 1, false, left + 10, topStart + spacing * 2, 0xFFFFFF);
            this.animateString(lines[2], insufData3, insufData2, 1, false, left + 10, topStart + spacing * 3, 0xFFFFFF);
        } else {
            if (DataModel.getTier(this.tile.getDataModel()) == 4) {
                this.func_73729_b(left + 6, top + 48, 18, 141, 7, 87);
            } else {
                int collectedData = DataModel.getCurrentTierSimulationCountWithKills(this.tile.getDataModel());
                int tierRoof = DataModel.getTierRoof(this.tile.getDataModel());
                int experienceBarHeight = (int)((float)collectedData / (float)tierRoof * 87.0f);
                int experienceBarOffset = 87 - experienceBarHeight;
                this.func_73729_b(left + 6, top + 48 + experienceBarOffset, 18, 141, 7, experienceBarHeight);
            }
            this.func_73731_b(this.renderer, "Tier: " + DataModel.getTierName(this.tile.getDataModel(), false), left + 10, topStart + spacing, 0xFFFFFF);
            this.func_73731_b(this.renderer, "Iterations: " + f.format(DataModel.getTotalSimulationCount(this.tile.getDataModel())), left + 10, topStart + spacing * 2, 0xFFFFFF);
            this.func_73731_b(this.renderer, "Pristine chance: " + DataModel.getPristineChance(this.tile.getDataModel()) + "%", left + 10, topStart + spacing * 3, 0xFFFFFF);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(defaultGui);
        this.func_73729_b(left + 20, top + 145, 0, 0, 176, 90);
        this.drawConsoleText(left, top, spacing);
    }

    private void drawConsoleText(int left, int top, int spacing) {
        if (!this.tile.hasDataModel() || DataModel.getTier(this.tile.getDataModel()) == 0) {
            this.animateString("_", this.getAnimation("blinkingUnderline"), null, 16, true, left + 21, top + 49, 0xFFFFFF);
        } else if (!this.tile.hasPolymerClay() && !this.tile.isCrafting()) {
            String[] lines = new String[]{"Cannot begin simulation", "Missing polymer medium", "_"};
            Animation a1 = this.getAnimation("inputSlotEmpty1");
            Animation a2 = this.getAnimation("inputSlotEmpty2");
            Animation a3 = this.getAnimation("blinkingUnderline1");
            this.animateString(lines[0], a1, null, 1, false, left + 21, top + 51, 0xFFFFFF);
            this.animateString(lines[1], a2, a1, 1, false, left + 21, top + 51 + spacing, 0xFFFFFF);
            this.animateString(lines[2], a3, a2, 16, true, left + 21, top + 51 + spacing * 2, 0xFFFFFF);
        } else if (!this.hasEnergy() && !this.tile.isCrafting()) {
            String[] lines = new String[]{"Cannot begin simulation", "System energy levels critical", "_"};
            Animation a1 = this.getAnimation("lowEnergy1");
            Animation a2 = this.getAnimation("lowEnergy2");
            Animation a3 = this.getAnimation("blinkingUnderline2");
            this.animateString(lines[0], a1, null, 1, false, left + 21, top + 51, 0xFFFFFF);
            this.animateString(lines[1], a2, a1, 1, false, left + 21, top + 51 + spacing, 0xFFFFFF);
            this.animateString(lines[2], a3, a2, 16, true, left + 21, top + 51 + spacing * 2, 0xFFFFFF);
        } else if (this.tile.outputIsFull() || this.tile.pristineIsFull()) {
            String[] lines = new String[]{"Cannot begin simulation", "Output or pristine buffer is full", "_"};
            Animation a1 = this.getAnimation("outputSlotFilled1");
            Animation a2 = this.getAnimation("outputSlotFilled2");
            Animation a3 = this.getAnimation("blinkingUnderline3");
            this.animateString(lines[0], a1, null, 1, false, left + 21, top + 51, 0xFFFFFF);
            this.animateString(lines[1], a2, a1, 1, false, left + 21, top + 51 + spacing, 0xFFFFFF);
            this.animateString(lines[2], a3, a2, 16, true, left + 21, top + 51 + spacing * 2, 0xFFFFFF);
        } else if (this.tile.isCrafting()) {
            this.func_73731_b(this.renderer, this.tile.percentDone + "%", left + 176, top + 123, 6478079);
            this.func_73731_b(this.renderer, this.tile.getSimulationText("simulationProgressLine1"), left + 21, top + 51, 0xFFFFFF);
            this.func_73731_b(this.renderer, this.tile.getSimulationText("simulationProgressLine1Version"), left + 124, top + 51, 0xFFFFFF);
            this.func_73731_b(this.renderer, this.tile.getSimulationText("simulationProgressLine2"), left + 21, top + 51 + spacing, 0xFFFFFF);
            this.func_73731_b(this.renderer, this.tile.getSimulationText("simulationProgressLine3"), left + 21, top + 51 + spacing * 2, 0xFFFFFF);
            this.func_73731_b(this.renderer, this.tile.getSimulationText("simulationProgressLine4"), left + 21, top + 51 + spacing * 3, 0xFFFFFF);
            this.func_73731_b(this.renderer, this.tile.getSimulationText("simulationProgressLine5"), left + 21, top + 51 + spacing * 4, 0xFFFFFF);
            this.func_73731_b(this.renderer, this.tile.getSimulationText("simulationProgressLine6"), left + 21, top + 51 + spacing * 5, 0xFFFFFF);
            this.func_73731_b(this.renderer, this.tile.getSimulationText("simulationProgressLine6Result"), left + 140, top + 51 + spacing * 5, 0xFFFFFF);
            this.func_73731_b(this.renderer, this.tile.getSimulationText("simulationProgressLine7"), left + 21, top + 51 + spacing * 6, 0xFFFFFF);
            this.func_73731_b(this.renderer, this.tile.getSimulationText("blinkingDots1"), left + 128, top + 51 + spacing * 6, 0xFFFFFF);
        } else {
            this.animateString("_", this.getAnimation("blinkingUnderline"), null, 16, true, left + 21, top + 49, 0xFFFFFF);
        }
    }

    private boolean hasEnergy() {
        return this.tile.hasEnergyForSimulation();
    }

    private boolean dataModelChanged() {
        if (ItemStack.func_77989_b((ItemStack)this.currentDataModel, (ItemStack)this.tile.getDataModel())) {
            return false;
        }
        this.currentDataModel = this.tile.getDataModel();
        return true;
    }

    private void resetAnimations() {
        this.animationList = new HashMap();
    }

    private Animation getAnimation(String key) {
        if (this.animationList.containsKey(key)) {
            return this.animationList.get(key);
        }
        this.animationList.put(key, new Animation());
        return this.animationList.get(key);
    }

    private void animateString(String string, Animation anim, Animation precedingAnim, int delay, boolean loop, int left, int top, int color) {
        String result;
        if (precedingAnim != null) {
            if (precedingAnim.hasFinished()) {
                result = anim.animate(string, delay, this.world.func_82737_E(), loop);
                this.func_73731_b(this.renderer, result, left, top, color);
            } else {
                return;
            }
        }
        result = anim.animate(string, delay, this.world.func_82737_E(), loop);
        this.func_73731_b(this.renderer, result, left, top, color);
    }
}

