/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.client.gui;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import xt9.deepmoblearning.DeepMobLearning;
import xt9.deepmoblearning.client.gui.button.ClickableZoneButton;
import xt9.deepmoblearning.client.gui.button.ItemSelectButton;
import xt9.deepmoblearning.client.gui.button.PaginationButton;
import xt9.deepmoblearning.common.energy.DeepEnergyStorage;
import xt9.deepmoblearning.common.inventory.ContainerExtractionChamber;
import xt9.deepmoblearning.common.network.ExtractionChamberChangePageMessage;
import xt9.deepmoblearning.common.network.ExtractorSetSelectedItemMessage;
import xt9.deepmoblearning.common.tiles.TileEntityExtractionChamber;
import xt9.deepmoblearning.common.util.MathHelper;
import xt9.deepmoblearning.common.util.Pagination;

public class ExtractionChamberGui
extends GuiContainer {
    private static final ResourceLocation base = new ResourceLocation("deepmoblearning", "textures/gui/extraction_chamber_base.png");
    private static final ResourceLocation defaultGui = new ResourceLocation("deepmoblearning", "textures/gui/default_gui.png");
    private static final int WIDTH = 176;
    private static final int HEIGHT = 178;
    private FontRenderer renderer;
    private TileEntityExtractionChamber tile;
    private DeepEnergyStorage energyStorage;
    private PaginationButton leftButton;
    private PaginationButton rightButton;
    private ClickableZoneButton deselectItemButton;
    private int currentPage;
    private ItemStack currentInput;

    public ExtractionChamberGui(TileEntityExtractionChamber te, InventoryPlayer inventory, World world) {
        super((Container)new ContainerExtractionChamber(te, inventory, world));
        this.tile = te;
        this.energyStorage = (DeepEnergyStorage)((Object)te.getCapability(CapabilityEnergy.ENERGY, null));
        this.renderer = Minecraft.func_71410_x().field_71466_p;
        this.field_146999_f = 176;
        this.field_147000_g = 178;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.initSelectButtons();
        this.initPaginationButtons();
        this.deselectItemButton = new ClickableZoneButton(1339, this.getGuiLeft() + 79, this.getGuiTop() + 4, 16, 16, this.field_146294_l, this.field_146295_m);
        this.currentPage = this.tile.pageHandler.getCurrentPageIndex();
        this.currentInput = this.tile.getPristine();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.tile.pristineChanged() || this.tile.getPristine().func_190926_b() || this.currentPage != this.tile.pageHandler.getCurrentPageIndex() || !ItemStack.func_179545_c((ItemStack)this.currentInput, (ItemStack)this.tile.getPristine())) {
            this.currentPage = this.tile.pageHandler.getCurrentPageIndex();
            this.currentInput = this.tile.getPristine();
            this.field_146292_n.clear();
            this.initSelectButtons();
        }
        this.initPaginationButtons();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(base);
        this.drawLootList();
        this.drawButtonHoverText();
        this.drawSelectedItem();
        int x = mouseX - this.field_147003_i;
        int y = mouseY - this.field_147009_r;
        NumberFormat f = NumberFormat.getNumberInstance(Locale.ENGLISH);
        ArrayList<String> tooltip = new ArrayList<String>();
        if (10 <= y && y < 63 && 6 <= x && x < 13) {
            tooltip.add(f.format(this.energyStorage.getEnergyStored()) + "/" + f.format(this.energyStorage.getMaxEnergyStored()) + " RF");
            tooltip.add("Operational cost: " + f.format(this.tile.energyCost) + " RF/t");
            this.func_146283_a(tooltip, x - 16, y - 16);
        }
        if (!this.tile.resultingItem.func_190926_b()) {
            ArrayList<String> deselectTooltip = new ArrayList<String>();
            deselectTooltip.add("Click to remove autocraft");
            this.deselectItemButton.setTooltip(deselectTooltip);
        }
    }

    private void drawButtonHoverText() {
        for (GuiButton aButtonList : this.field_146292_n) {
            ItemSelectButton btn;
            if (!(aButtonList instanceof ItemSelectButton) || !(btn = (ItemSelectButton)aButtonList).func_146115_a()) continue;
            this.renderer.func_78276_b(btn.stack.func_82833_r(), 2, -10, 0xFFFFFF);
        }
    }

    private void drawSelectedItem() {
        this.drawItemStackWithCount(79, 4, this.tile.resultingItem, this.tile.resultingItem.func_190916_E());
    }

    private void drawLootList() {
        Map<Integer, ItemStack> pageList = this.getPaginatedItems();
        int i = 0;
        int rowIndex = 0;
        Iterator<Map.Entry<Integer, ItemStack>> it = pageList.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, ItemStack> pair = it.next();
            ItemStack stack = pair.getValue();
            if (i <= 2) {
                this.drawItemStackWithCount(17 + rowIndex * 19, 9, stack, stack.func_190916_E());
            } else if (i <= 5) {
                this.drawItemStackWithCount(17 + rowIndex * 19, 28, stack, stack.func_190916_E());
            } else if (i <= 8) {
                this.drawItemStackWithCount(17 + rowIndex * 19, 47, stack, stack.func_190916_E());
            }
            ++i;
            rowIndex = rowIndex == 2 ? 0 : rowIndex + 1;
            it.remove();
        }
    }

    private void initSelectButtons() {
        Map<Integer, ItemStack> pageList = this.getPaginatedItems();
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int i = 0;
        int rowIndex = 0;
        Iterator<Map.Entry<Integer, ItemStack>> it = pageList.entrySet().iterator();
        boolean foundSelected = false;
        while (it.hasNext()) {
            boolean selected;
            Map.Entry<Integer, ItemStack> pair = it.next();
            ItemStack loot = pair.getValue();
            boolean bl = selected = !foundSelected && ItemStack.func_179545_c((ItemStack)loot, (ItemStack)this.tile.resultingItem);
            if (selected) {
                foundSelected = true;
            }
            if (i <= 2) {
                this.field_146292_n.add(new ItemSelectButton(i + 9 * this.tile.pageHandler.getCurrentPageIndex(), left + 16 + rowIndex * 19, top + 8, selected, loot));
            } else if (i <= 5) {
                this.field_146292_n.add(new ItemSelectButton(i + 9 * this.tile.pageHandler.getCurrentPageIndex(), left + 16 + rowIndex * 19, top + 27, selected, loot));
            } else if (i <= 8) {
                this.field_146292_n.add(new ItemSelectButton(i + 9 * this.tile.pageHandler.getCurrentPageIndex(), left + 16 + rowIndex * 19, top + 46, selected, loot));
            }
            ++i;
            rowIndex = rowIndex == 2 ? 0 : rowIndex + 1;
            it.remove();
        }
    }

    private void initPaginationButtons() {
        Pagination p;
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        this.leftButton = new PaginationButton(1337, left + 13, top + 66, 0, p, (p = this.tile.pageHandler).getCurrentPageIndex() == p.getFirstPageIndex());
        this.rightButton = new PaginationButton(1338, left + 44, top + 66, 1, p, p.getCurrentPageIndex() == p.getLastPageIndex());
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.leftButton.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
            this.func_146284_a(this.leftButton);
        } else if (this.rightButton.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
            this.func_146284_a(this.rightButton);
        } else if (this.deselectItemButton.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
            this.func_146284_a(this.deselectItemButton);
        }
    }

    protected void func_146284_a(GuiButton pressedButton) throws IOException {
        if (pressedButton instanceof ItemSelectButton) {
            ItemSelectButton btn = (ItemSelectButton)pressedButton;
            if (btn.isSelected()) {
                btn.setSelected(false);
                DeepMobLearning.network.sendToServer((IMessage)new ExtractorSetSelectedItemMessage(-1));
            } else {
                this.clearSelectedItems();
                btn.setSelected(true);
                DeepMobLearning.network.sendToServer((IMessage)new ExtractorSetSelectedItemMessage(pressedButton.field_146127_k));
            }
        }
        if (pressedButton instanceof PaginationButton) {
            if (((PaginationButton)pressedButton).isLeftArrow()) {
                DeepMobLearning.network.sendToServer((IMessage)new ExtractionChamberChangePageMessage("decrease"));
            } else {
                DeepMobLearning.network.sendToServer((IMessage)new ExtractionChamberChangePageMessage("increase"));
            }
            this.field_146292_n.clear();
            this.initSelectButtons();
            this.initPaginationButtons();
        }
        if (pressedButton.field_146127_k == this.deselectItemButton.field_146127_k) {
            this.clearSelectedItems();
            DeepMobLearning.network.sendToServer((IMessage)new ExtractorSetSelectedItemMessage(-1));
        }
    }

    private void clearSelectedItems() {
        for (GuiButton b : this.field_146292_n) {
            if (!(b instanceof ItemSelectButton)) continue;
            ((ItemSelectButton)b).setSelected(false);
        }
    }

    private Map<Integer, ItemStack> getPaginatedItems() {
        TreeMap<Integer, ItemStack> list = new TreeMap<Integer, ItemStack>();
        int count = 0;
        for (int i = this.tile.pageHandler.getCurrentPageIndex() * 9; i < this.tile.getLootFromPristine().size(); ++i) {
            if (count < 9) {
                list.put(i, this.tile.getItemFromList(i));
            }
            ++count;
        }
        return list;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(base);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(left, top, 0, 0, 176, 83);
        int craftingBarHeight = (int)((float)this.tile.percentDone / 50.0f * 36.0f);
        int craftingBarOffset = 36 - craftingBarHeight;
        this.func_73729_b(left + 84, top + 22 + craftingBarOffset, 7, 83, 6, craftingBarHeight);
        int energyBarHeight = MathHelper.ensureRange((int)((float)this.energyStorage.getEnergyStored() / (float)(this.energyStorage.getMaxEnergyStored() - this.tile.energyCost) * 53.0f), 0, 53);
        int energyBarOffset = 53 - energyBarHeight;
        this.func_73729_b(left + 6, top + 10 + energyBarOffset, 0, 83, 7, energyBarHeight);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(defaultGui);
        this.func_73729_b(left, top + 88, 0, 0, 176, 90);
        if (!this.tile.resultingItem.func_190926_b()) {
            this.deselectItemButton.func_191745_a(this.field_146297_k, mouseX, mouseY, this.field_146297_k.func_184121_ak());
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawPaginationButtons(mouseX, mouseY);
        this.func_191948_b(mouseX, mouseY);
    }

    private void drawPaginationButtons(int mouseX, int mouseY) {
        this.leftButton.func_191745_a(this.field_146297_k, mouseX, mouseY, 0.0f);
        this.rightButton.func_191745_a(this.field_146297_k, mouseX, mouseY, 0.0f);
    }

    private void drawItemStackWithCount(int x, int y, ItemStack stack, int count) {
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(this.field_146289_q, stack, x - 1, y - 1, count != 1 ? count + "" : "");
    }
}

