/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearningbm.plugin.jei;

import java.text.NumberFormat;
import java.util.Locale;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import xt9.deepmoblearning.common.util.DataModel;
import xt9.deepmoblearning.common.util.Tier;
import xt9.deepmoblearningbm.plugin.jei.DigitalAgonizerRecipe;
import xt9.deepmoblearningbm.util.EssenceHelper;

public class DigitalAgonizerRecipeWrapper
implements IRecipeWrapper {
    private int tier = 1;
    private long ticks = 0L;
    private long lastWorldTime;
    private final NonNullList<ItemStack> dataModels;
    private final NonNullList<ItemStack> inputs = NonNullList.func_191196_a();
    private final FluidStack output;

    public DigitalAgonizerRecipeWrapper(DigitalAgonizerRecipe recipe) {
        this.dataModels = recipe.dataModels;
        this.inputs.addAll(this.dataModels);
        this.output = recipe.essence;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.inputs);
        ingredients.setOutput(FluidStack.class, (Object)this.output);
    }

    private void cycleTierAndModel() {
        this.tier = Tier.isMaxTier((int)this.tier) ? 1 : ++this.tier;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.render(minecraft);
        if (this.lastWorldTime == minecraft.field_71441_e.func_82737_E()) {
            return;
        }
        ++this.ticks;
        this.lastWorldTime = minecraft.field_71441_e.func_82737_E();
        if (this.ticks % 40L == 0L) {
            this.cycleTierAndModel();
        }
    }

    public void render(Minecraft minecraft) {
        FontRenderer render = minecraft.field_71466_p;
        String tierName = Tier.getTierName((int)this.tier, (boolean)false);
        render.func_175063_a(tierName, 2.0f, 27.0f, 0xFFFFFF);
        NumberFormat f = NumberFormat.getNumberInstance(Locale.ENGLISH);
        DataModel.setTier((ItemStack)((ItemStack)this.dataModels.get(0)), (int)this.tier);
        String amount = f.format(EssenceHelper.getFillAmount((ItemStack)this.dataModels.get(0), 1.0)) + "mB";
        render.func_175063_a(amount, (float)(114 - render.func_78256_a(amount)), 27.0f, 0xFFFFFF);
    }
}

