/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network;

import moze_intel.projecte.PECore;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class ThreadCheckUpdate
extends Thread {
    private static volatile boolean hasRun = false;
    private static final String curseURL = "https://minecraft.curseforge.com/projects/projecte/files";

    public ThreadCheckUpdate() {
        this.setName("ProjectE Update Checker Notifier");
    }

    @Override
    public void run() {
        ForgeVersion.CheckResult res;
        hasRun = true;
        ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get("projecte");
        ForgeVersion.CheckResult result = null;
        int tries = 0;
        do {
            res = ForgeVersion.getResult((ModContainer)container);
            if (res.status != ForgeVersion.Status.PENDING) {
                result = res;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (result == null && ++tries < 10);
        if (result == null) {
            PECore.LOGGER.info("Update check failed.");
            return;
        }
        if (result.status == ForgeVersion.Status.UP_TO_DATE) {
            PECore.LOGGER.info("Mod is updated.");
        } else if (result.status == ForgeVersion.Status.OUTDATED) {
            PECore.LOGGER.info("Mod is outdated! Check {} to get the latest version ({}).", (Object)curseURL, (Object)result.target);
            res = result;
            Minecraft.func_71410_x().func_152344_a(() -> {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("pe.update.available", new Object[]{res.target}));
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("pe.update.getit", new Object[0]));
                TextComponentString link = new TextComponentString(curseURL);
                link.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, curseURL));
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)link);
            });
        }
    }

    public static boolean hasRun() {
        return hasRun;
    }
}

