/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.zensummoning;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.mc1120.data.NBTConverter;
import java.util.Random;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.zensummoning.MobInfo")
@ZenRegister
public class MobInfo {
    private int count = 1;
    private NBTTagCompound data = new NBTTagCompound();
    private ResourceLocation mob = new ResourceLocation("");
    private BlockPos offset = new BlockPos(0.5, 0.0, 0.5);
    private BlockPos spread = new BlockPos(0, 0, 0);

    private MobInfo() {
    }

    MobInfo(NBTTagCompound data, ResourceLocation mob, BlockPos offset, BlockPos spread) {
        this.data = data;
        this.mob = mob;
        this.offset = offset;
        this.spread = spread;
    }

    private void validateEgg() {
        if (!EntityList.field_75627_a.containsKey(this.mob)) {
            Random r = new Random(this.mob.hashCode());
            EntityList.EntityEggInfo egg = new EntityList.EntityEggInfo(this.mob, r.nextInt(0xFFFFFF), r.nextInt(0xFFFFFF));
            EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(this.mob);
            if (entry != null) {
                entry.setEgg(egg);
            }
            EntityList.field_75627_a.put(this.mob, egg);
        }
    }

    @ZenMethod
    public static MobInfo create() {
        return new MobInfo();
    }

    public BlockPos getSpread() {
        return this.spread;
    }

    public int getCount() {
        return this.count;
    }

    @ZenMethod
    public MobInfo setCount(int count) {
        this.count = count;
        return this;
    }

    public NBTTagCompound getData() {
        return this.data;
    }

    @ZenMethod
    public MobInfo setData(IData data) {
        this.data = (NBTTagCompound)NBTConverter.from((IData)data);
        return this;
    }

    public ResourceLocation getMob() {
        return this.mob;
    }

    @ZenMethod
    public MobInfo setMob(String mob) {
        this.mob = new ResourceLocation(mob);
        this.validateEgg();
        return this;
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    @ZenMethod
    public MobInfo setOffset(int x, int y, int z) {
        this.offset = new BlockPos(x, y, z);
        return this;
    }

    @ZenMethod
    public MobInfo setSpread(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            System.out.println("Spread operates as a distance factor on each x,y,z plane, distances shouldn't be negative.");
        }
        this.spread = new BlockPos(Math.abs(x), Math.abs(y), Math.abs(z));
        return this;
    }
}

